/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.serialization;

import com.hazelcast.hibernate.serialization.Hibernate41CacheEntrySerializer;
import com.hazelcast.hibernate.serialization.Hibernate42CacheEntrySerializer;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.UnsafeHelper;
import com.hazelcast.nio.serialization.Serializer;
import com.hazelcast.nio.serialization.SerializerHook;

public class Hibernate4CacheEntrySerializerHook
implements SerializerHook {
    private static final String SKIP_INIT_MSG = "Hibernate4 not available, skipping serializer initialization";
    private final Class<?> cacheEntryClass;

    public Hibernate4CacheEntrySerializerHook() {
        Class<?> cacheEntryClass = null;
        if (UnsafeHelper.UNSAFE_AVAILABLE) {
            try {
                cacheEntryClass = Class.forName("org.hibernate.cache.spi.entry.CacheEntry");
            }
            catch (Exception e) {
                Logger.getLogger(Hibernate4CacheEntrySerializerHook.class).finest(SKIP_INIT_MSG);
            }
        }
        this.cacheEntryClass = cacheEntryClass;
    }

    public Class getSerializationType() {
        return this.cacheEntryClass;
    }

    public Serializer createSerializer() {
        if (this.cacheEntryClass == null) {
            return null;
        }
        if (this.cacheEntryClass.isInterface()) {
            return new Hibernate42CacheEntrySerializer();
        }
        return new Hibernate41CacheEntrySerializer();
    }

    public boolean isOverwritable() {
        return true;
    }
}

