/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate;

import java.time.Duration;
import java.util.Map;
import java.util.Properties;
import org.hibernate.internal.util.config.ConfigurationException;
import org.hibernate.internal.util.config.ConfigurationHelper;

public final class CacheEnvironment {
    public static final String CONFIG_FILE_PATH = "hibernate.cache.hazelcast.configuration_file_path";
    public static final String USE_NATIVE_CLIENT = "hibernate.cache.hazelcast.use_native_client";
    public static final String NATIVE_CLIENT_ADDRESS = "hibernate.cache.hazelcast.native_client_address";
    public static final String NATIVE_CLIENT_CLUSTER_NAME = "hibernate.cache.hazelcast.native_client_cluster_name";
    public static final String NATIVE_CLIENT_INSTANCE_NAME = "hibernate.cache.hazelcast.native_client_instance_name";
    public static final String SHUTDOWN_ON_STOP = "hibernate.cache.hazelcast.shutdown_on_session_factory_close";
    public static final String FALLBACK = "hibernate.cache.hazelcast.fallback";
    public static final String CLUSTER_TIMEOUT = "hibernate.cache.hazelcast.cluster_timeout";
    public static final String INITIAL_BACKOFF_MS = "hibernate.cache.hazelcast.initial_backoff";
    public static final String MAX_BACKOFF_MS = "hibernate.cache.hazelcast.max_backoff";
    public static final String BACKOFF_MULTIPLIER = "hibernate.cache.hazelcast.backoff_multiplier";
    public static final String HAZELCAST_INSTANCE_NAME = "hibernate.cache.hazelcast.instance_name";
    public static final String HAZELCAST_SHUTDOWN_HOOK_ENABLED = "hazelcast.shutdownhook.enabled";
    public static final String HAZELCAST_FACTORY = "hibernate.cache.hazelcast.factory";
    private static final Duration DEFAULT_CACHE_TIMEOUT = Duration.ofHours(1L);
    private static final Duration DEFAULT_MAX_BACKOFF = Duration.ofMillis(35000L);
    private static final Duration DEFAULT_INITIAL_BACKOFF = Duration.ofMillis(2000L);
    private static final double DEFAULT_BACKOFF_MULTIPLIER = 1.5;

    private CacheEnvironment() {
    }

    public static String getConfigFilePath(Properties props) {
        return ConfigurationHelper.getString((String)CONFIG_FILE_PATH, (Map)props, (String)null);
    }

    public static String getInstanceName(Properties props) {
        return ConfigurationHelper.getString((String)HAZELCAST_INSTANCE_NAME, (Map)props, (String)null);
    }

    public static boolean isNativeClient(Properties props) {
        return ConfigurationHelper.getBoolean((String)USE_NATIVE_CLIENT, (Map)props, (boolean)false);
    }

    public static int getDefaultCacheTimeoutInMillis() {
        return (int)DEFAULT_CACHE_TIMEOUT.toMillis();
    }

    public static boolean shutdownOnStop(Properties props, boolean defaultValue) {
        return ConfigurationHelper.getBoolean((String)SHUTDOWN_ON_STOP, (Map)props, (boolean)defaultValue);
    }

    public static Duration getInitialBackoff(Properties props) {
        int initialBackOff = ConfigurationHelper.getInt((String)INITIAL_BACKOFF_MS, (Map)props, (int)((int)DEFAULT_INITIAL_BACKOFF.toMillis()));
        if (initialBackOff <= 0) {
            throw new ConfigurationException("Invalid initial backoff [" + initialBackOff + "]");
        }
        return Duration.ofMillis(initialBackOff);
    }

    public static Duration getMaxBackoff(Properties props) {
        int maxBackoff = ConfigurationHelper.getInt((String)MAX_BACKOFF_MS, (Map)props, (int)((int)DEFAULT_MAX_BACKOFF.toMillis()));
        if (maxBackoff <= 0) {
            throw new ConfigurationException("Invalid max backoff [" + maxBackoff + "]");
        }
        return Duration.ofMillis(maxBackoff);
    }

    public static double getBackoffMultiplier(Properties props) {
        double backoffMultiplier = Double.parseDouble(ConfigurationHelper.getString((String)BACKOFF_MULTIPLIER, (Map)props, (String)String.valueOf(1.5)));
        if (backoffMultiplier <= 0.0) {
            throw new ConfigurationException("Invalid backoff multiplier [" + backoffMultiplier + "]");
        }
        return backoffMultiplier;
    }

    public static Duration getClusterTimeout(Properties props) {
        int timeoutMillis = ConfigurationHelper.getInt((String)CLUSTER_TIMEOUT, (Map)props, (int)Integer.MAX_VALUE);
        if (timeoutMillis <= 0) {
            throw new ConfigurationException("Invalid cluster timeout [" + timeoutMillis + "]");
        }
        return Duration.ofMillis(timeoutMillis);
    }

    public static boolean getFallback(Map<String, Object> props) {
        return ConfigurationHelper.getBoolean((String)FALLBACK, props, (boolean)true);
    }
}

