/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.local;

import com.hazelcast.hibernate.shaded.caffeine.cache.Cache;
import com.hazelcast.hibernate.shaded.caffeine.cache.Policy;
import com.hazelcast.internal.util.MemoryInfoAccessor;
import com.hazelcast.internal.util.RuntimeMemoryInfoAccessor;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class FreeHeapBasedCacheEvictor
implements AutoCloseable {
    private static final int TERMINATE_TIMEOUT_SECONDS = 5;
    private static final Duration DEFAULT_EVICTION_DELAY = Duration.ofSeconds(1L);
    private static final int EVICTION_BATCH_SIZE = 15;
    private static final ILogger LOG = Logger.getLogger(FreeHeapBasedCacheEvictor.class);
    private final ScheduledExecutorService executorService;
    private final MemoryInfoAccessor memoryInfoAccessor;
    private final Duration evictionDelay;
    private final Map<String, ScheduledFuture<?>> tasks = new ConcurrentHashMap();

    public FreeHeapBasedCacheEvictor() {
        this(Executors.newSingleThreadScheduledExecutor(FreeHeapBasedCacheEvictor.defaultThreadFactory()), (MemoryInfoAccessor)new RuntimeMemoryInfoAccessor(), DEFAULT_EVICTION_DELAY);
    }

    FreeHeapBasedCacheEvictor(ScheduledExecutorService executorService, MemoryInfoAccessor memoryInfoAccessor, Duration evictionDelay) {
        this.executorService = executorService;
        this.memoryInfoAccessor = memoryInfoAccessor;
        this.evictionDelay = evictionDelay;
    }

    void start(String cacheName, Cache<?, ?> cache, long minimalHeapSizeInMB) {
        Policy.Eviction<?, ?> eviction = cache.policy().eviction().orElseThrow(() -> new IllegalStateException("Eviction for cache '" + cacheName + "' not enabled"));
        LOG.info("Starting free-heap-size-based eviction of cache '" + cacheName + "'");
        ScheduledFuture<?> evictingTask = this.executorService.scheduleWithFixedDelay(() -> {
            if (this.freeHeapTooSmall(minimalHeapSizeInMB)) {
                eviction.coldest(15).forEach((key, value) -> cache.invalidate(key));
            }
        }, 0L, this.evictionDelay.toMillis(), TimeUnit.MILLISECONDS);
        this.tasks.put(cacheName, evictingTask);
    }

    public void stop(String cacheName) {
        ScheduledFuture<?> task = this.tasks.remove(cacheName);
        if (task == null) {
            throw new IllegalStateException("Evicting task for cache '" + cacheName + "' not found");
        }
        task.cancel(false);
    }

    static ThreadFactory defaultThreadFactory() {
        AtomicInteger counter = new AtomicInteger();
        return r -> new Thread(r, FreeHeapBasedCacheEvictor.class.getSimpleName() + "-free-heap-evictor-" + counter.getAndIncrement());
    }

    private boolean freeHeapTooSmall(long minimalHeapSizeInMB) {
        return this.availableMemoryInBytes() < minimalHeapSizeInMB;
    }

    private long availableMemoryInBytes() {
        return this.memoryInfoAccessor.getFreeMemory() + this.memoryInfoAccessor.getMaxMemory() - this.memoryInfoAccessor.getTotalMemory();
    }

    @Override
    public void close() {
        LOG.info("Shutting down " + FreeHeapBasedCacheEvictor.class.getSimpleName());
        this.executorService.shutdown();
        try {
            boolean success = this.executorService.awaitTermination(5L, TimeUnit.SECONDS);
            if (!success) {
                LOG.warning("ExecutorService awaitTermination could not completed gracefully in 5 seconds. Terminating forcefully.");
                this.executorService.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.warning("ExecutorService awaitTermination is interrupted. Terminating forcefully.", (Throwable)e);
            this.executorService.shutdownNow();
        }
        LOG.info("Shutdown of " + FreeHeapBasedCacheEvictor.class.getSimpleName() + " completed");
    }
}

