/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.sdk.deploy;

import com.heroku.sdk.deploy.BuildsDeployer;
import com.heroku.sdk.deploy.Deployer;
import com.heroku.sdk.deploy.SlugDeployer;
import com.heroku.sdk.deploy.utils.Logger;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class App
implements Logger {
    protected Deployer deployer;
    protected String name;

    public App(String name) throws IOException {
        this("heroku-deploy", name, new File(System.getProperty("user.dir")), App.createTempDir(), new ArrayList<String>());
    }

    public App(String buildPackDesc, String name, File rootDir, File targetDir, List<String> buildpacks) {
        this.deployer = new BuildsDeployer(buildPackDesc, name, rootDir, targetDir, buildpacks, this);
    }

    @Override
    public void logInfo(String message) {
    }

    @Override
    public void logDebug(String message) {
    }

    @Override
    public void logWarn(String message) {
    }

    @Override
    public void logUploadProgress(Long uploaded, Long contentLength) {
        this.logDebug("Uploaded " + uploaded + "/" + contentLength);
    }

    @Override
    public Boolean isUploadProgressEnabled() {
        return false;
    }

    public String getName() {
        return this.deployer.getName();
    }

    protected void prepare(List<File> includedFiles, Map<String, String> processTypes) throws IOException {
        this.deployer.prepare(includedFiles, processTypes);
    }

    protected void deploy(List<File> includedFiles, Map<String, String> configVars, String jdkVersion, URL jdkUrl, String stack, Map<String, String> processTypes, String tarFilename) throws Exception {
        this.prepare(includedFiles, processTypes);
        this.deployer.deploy(configVars, jdkVersion, jdkUrl, stack, processTypes, tarFilename);
    }

    public void deploy(List<File> includedFiles, Map<String, String> configVars, String jdkVersion, String stack, Map<String, String> processTypes, String tarFilename) throws Exception {
        this.deploy(includedFiles, configVars, jdkVersion, null, stack, processTypes, tarFilename);
    }

    public void deploy(List<File> includedFiles, Map<String, String> configVars, URL jdkUrl, String stack, Map<String, String> processTypes, String tarFilename) throws Exception {
        this.deploy(includedFiles, configVars, jdkUrl.toString(), jdkUrl, stack, processTypes, tarFilename);
    }

    protected void deploySlug(List<File> includedFiles, Map<String, String> configVars, String jdkVersion, URL jdkUrl, String stack, Map<String, String> processTypes, String tarFilename) throws Exception {
        this.deployer = new SlugDeployer(this.deployer.getBuildPackDesc(), this.getName(), this.getRootDir(), this.deployer.getTargetDir(), this);
        this.deploy(includedFiles, configVars, jdkVersion, jdkUrl, stack, processTypes, tarFilename);
    }

    public void deploySlug(List<File> includedFiles, Map<String, String> configVars, String jdkVersion, String stack, Map<String, String> processTypes, String tarFilename) throws Exception {
        this.deploySlug(includedFiles, configVars, jdkVersion, null, stack, processTypes, tarFilename);
    }

    public void deploySlug(List<File> includedFiles, Map<String, String> configVars, URL jdkUrl, String stack, Map<String, String> processTypes, String tarFilename) throws Exception {
        this.deploySlug(includedFiles, configVars, jdkUrl.toString(), jdkUrl, stack, processTypes, tarFilename);
    }

    public void releaseSlug(String slugFilename, Map<String, String> processTypes, Map<String, String> configVars, String stack) throws Exception {
        SlugDeployer slugDeployer = new SlugDeployer(this.deployer.getBuildPackDesc(), this.getName(), this.getRootDir(), this.deployer.getTargetDir(), this);
        this.deployer = slugDeployer;
        slugDeployer.releaseSlug(slugFilename, processTypes, configVars, stack);
    }

    protected void createSlug(String slugFilename, List<File> includedFiles, String jdkVersion, URL jdkUrl, String stack) throws Exception {
        SlugDeployer slugDeployer = new SlugDeployer(this.deployer.getBuildPackDesc(), this.getName(), this.getRootDir(), this.deployer.getTargetDir(), this);
        this.deployer = slugDeployer;
        this.prepare(includedFiles, new HashMap<String, String>());
        slugDeployer.createSlug(slugFilename, jdkVersion, jdkUrl, stack);
    }

    public void createSlug(String slugFilename, List<File> includedFiles, String jdkVersion, String stack) throws Exception {
        this.createSlug(slugFilename, includedFiles, jdkVersion, null, stack);
    }

    public void createSlug(String slugFilename, List<File> includedFiles, URL jdkUrl, String stack) throws Exception {
        this.createSlug(slugFilename, includedFiles, jdkUrl.toString(), jdkUrl, stack);
    }

    protected static File createTempDir() throws IOException {
        return Files.createTempDirectory("heroku-deploy", new FileAttribute[0]).toFile();
    }

    protected String relativize(File path) {
        return this.deployer.relativize(path);
    }

    protected File getAppDir() {
        return this.deployer.getAppDir();
    }

    protected File getRootDir() {
        return this.deployer.getRootDir();
    }
}

