/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.sdk.deploy;

import com.heroku.sdk.deploy.SystemSettings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.FileUtils;

public class Toolbelt {
    public static String getApiToken() throws IOException, InterruptedException, ExecutionException, TimeoutException {
        try {
            return Toolbelt.readNetrcFile().get("api.heroku.com").get("password");
        }
        catch (Throwable e) {
            return Toolbelt.runHerokuCommand(new File(System.getProperty("user.home"), "auth:token"), new String[0]);
        }
    }

    public static String getAppName(File projectDir) throws IOException, InterruptedException, ExecutionException, TimeoutException {
        Map<String, String> remotes = Toolbelt.getGitRemotes(projectDir);
        if (remotes.containsKey("heroku")) {
            return Toolbelt.parseAppFromRemote(remotes.get("heroku"));
        }
        throw new RuntimeException("No 'heroku' remote found.");
    }

    private static String runHerokuCommand(final File projectDir, final String ... command) throws InterruptedException, ExecutionException, TimeoutException {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        FutureTask<String> future = new FutureTask<String>(new Callable<String>(){

            @Override
            public String call() throws IOException {
                String line;
                String herokuCmd = SystemSettings.isWindows() != false ? "heroku.bat" : "heroku";
                String[] fullCommand = new String[command.length + 1];
                fullCommand[0] = herokuCmd;
                System.arraycopy(command, 0, fullCommand, 1, command.length);
                ProcessBuilder pb = new ProcessBuilder(new String[0]).command(fullCommand);
                pb.directory(projectDir);
                Process p = pb.start();
                BufferedReader bri = new BufferedReader(new InputStreamReader(p.getInputStream()));
                String output = "";
                while ((line = bri.readLine()) != null) {
                    output = output + line;
                }
                return output;
            }
        });
        executor.execute(future);
        return future.get(10L, TimeUnit.SECONDS);
    }

    private static Map<String, String> getGitRemotes(File projectDir) throws IOException {
        File gitConfigFile = new File(new File(projectDir, ".git"), "config");
        if (!gitConfigFile.exists()) {
            throw new FileNotFoundException(gitConfigFile.toString());
        }
        HashMap<String, String> remotes = new HashMap<String, String>();
        String remote = null;
        for (String line : FileUtils.readLines((File)gitConfigFile)) {
            if (line == null || line.trim().isEmpty()) continue;
            if (line.startsWith("[remote")) {
                remote = line.replace("[remote \"", "").replace("\"]", "");
                continue;
            }
            if (remote == null || !line.contains("url =")) continue;
            String[] keyValue = line.trim().split("=");
            remotes.put(remote, keyValue[1].trim());
        }
        return remotes;
    }

    private static String parseAppFromRemote(String remote) {
        if (remote.startsWith("https")) {
            return remote.replace("https://git.heroku.com/", "").replace(".git", "");
        }
        if (remote.startsWith("git")) {
            return remote.replace("git@heroku.com:", "").replace(".git", "");
        }
        return null;
    }

    private static Map<String, Map<String, String>> readNetrcFile() throws IOException {
        String netrcFilename;
        String homeDir = System.getProperty("user.home");
        File netrcFile = new File(new File(homeDir), netrcFilename = SystemSettings.isWindows() != false ? "_netrc" : ".netrc");
        if (!netrcFile.exists()) {
            throw new FileNotFoundException(netrcFile.toString());
        }
        HashMap<String, Map<String, String>> netrcMap = new HashMap<String, Map<String, String>>();
        String machine = null;
        HashMap<String, String> entry = new HashMap<String, String>();
        for (String line : FileUtils.readLines((File)netrcFile)) {
            if (line == null || line.trim().isEmpty()) continue;
            if (line.startsWith("machine")) {
                if (null != machine) {
                    netrcMap.put(machine, entry);
                    entry = new HashMap();
                }
                machine = line.trim().split(" ")[1];
                continue;
            }
            String[] keyValue = line.trim().split(" ");
            entry.put(keyValue[0], keyValue[1]);
        }
        if (null != machine) {
            netrcMap.put(machine, entry);
        }
        return netrcMap;
    }
}

