/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.sdk.deploy.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.heroku.sdk.deploy.utils.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class RestClient {
    public static Map get(String urlStr, Map<String, String> headers) throws IOException {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpGet request = new HttpGet(urlStr);
        for (String key : headers.keySet()) {
            String value = headers.get(key);
            request.setHeader(key, value);
        }
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);){
            Map map = (Map)RestClient.handleResponse(response, Map.class);
            return map;
        }
    }

    public static void get(String urlStr, Map<String, String> headers, OutputLogger logger) throws IOException {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpGet request = new HttpGet(urlStr);
        for (String key : headers.keySet()) {
            String value = headers.get(key);
            request.setHeader(key, value);
        }
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);){
            RestClient.handleResponse(response, logger);
        }
    }

    public static List put(String urlStr, String data, Map<String, String> headers) throws IOException {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPut request = new HttpPut(urlStr);
        for (String key : headers.keySet()) {
            String value = headers.get(key);
            request.setHeader(key, value);
        }
        StringEntity body = new StringEntity(data);
        body.setContentType("application/json");
        body.setContentEncoding("UTF-8");
        request.setEntity((HttpEntity)body);
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);){
            List list = (List)RestClient.handleResponse(response, List.class);
            return list;
        }
    }

    public static Map post(String urlStr, Map<String, String> headers) throws IOException {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost request = new HttpPost(urlStr);
        for (String key : headers.keySet()) {
            String value = headers.get(key);
            request.setHeader(key, value);
        }
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);){
            Map map = (Map)RestClient.handleResponse(response, Map.class);
            return map;
        }
    }

    public static Map post(String urlStr, String data, Map<String, String> headers) throws IOException {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost request = new HttpPost(urlStr);
        for (String key : headers.keySet()) {
            String value = headers.get(key);
            request.setHeader(key, value);
        }
        StringEntity body = new StringEntity(data);
        body.setContentType("application/json");
        body.setContentEncoding("UTF-8");
        request.setEntity((HttpEntity)body);
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);){
            Map map = (Map)RestClient.handleResponse(response, Map.class);
            return map;
        }
    }

    public static Map patch(String urlStr, String data, Map<String, String> headers) throws IOException {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPatch request = new HttpPatch(urlStr);
        for (String key : headers.keySet()) {
            String value = headers.get(key);
            request.setHeader(key, value);
        }
        StringEntity body = new StringEntity(data);
        body.setContentType("application/json");
        body.setContentEncoding("UTF-8");
        request.setEntity((HttpEntity)body);
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);){
            Map map = (Map)RestClient.handleResponse(response, Map.class);
            return map;
        }
    }

    public static void put(String urlStr, File file, Logger uploadListener) throws IOException {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPut request = new HttpPut(urlStr);
        FileEntityWithProgress body = new FileEntityWithProgress(file, uploadListener);
        request.setEntity((HttpEntity)body);
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);){
            StatusLine statusLine = response.getStatusLine();
            if (statusLine.getStatusCode() >= 300) {
                throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
            }
        }
    }

    private static Object handleResponse(CloseableHttpResponse response, Class returnType) throws IOException {
        StatusLine statusLine = response.getStatusLine();
        HttpEntity entity = response.getEntity();
        if (statusLine.getStatusCode() >= 300) {
            throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
        }
        if (entity == null) {
            throw new ClientProtocolException("Response contains no content");
        }
        String output = RestClient.readStream(entity.getContent());
        return new ObjectMapper().readValue(output, returnType);
    }

    private static void handleResponse(CloseableHttpResponse response, OutputLogger logger) throws IOException {
        StatusLine statusLine = response.getStatusLine();
        HttpEntity entity = response.getEntity();
        if (statusLine.getStatusCode() >= 300) {
            throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
        }
        if (entity == null) {
            throw new ClientProtocolException("Response contains no content");
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(entity.getContent()));
        String tmp = reader.readLine();
        while (tmp != null) {
            logger.log(tmp);
            tmp = reader.readLine();
        }
    }

    private static String readStream(InputStream is) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        String output = "";
        String tmp = reader.readLine();
        while (tmp != null) {
            output = output + tmp;
            tmp = reader.readLine();
        }
        return output;
    }

    private static class OutputStreamProgress
    extends OutputStream {
        private OutputStream outStream;
        private FileEntityWithProgress fileEntity;
        private volatile long bytesWritten = 0L;

        public OutputStreamProgress(OutputStream outStream, FileEntityWithProgress fileEntity) {
            this.outStream = outStream;
            this.fileEntity = fileEntity;
        }

        @Override
        public void write(int b) throws IOException {
            this.outStream.write(b);
            ++this.bytesWritten;
            this.fileEntity.updateProgress(this.getWrittenLength());
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.outStream.write(b);
            this.bytesWritten += (long)b.length;
            this.fileEntity.updateProgress(this.getWrittenLength());
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.outStream.write(b, off, len);
            this.bytesWritten += (long)len;
            this.fileEntity.updateProgress(this.getWrittenLength());
        }

        @Override
        public void flush() throws IOException {
            this.outStream.flush();
        }

        @Override
        public void close() throws IOException {
            this.outStream.close();
        }

        public long getWrittenLength() {
            return this.bytesWritten;
        }
    }

    private static class FileEntityWithProgress
    extends FileEntity {
        private OutputStreamProgress outStream;
        private final Logger uploadListener;
        private Executor executor = Executors.newSingleThreadExecutor();

        public FileEntityWithProgress(File file, Logger uploadListener) {
            super(file);
            this.uploadListener = uploadListener;
        }

        public void writeTo(OutputStream outStream) throws IOException {
            this.outStream = new OutputStreamProgress(outStream, this);
            super.writeTo((OutputStream)this.outStream);
        }

        public void updateProgress(final long writtenLength) {
            final long contentLength = this.getContentLength();
            if (this.uploadListener.isUploadProgressEnabled().booleanValue() && contentLength > 0L) {
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        FileEntityWithProgress.this.uploadListener.logUploadProgress(writtenLength, contentLength);
                    }
                });
            }
        }
    }

    public static abstract class OutputLogger {
        public abstract void log(String var1);
    }
}

