/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.sdk.deploy;

import com.heroku.sdk.deploy.Deployer;
import com.heroku.sdk.deploy.endpoints.Builds;
import com.heroku.sdk.deploy.utils.Logger;
import com.heroku.sdk.deploy.utils.RestClient;
import com.heroku.sdk.deploy.utils.Tar;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.io.FileUtils;

public class BuildsDeployer
extends Deployer {
    private List<String> buildpacks;

    public BuildsDeployer(String client, String name, File rootDir, File targetDir, List<String> buildpacks, Logger logger) {
        super(client, name, rootDir, targetDir, logger);
        this.buildpacks = buildpacks;
    }

    @Override
    protected void addExtras(Map<String, String> processTypes) throws IOException {
        super.addExtras(processTypes);
        this.addProcfile(processTypes);
        this.addJdkOverlay();
    }

    private void addProcfile(Map<String, String> processTypes) throws IOException {
        Map<String, String> allProcessTypes = this.getProcfile();
        allProcessTypes.putAll(processTypes);
        if (allProcessTypes.isEmpty()) {
            this.logWarn("No processTypes specified!");
        }
        String procfile = "";
        for (String key : allProcessTypes.keySet()) {
            procfile = procfile + key + ": " + allProcessTypes.get(key) + "\n";
        }
        this.logDebug("Procfile:\n===================\n" + procfile + "\n===================");
        Files.write(Paths.get(new File(this.getAppDir(), "Procfile").getPath(), new String[0]), procfile.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    private void addJdkOverlay() throws IOException {
        File jdkOverlayDir = new File(this.getRootDir(), ".jdk-overlay");
        File toJdkOverlayDir = new File(this.getAppDir(), ".jdk-overlay");
        if (jdkOverlayDir.exists()) {
            this.logInfo("       - including JDK overlay");
            FileUtils.copyDirectory((File)jdkOverlayDir, (File)toJdkOverlayDir);
        }
    }

    @Override
    protected void vendorJdk(String jdkVersion, URL jdkUrl, String stackName) throws IOException, InterruptedException, ArchiveException {
        String realJdkVersion;
        String string = realJdkVersion = jdkVersion == null ? this.getJdkVersion() : jdkVersion;
        if (realJdkVersion != null) {
            Files.write(Paths.get(new File(this.getAppDir(), "system.properties").getPath(), new String[0]), ("java.runtime.version=" + realJdkVersion).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        } else if (jdkUrl != null) {
            this.logWarn("JDK URL is not supported with partial slug deployment! Ignoring...");
        }
    }

    @Override
    protected File buildSlugFile(String tarFilename) throws InterruptedException, ArchiveException, IOException {
        this.logInfo("-----> Creating build...");
        try {
            FileUtils.forceDelete((File)new File(this.getHerokuDir(), tarFilename));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        File tarFile = Tar.create(tarFilename, "./", this.getAppDir(), this.getHerokuDir());
        Long size = tarFile.length() / 0x100000L;
        if (size == 0L) {
            size = 1L;
        }
        this.logInfo("       - file: " + this.relativize(tarFile));
        this.logInfo("       - size: " + size + "MB");
        return tarFile;
    }

    @Override
    protected void deploySlug(String stack, Map<String, String> processTypes, File tarFile) throws IOException, ArchiveException, InterruptedException {
        Builds builds = new Builds(this.name, stack, this.parseCommit(), this.getEncodedApiKey(), this.buildpacks);
        Map sourceResponse = builds.createSource();
        this.logDebug("Heroku Source response: " + sourceResponse);
        this.logDebug("Heroku Blob URL: " + builds.getBlobUrl());
        this.logInfo("-----> Uploading build...");
        builds.upload(tarFile, this.logger);
        this.logInfo("       - success");
        this.logInfo("-----> Deploying...");
        Map buildInfo = builds.build(new RestClient.OutputLogger(){

            @Override
            public void log(String line) {
                BuildsDeployer.this.logInfo("remote: " + line);
            }
        });
        if (!"succeeded".equals(buildInfo.get("status"))) {
            Thread.sleep(4000L);
            Map secondAttemptBuildInfo = builds.getBuildInfo((String)buildInfo.get("id"));
            if (!"succeeded".equals(secondAttemptBuildInfo.get("status"))) {
                this.logDebug("Failed Build ID: " + buildInfo.get("id"));
                this.logDebug("Failed Build Status: " + buildInfo.get("status"));
                this.logDebug("Failed Build UpdatedAt: " + buildInfo.get("updated_at"));
                throw new RuntimeException("The build failed");
            }
        }
    }
}

