/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.sdk.deploy;

import com.heroku.sdk.deploy.Deployer;
import com.heroku.sdk.deploy.endpoints.Slug;
import com.heroku.sdk.deploy.utils.Logger;
import com.heroku.sdk.deploy.utils.Tar;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.adapters.HexBinaryAdapter;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.io.FileUtils;

public class SlugDeployer
extends Deployer {
    private static Map<String, Map<String, String>> jdkUrlsByStack = new HashMap<String, Map<String, String>>();

    public SlugDeployer(String client, String name, File rootDir, File targetDir, Logger logger) {
        super(client, name, rootDir, targetDir, logger);
    }

    protected void createSlug(String slugFilename, String jdkVersion, URL jdkUrl, String stack) throws Exception {
        this.vendorJdk(jdkVersion, jdkUrl, stack);
        this.buildSlugFile(slugFilename);
    }

    public void releaseSlug(String slugFilename, Map<String, String> processTypes, Map<String, String> configVars, String stack) throws Exception {
        this.mergeConfigVars(configVars);
        File slugFile = new File(this.getHerokuDir(), slugFilename);
        if (!slugFile.exists()) {
            throw new FileNotFoundException("Slug file not found!");
        }
        this.logInfo("-----> Using existing slug...");
        this.logInfo("       - file: " + this.relativize(slugFile));
        this.logInfo("       - size: " + slugFile.length() / 0x100000L + "MB");
        this.deploySlug(stack, processTypes, slugFile);
    }

    @Override
    protected File buildSlugFile(String slugFilename) throws InterruptedException, ArchiveException, IOException {
        this.logInfo("-----> Creating slug...");
        try {
            FileUtils.forceDelete((File)new File(this.getHerokuDir(), slugFilename));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        File slugFile = Tar.create(slugFilename, "./app", this.getHerokuDir(), this.getHerokuDir());
        this.logInfo("       - file: " + this.relativize(slugFile));
        this.logInfo("       - size: " + slugFile.length() / 0x100000L + "MB");
        return slugFile;
    }

    @Override
    protected void deploySlug(String stack, Map<String, String> processTypes, File slugFile) throws IOException, ArchiveException, InterruptedException {
        Map<String, String> allProcessTypes = this.getProcfile();
        allProcessTypes.putAll(processTypes);
        if (allProcessTypes.isEmpty()) {
            this.logWarn("No processTypes specified!");
        }
        Slug slug = new Slug(this.client, this.name, stack, this.parseCommit(), this.getEncodedApiKey(), allProcessTypes);
        this.logDebug("Heroku Slug request: " + slug.getSlugRequest());
        Map slugResponse = slug.create();
        this.logDebug("Heroku Slug response: " + slugResponse);
        this.logDebug("Heroku Blob URL: " + slug.getBlobUrl());
        this.logDebug("Heroku Slug Id: " + slug.getSlugId());
        this.uploadSlug(slug, slugFile, ((Map)slugResponse.get("process_types")).keySet());
        this.releaseSlug(slug);
    }

    @Override
    protected void addExtras(Map<String, String> processTypes) throws IOException {
        this.addProfileScript();
        this.addStartupFiles();
    }

    @Override
    protected void vendorJdk(String jdkVersion, URL jdkUrl, String stackName) throws IOException, InterruptedException, ArchiveException {
        URL realJdkUrl = jdkUrl;
        String realJdkVersion = "default";
        if (realJdkUrl == null) {
            Map<String, String> jdkUrlStrings;
            String string = realJdkVersion = jdkVersion == null ? this.getJdkVersion() : jdkVersion;
            if (jdkUrlsByStack.containsKey(stackName)) {
                jdkUrlStrings = jdkUrlsByStack.get(stackName);
                if (!jdkUrlStrings.containsKey(realJdkVersion)) {
                    throw new IllegalArgumentException("Invalid JDK version: " + realJdkVersion);
                }
            } else {
                throw new IllegalArgumentException("Unsupported Stack: " + stackName);
            }
            realJdkUrl = new URL(jdkUrlStrings.get(realJdkVersion));
            this.logInfo("       - installing: OpenJDK " + realJdkVersion);
            Files.write(Paths.get(new File(this.getAppDir(), "system.properties").getPath(), new String[0]), ("java.runtime.version=" + realJdkVersion).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        } else {
            this.logInfo("       - installing: Custom JDK");
        }
        File jdkHome = new File(this.getAppDir(), ".jdk");
        jdkHome.mkdir();
        String hashedString = "default";
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(realJdkUrl.toString().getBytes());
            hashedString = new HexBinaryAdapter().marshal(messageDigest.digest());
        }
        catch (NoSuchAlgorithmException messageDigest) {
            // empty catch block
        }
        File jdkTgz = new File(this.getHerokuDir(), "jdk-" + realJdkVersion + "-" + hashedString + ".tar.gz");
        if (!jdkTgz.exists()) {
            FileUtils.copyURLToFile((URL)realJdkUrl, (File)jdkTgz);
        }
        Tar.extract(jdkTgz, jdkHome);
        this.addJdkOverlay();
    }

    private void addProfileScript() throws IOException {
        File profiledDir = new File(this.getAppDir(), ".profile.d");
        profiledDir.mkdir();
        Files.write(Paths.get(new File(profiledDir, "jvmcommon.sh").getPath(), new String[0]), "export PATH=\"$HOME/.jdk/bin:$HOME/.startup:$PATH\"\nexport JAVA_HOME=\"\\$HOME/.jdk\"\nlimit=$(ulimit -u)\ncase $limit in\n256)   # 1X Dyno\n  default_java_opts=\"-Xmx384m -Xss512k\"\n;;\n512)   # 2X Dyno\n  default_java_opts=\"-Xmx768m\"\n;;\n32768) # PX Dyno\n  default_java_opts=\"-Xmx4g\"\n;;\n*)\n  default_java_opts=\"-Xmx384m -Xss512k\"\n;;\nesac\nexport JAVA_TOOL_OPTIONS=\"${JAVA_TOOL_OPTIONS:-\"${default_java_opts} -Dfile.encoding=UTF-8 -Djava.rmi.server.useCodebaseOnly=true\"}\"\n".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    protected void addStartupFiles() throws IOException {
        File startupDir = new File(this.getAppDir(), ".startup");
        startupDir.mkdir();
        File withJmap = new File(startupDir, "with_jmap");
        this.copyResourceFile("heroku_with_jmap.sh", withJmap);
        withJmap.setExecutable(true);
        File withJstack = new File(startupDir, "with_jstack");
        this.copyResourceFile("heroku_with_jstack.sh", withJstack);
        withJstack.setExecutable(true);
    }

    protected void addJdkOverlay() throws IOException {
        File jdkDir = new File(this.getAppDir(), ".jdk");
        File jdkOverlayDir = new File(this.getRootDir(), ".jdk-overlay");
        if (jdkOverlayDir.exists() && jdkDir.exists()) {
            this.logInfo("       - applying JDK overlay");
            FileUtils.copyDirectory((File)jdkOverlayDir, (File)jdkDir);
        }
    }

    static {
        HashMap<String, String> cedarJdkUrlStrings = new HashMap<String, String>();
        cedarJdkUrlStrings.put("1.6", "https://lang-jvm.s3.amazonaws.com/jdk/cedar/openjdk1.6-latest.tar.gz");
        cedarJdkUrlStrings.put("1.7", "https://lang-jvm.s3.amazonaws.com/jdk/cedar/openjdk1.7-latest.tar.gz");
        cedarJdkUrlStrings.put("1.8", "https://lang-jvm.s3.amazonaws.com/jdk/cedar/openjdk1.8-latest.tar.gz");
        HashMap<String, String> cedar14JdkUrlStrings = new HashMap<String, String>();
        cedar14JdkUrlStrings.put("1.6", "https://lang-jvm.s3.amazonaws.com/jdk/cedar-14/openjdk1.6-latest.tar.gz");
        cedar14JdkUrlStrings.put("1.7", "https://lang-jvm.s3.amazonaws.com/jdk/cedar-14/openjdk1.7-latest.tar.gz");
        cedar14JdkUrlStrings.put("1.8", "https://lang-jvm.s3.amazonaws.com/jdk/cedar-14/openjdk1.8-latest.tar.gz");
        jdkUrlsByStack.put("cedar", cedarJdkUrlStrings);
        jdkUrlsByStack.put("cedar-14", cedar14JdkUrlStrings);
    }
}

