/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.sdk.deploy;

import com.heroku.sdk.deploy.App;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DeployJar
extends App {
    protected File jarFile;
    protected String jarOpts;

    public DeployJar(String name, File jarFile, String jarOpts) throws IOException {
        super(name);
        this.jarFile = jarFile;
        this.jarOpts = jarOpts;
    }

    public void deploy(List<File> includedFiles, Map<String, String> configVars, String jdkVersion, String stack, String slugFileName) throws Exception {
        includedFiles.add(this.jarFile);
        super.deploy(includedFiles, configVars, jdkVersion, stack, this.defaultProcTypes(), slugFileName);
    }

    public void deploy(List<File> includedFiles, Map<String, String> configVars, URL jdkUrl, String stack, String slugFileName) throws Exception {
        includedFiles.add(this.jarFile);
        super.deploy(includedFiles, configVars, jdkUrl, stack, this.defaultProcTypes(), slugFileName);
    }

    protected Map<String, String> defaultProcTypes() {
        Map<String, String> processTypes = this.getProcfile();
        if (processTypes.isEmpty()) {
            processTypes.put("web", "java $JAVA_OPTS -jar " + this.relativize(this.jarFile) + " " + this.jarOpts + " $JAR_OPTS");
        }
        return processTypes;
    }

    private static List<File> includesToList(String includes) {
        List<String> includeStrings = Arrays.asList(includes.split(File.pathSeparator));
        ArrayList<File> includeFiles = new ArrayList<File>(includeStrings.size());
        for (String includeString : includeStrings) {
            if (includeString.isEmpty()) continue;
            includeFiles.add(new File(includeString));
        }
        return includeFiles;
    }

    protected Map<String, String> getProcfile() {
        HashMap<String, String> procTypes = new HashMap<String, String>();
        File procfile = new File("Procfile");
        if (procfile.exists()) {
            try {
                BufferedReader reader = new BufferedReader(new FileReader(procfile));
                String line = reader.readLine();
                while (line != null) {
                    if (line.contains(":")) {
                        Integer colon = line.indexOf(":");
                        String key = line.substring(0, colon);
                        String value = line.substring(colon + 1);
                        procTypes.put(key.trim(), value.trim());
                    }
                    line = reader.readLine();
                }
            }
            catch (Exception e) {
                this.logDebug(e.getMessage());
            }
        }
        return procTypes;
    }

    @Override
    public void logInfo(String message) {
        System.out.println(message);
    }

    public static void main(String[] args) throws Exception {
        String jarFile = System.getProperty("heroku.jarFile", null);
        String jarOpts = System.getProperty("heroku.jarOpts", "");
        String appName = System.getProperty("heroku.appName", null);
        String jdkVersion = System.getProperty("heroku.jdkVersion", null);
        String jdkUrl = System.getProperty("heroku.jdkUrl", null);
        String stack = System.getProperty("heroku.stack", "cedar-14");
        List<File> includes = DeployJar.includesToList(System.getProperty("heroku.includes", ""));
        String slugFileName = System.getProperty("heroku.slugFileName", "slug.tgz");
        if (jarFile == null) {
            throw new IllegalArgumentException("Path to WAR file must be provided with heroku.warFile system property!");
        }
        if (appName == null) {
            throw new IllegalArgumentException("Heroku app name must be provided with heroku.appName system property!");
        }
        new DeployJar(appName, new File(jarFile), jarOpts).deploy(includes, new HashMap<String, String>(), jdkUrl == null ? jdkVersion : jdkUrl, stack, slugFileName);
    }
}

