/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.sdk.deploy.endpoints;

import com.heroku.sdk.deploy.endpoints.ApiEndpoint;
import com.heroku.sdk.deploy.utils.RestClient;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringEscapeUtils;

public class Builds
extends ApiEndpoint {
    private static final String JVM_BUILDPACK_URL = "https://codon-buildpacks.s3.amazonaws.com/buildpacks/heroku/jvm-common.tgz";
    private static final String METRICS_BUILDPACK_URL = "https://codon-buildpacks.s3.amazonaws.com/buildpacks/heroku/metrics.tgz";
    private String blobGetUrl;
    private List<String> buildpackUrls;

    public Builds(String appName, String stackName, String commit, String encodedApiKey, List<String> buildpacks) {
        super(appName, stackName, commit, encodedApiKey);
        if (buildpacks == null || buildpacks.isEmpty()) {
            this.buildpackUrls = Arrays.asList(JVM_BUILDPACK_URL);
        } else {
            this.buildpackUrls = new ArrayList<String>(buildpacks.size());
            for (String buildpack : buildpacks) {
                if (buildpack.equals("jvm-common")) {
                    this.buildpackUrls.add(JVM_BUILDPACK_URL);
                    continue;
                }
                if (buildpack.equals("heroku/jvm")) {
                    this.buildpackUrls.add(JVM_BUILDPACK_URL);
                    continue;
                }
                if (buildpack.equals("heroku/metrics")) {
                    this.buildpackUrls.add(METRICS_BUILDPACK_URL);
                    continue;
                }
                this.buildpackUrls.add(buildpack);
            }
        }
    }

    public Map createSource() throws IOException {
        String urlStr = "https://api.heroku.com/apps/" + URLEncoder.encode(this.appName, "UTF-8") + "/sources";
        Map sourceResponse = RestClient.post(urlStr, this.headers);
        Map blobJson = (Map)sourceResponse.get("source_blob");
        this.blobUrl = (String)blobJson.get("put_url");
        this.blobGetUrl = (String)blobJson.get("get_url");
        return sourceResponse;
    }

    public Map build(RestClient.OutputLogger logger) throws IOException, InterruptedException {
        if (this.blobGetUrl == null) {
            throw new IllegalStateException("Source must be created before releasing!");
        }
        String urlStr = "https://api.heroku.com/apps/" + this.appName + "/builds";
        String data = "{\"buildpacks\":" + this.getBuildpacksJson() + ", \"source_blob\":{\"url\":\"" + (null == this.blobGetUrl ? "" : StringEscapeUtils.escapeJson((String)this.blobGetUrl)) + "\",\"version\":\"" + (null == this.commit ? "" : StringEscapeUtils.escapeJson((String)this.commit)) + "\"}}";
        Map buildResponse = RestClient.post(urlStr, data, this.headers);
        String outputUrl = (String)buildResponse.get("output_stream_url");
        String buildId = (String)buildResponse.get("id");
        if (outputUrl != null) {
            try {
                RestClient.get(outputUrl, this.headers, logger);
            }
            catch (IOException e) {
                logger.log("Deployment output not available. Polling for status...");
            }
            return this.pollForBuildInfo(buildId);
        }
        logger.log("Deployment output not available. Polling for status...");
        return this.pollForBuildInfo(buildId);
    }

    public Map pollForBuildInfo(String buildId) throws IOException, InterruptedException {
        for (int i = 0; i < 15; ++i) {
            Thread.sleep(2000L);
            Map info = this.getBuildInfo(buildId);
            if ("pending".equals(info.get("status"))) continue;
            return info;
        }
        return this.getBuildInfo(buildId);
    }

    public Map getBuildInfo(String buildId) throws IOException {
        String buildStatusUrlStr = "https://api.heroku.com/apps/" + this.appName + "/builds/" + buildId;
        return RestClient.get(buildStatusUrlStr, this.headers);
    }

    public String getBuildpacksJson() {
        String buildpacksString = "";
        for (String url : this.buildpackUrls) {
            buildpacksString = buildpacksString + ",{\"url\":\"" + StringEscapeUtils.escapeJson((String)url) + "\"}";
        }
        return buildpacksString.replaceFirst(",", "[") + "]";
    }
}

