/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.sdk.deploy.endpoints;

import com.heroku.sdk.deploy.endpoints.ApiEndpoint;
import com.heroku.sdk.deploy.utils.RestClient;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import org.apache.commons.lang3.StringEscapeUtils;

public class Slug
extends ApiEndpoint {
    private String slugId;
    private String createJson;
    public static final String BASE_URL = "https://api.heroku.com";

    public Slug(String client, String appName, String stack, String commit, String encodedApiKey, Map<String, String> processTypes) throws UnsupportedEncodingException {
        super(appName, stack, commit, encodedApiKey);
        if (processTypes.isEmpty()) {
            throw new MissingProcessTypesException();
        }
        this.createJson = "{\"buildpack_provided_description\":\"" + StringEscapeUtils.escapeJson((String)client) + "\",\"stack\":\"" + (stack == null ? "cedar-14" : StringEscapeUtils.escapeJson((String)stack)) + "\",\"commit\":\"" + (commit == null ? "" : StringEscapeUtils.escapeJson((String)commit)) + "\",\"process_types\":{";
        boolean first = true;
        for (String key : processTypes.keySet()) {
            String value = processTypes.get(key);
            if (!first) {
                this.createJson = this.createJson + ", ";
            }
            first = false;
            this.createJson = this.createJson + "\"" + key + "\":\"" + StringEscapeUtils.escapeJson((String)value) + "\"";
        }
        this.createJson = this.createJson + "}}";
    }

    public String getSlugId() {
        return this.slugId;
    }

    public String getSlugRequest() {
        return this.createJson;
    }

    public Map create() throws IOException {
        String urlStr = "https://api.heroku.com/apps/" + URLEncoder.encode(this.appName, "UTF-8") + "/slugs";
        Map slugResponse = RestClient.post(urlStr, this.createJson, this.headers);
        Map blobJson = (Map)slugResponse.get("blob");
        this.blobUrl = (String)blobJson.get("url");
        this.slugId = (String)slugResponse.get("id");
        this.commit = (String)slugResponse.get("commit");
        Map stackJson = (Map)slugResponse.get("stack");
        this.stackName = (String)stackJson.get("name");
        return slugResponse;
    }

    public Map release() throws IOException {
        if (this.slugId == null) {
            throw new IllegalStateException("Slug must be created before releasing!");
        }
        String urlStr = "https://api.heroku.com/apps/" + this.appName + "/releases";
        String data = "{\"slug\":\"" + this.slugId + "\"}";
        return RestClient.post(urlStr, data, this.headers);
    }

    public static class MissingProcessTypesException
    extends IllegalArgumentException {
    }
}

