/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.sdk.deploy.endpoints;

import com.heroku.sdk.deploy.utils.Properties;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.util.Base64;

public abstract class ApiEndpoint {
    public static final String BASE_URL = "https://api.heroku.com";
    private final String userAgentValuePattern = "heroku-deploy/%s (%s) Java/%s (%s)";
    protected String blobUrl;
    protected String appName;
    protected Boolean useCurl;
    protected Map<String, String> headers;

    ApiEndpoint(String appName, String client, String apiKey) throws IOException {
        this.appName = appName;
        this.useCurl = "true".equals(System.getProperty("heroku.curl.enabled", "false"));
        this.headers = new HashMap<String, String>();
        this.headers.put("Authorization", this.encodeApiKey(apiKey));
        this.headers.put("Content-Type", "application/json");
        this.headers.put("Accept", "application/vnd.heroku+json; version=3");
        this.headers.put("User-Agent", this.getUserAgentValue(client));
    }

    private String getUserAgentValue(String client) {
        return String.format("heroku-deploy/%s (%s) Java/%s (%s)", Properties.getProperty("heroku-deploy.version"), client, System.getProperty("java.version"), System.getProperty("java.vendor"));
    }

    private String encodeApiKey(String apiKey) throws IOException {
        return Base64.encodeBytes((byte[])(":" + apiKey).getBytes());
    }
}

