/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.sdk.deploy.endpoints;

import com.heroku.api.BuildpackInstallation;
import com.heroku.api.HerokuAPI;
import com.heroku.api.Source;
import com.heroku.sdk.deploy.endpoints.ApiEndpoint;
import com.heroku.sdk.deploy.utils.Curl;
import com.heroku.sdk.deploy.utils.Logger;
import com.heroku.sdk.deploy.utils.RestClient;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.text.StringEscapeUtils;

public class Builds
extends ApiEndpoint {
    public static final String JVM_BUILDPACK_URL = "https://buildpack-registry.s3.amazonaws.com/buildpacks/heroku/jvm.tgz";
    public static final String METRICS_BUILDPACK_URL = "https://buildpack-registry.s3.amazonaws.com/buildpacks/heroku/metrics.tgz";
    public static final String EXEC_BUILDPACK_URL = "https://buildpack-registry.s3.amazonaws.com/buildpacks/heroku/exec.tgz";
    private String blobGetUrl;
    private List<String> buildpackUrls;
    private String commit;
    private HerokuAPI api;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Builds(String appName, String client, String commit, String apiKey, List<String> buildpacks) throws IOException {
        super(appName, client, apiKey);
        this.commit = commit;
        this.api = new HerokuAPI(apiKey);
        if (buildpacks == null || buildpacks.isEmpty()) {
            HerokuAPI api = new HerokuAPI(apiKey);
            List buildpackInstalls = api.listBuildpackInstallations(appName);
            if (buildpackInstalls.isEmpty()) {
                this.buildpackUrls = Collections.singletonList(JVM_BUILDPACK_URL);
                return;
            } else {
                if (!this.containsJvmBuildpack(buildpackInstalls).booleanValue()) throw new IllegalArgumentException("Your buildpacks do not contain the heroku/jvm buildpack!Add heroku/jvm to your buildpack configuration or run `heroku buildpacks:clear`.");
                this.buildpackUrls = new ArrayList<String>();
                for (BuildpackInstallation buildpack : buildpackInstalls) {
                    this.buildpackUrls.add(this.resolveBuildpack(buildpack.getBuildpack().getName()));
                }
            }
            return;
        } else {
            this.buildpackUrls = new ArrayList<String>(buildpacks.size());
            for (String buildpack : buildpacks) {
                this.buildpackUrls.add(this.resolveBuildpack(buildpack));
            }
        }
    }

    public void upload(File slugFile, Logger listener) throws IOException, InterruptedException {
        if (this.blobUrl == null) {
            throw new IllegalStateException("Source must be created before uploading!");
        }
        if (this.useCurl.booleanValue()) {
            listener.logDebug("Uploading with curl");
            Curl.put(this.blobUrl, slugFile);
        } else {
            RestClient.put(this.blobUrl, slugFile, listener);
        }
    }

    public String getBlobUrl() {
        return this.blobUrl;
    }

    public Source createSource() throws IOException {
        Source source = this.api.createSource();
        this.blobUrl = source.getSource_blob().getPut_url();
        this.blobGetUrl = source.getSource_blob().getGet_url();
        return source;
    }

    public Map build(RestClient.OutputLogger logger) throws IOException, InterruptedException {
        if (this.blobGetUrl == null) {
            throw new IllegalStateException("Source must be created before releasing!");
        }
        String urlStr = "https://api.heroku.com/apps/" + this.appName + "/builds";
        String data = "{\"buildpacks\":" + this.getBuildpacksJson() + ", \"source_blob\":{\"url\":\"" + (null == this.blobGetUrl ? "" : StringEscapeUtils.escapeJson((String)this.blobGetUrl)) + "\",\"version\":\"" + (null == this.commit ? "" : StringEscapeUtils.escapeJson((String)this.commit)) + "\"}}";
        Map buildResponse = RestClient.post(urlStr, data, this.headers);
        String outputUrl = (String)buildResponse.get("output_stream_url");
        String buildId = (String)buildResponse.get("id");
        if (outputUrl != null) {
            try {
                RestClient.get(outputUrl, this.headers, logger);
            }
            catch (IOException e) {
                logger.log("Deployment output not available. Polling for status...");
            }
            return this.pollForBuildInfo(buildId);
        }
        logger.log("Deployment output not available. Polling for status...");
        return this.pollForBuildInfo(buildId);
    }

    public Map pollForBuildInfo(String buildId) throws IOException, InterruptedException {
        for (int i = 0; i < 15; ++i) {
            Thread.sleep(2000L);
            Map info = this.getBuildInfo(buildId);
            if ("pending".equals(info.get("status"))) continue;
            return info;
        }
        return this.getBuildInfo(buildId);
    }

    public Map getBuildInfo(String buildId) throws IOException {
        String buildStatusUrlStr = "https://api.heroku.com/apps/" + this.appName + "/builds/" + buildId;
        return RestClient.get(buildStatusUrlStr, this.headers);
    }

    private String getBuildpacksJson() {
        StringBuilder buildpacksString = new StringBuilder();
        for (String url : this.buildpackUrls) {
            buildpacksString.append(",{\"url\":\"").append(StringEscapeUtils.escapeJson((String)url)).append("\"}");
        }
        return buildpacksString.toString().replaceFirst(",", "[") + "]";
    }

    private Boolean containsJvmBuildpack(List<BuildpackInstallation> buildpackInstalls) {
        for (BuildpackInstallation buildpack : buildpackInstalls) {
            if (buildpack.getBuildpack().getName().startsWith("heroku/jvm")) {
                return true;
            }
            if (buildpack.getBuildpack().getName().startsWith("https://github.com/heroku/heroku-buildpack-jvm-common")) {
                return true;
            }
            if (buildpack.getBuildpack().getName().startsWith(JVM_BUILDPACK_URL)) {
                return true;
            }
            if (!buildpack.getBuildpack().getName().startsWith("https://codon-buildpacks.s3.amazonaws.com/buildpacks/heroku/jvm-common.tgz")) continue;
            return true;
        }
        return false;
    }

    private String resolveBuildpack(String buildpack) {
        if (buildpack.equals("jvm-common")) {
            return JVM_BUILDPACK_URL;
        }
        if (buildpack.equals("heroku/jvm")) {
            return JVM_BUILDPACK_URL;
        }
        if (buildpack.equals("heroku/metrics")) {
            return METRICS_BUILDPACK_URL;
        }
        if (buildpack.equals("heroku/exec")) {
            return EXEC_BUILDPACK_URL;
        }
        return buildpack;
    }
}

