/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.sdk.deploy.utils;

import com.heroku.sdk.deploy.App;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class Main {
    private static List<File> includesToFiles(String includes) {
        List<String> includeStrings = Main.includesToList(includes, File.pathSeparator);
        ArrayList<File> includeFiles = new ArrayList<File>(includeStrings.size());
        for (String includeString : includeStrings) {
            if (includeString.isEmpty()) continue;
            includeFiles.add(new File(includeString));
        }
        return includeFiles;
    }

    private static List<String> includesToList(String includes, String delim) {
        return includes == null || includes.isEmpty() ? new ArrayList<String>() : Arrays.asList(includes.split(delim));
    }

    public static void deploy(DeployFunction<String, List<String>, App> f) throws Exception {
        String appName = System.getProperty("heroku.appName", null);
        String jdkVersion = System.getProperty("heroku.jdkVersion", null);
        List<File> includes = Main.includesToFiles(System.getProperty("heroku.includes", ""));
        String buildFileName = System.getProperty("heroku.buildFileName", "slug.tgz");
        String buildpacksDelim = System.getProperty("heroku.buildpacksDelim", ",");
        List<String> buildpacks = Main.includesToList(System.getProperty("heroku.buildpacks", ""), buildpacksDelim);
        if (appName == null) {
            throw new IllegalArgumentException("Heroku app name must be provided with heroku.appName system property!");
        }
        f.apply(appName, buildpacks).deploy(includes, new HashMap<String, String>(), jdkVersion, new HashMap<String, String>(), buildFileName);
    }

    public static Boolean isDebug() {
        String debug = System.getenv("HEROKU_DEBUG");
        return "1".equals(debug) || "true".equals(debug);
    }

    public static interface DeployFunction<T, B, R> {
        public R apply(T var1, B var2) throws IOException;
    }
}

