/*
 * Decompiled with CFR 0.152.
 */
package com.hi3project.vineyard.comm.stomp.gozirraws;

import com.hi3project.vineyard.comm.stomp.gozirraws.Command;
import com.hi3project.vineyard.comm.stomp.gozirraws.MessageReceiver;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;

public class Receiver
extends Thread {
    private MessageReceiver _receiver;
    private BufferedReader _input;
    private InputStream _stream;

    protected Receiver() {
    }

    public Receiver(MessageReceiver m, InputStream input) {
        this.setup(m, input);
    }

    protected void setup(MessageReceiver m, InputStream input) {
        this._receiver = m;
        try {
            this._stream = input;
            this._input = new BufferedReader(new InputStreamReader(input, "US-ASCII"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public static void receive(MessageReceiver _receiver, BufferedReader _input) throws IOException {
        String command = _input.readLine();
        if (command.length() > 0) {
            try {
                int b;
                String header;
                Command c = Command.valueOf(command);
                HashMap<String, String> headers = new HashMap<String, String>();
                while ((header = _input.readLine()).length() > 0) {
                    int ind = header.indexOf(58);
                    String k = header.substring(0, ind);
                    String v = header.substring(ind + 1, header.length());
                    headers.put(k.trim(), v.trim());
                }
                StringBuilder body = new StringBuilder();
                while ((b = _input.read()) != 0) {
                    body.append((char)b);
                }
                try {
                    _receiver.receive(c, headers, body.toString());
                }
                catch (Exception e) {}
            }
            catch (Error e) {
                try {
                    while (_input.read() != 0) {
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    _receiver.receive(Command.ERROR, null, e.getMessage() + "\n");
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void run() {
        try {
            while (!this.isInterrupted()) {
                if (this._input.ready()) {
                    Receiver.receive(this._receiver, this._input);
                    continue;
                }
                if (this._receiver.isClosed()) {
                    this._receiver.disconnect();
                    return;
                }
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    this.interrupt();
                }
            }
        }
        catch (IOException e) {
            System.err.println("Stomp exiting because of exception");
            e.printStackTrace(System.err);
            this._receiver.receive(Command.ERROR, null, e.getMessage());
        }
        catch (Exception e) {
            System.err.println("Stomp exiting because of exception");
            e.printStackTrace(System.err);
            this._receiver.receive(Command.ERROR, null, e.getMessage());
        }
    }
}

