/*
 * Decompiled with CFR 0.152.
 */
package com.hi3project.vineyard.comm.stomp.gozirraws;

import com.hi3project.vineyard.comm.stomp.gozirraws.MessageReceiver;
import com.hi3project.vineyard.comm.stomp.gozirraws.Receiver;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_17;
import org.java_websocket.handshake.ServerHandshake;

public class WebSocketClientForStomp
extends WebSocketClient {
    private boolean open = false;
    private MessageReceiver _receiver;

    public WebSocketClientForStomp(URI serverURI, MessageReceiver m) {
        super(serverURI, (Draft)new Draft_17());
        this._receiver = m;
    }

    public void onOpen(ServerHandshake handshakedata) {
        this.open = true;
        System.out.println("new connection opened: " + handshakedata.getHttpStatusMessage());
    }

    public void onClose(int code, String reason, boolean remote) {
        System.out.println("closed with exit code " + code + " additional info: " + reason);
        this.open = false;
    }

    public void onMessage(String message) {
        BufferedReader br = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(message.getBytes())));
        try {
            Receiver.receive(this._receiver, br);
        }
        catch (IOException ex) {
            Logger.getLogger(WebSocketClientForStomp.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void onError(Exception ex) {
        System.err.println("an error occured:" + ex);
    }

    public boolean isOpen() {
        return this.open;
    }
}

