/*
 * Decompiled with CFR 0.152.
 */
package com.hi3project.vineyard.comm.stomp.gozirraws;

import com.hi3project.vineyard.comm.stomp.gozirraws.Command;
import com.hi3project.vineyard.comm.stomp.gozirraws.MessageReceiver;
import com.hi3project.vineyard.comm.stomp.gozirraws.Stomp;
import com.hi3project.vineyard.comm.stomp.gozirraws.Transmitter;
import com.hi3project.vineyard.comm.stomp.gozirraws.WebSocketClientForStomp;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.login.LoginException;

public class WebSocketStomp
extends Stomp
implements MessageReceiver {
    private WebSocketClientForStomp _socket;

    public WebSocketStomp(URI serverURI, String login, String pass) throws IOException, LoginException {
        try {
            this._socket = new WebSocketClientForStomp(serverURI, this);
            this._socket.connectBlocking();
            HashMap<String, String> header = new HashMap<String, String>();
            header.put("login", login);
            header.put("passcode", pass);
            this.transmit(Command.CONNECT, header, null);
            this._connected = true;
            String error = null;
            while (!this.isConnected() && (error = this.nextError()) == null) {
                Thread.sleep(100L);
            }
            if (error != null) {
                throw new LoginException(error);
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }

    @Override
    public boolean isClosed() {
        return !this._socket.isOpen();
    }

    @Override
    public void disconnect(Map header) {
        if (!this.isConnected()) {
            return;
        }
        this.transmit(Command.DISCONNECT, header, null);
        this._socket.close();
        Thread.yield();
        this._connected = false;
    }

    @Override
    public void transmit(Command c, Map h, String b) {
        try {
            Transmitter.transmit(c, h, b, this._socket);
        }
        catch (Exception e) {
            this.receive(Command.ERROR, null, e.getMessage());
        }
    }

    public String toString() {
        return "WSClient{_socket=" + (Object)((Object)this._socket) + '}';
    }
}

