/*
 * Copyright 2018 dc-square and the HiveMQ MQTT Client Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package com.hivemq.client.mqtt;

import com.hivemq.client.annotations.DoNotImplement;
import io.reactivex.Scheduler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.concurrent.Executor;

/**
 * Builder base for a {@link MqttClientExecutorConfig}.
 *
 * @param <B> the type of the builder.
 * @author Silvio Giebl
 * @since 1.0
 */
@DoNotImplement
public interface MqttClientExecutorConfigBuilderBase<B extends MqttClientExecutorConfigBuilderBase<B>> {

    /**
     * Sets the optional user defined {@link MqttClientExecutorConfig#getNettyExecutor() executor for Netty} (network
     * communication framework).
     *
     * @param nettyExecutor the user defined executor for Netty or <code>null</code> to use the default executor.
     * @return the builder.
     */
    @NotNull B nettyExecutor(@Nullable Executor nettyExecutor);

    /**
     * Sets the optional user defined {@link MqttClientExecutorConfig#getNettyThreads() amount of threads Netty}
     * (network communication framework).
     *
     * @param nettyThreads the user defined amount of threads Netty.
     * @return the builder.
     */
    @NotNull B nettyThreads(int nettyThreads);

    /**
     * Sets the {@link MqttClientExecutorConfig#getApplicationScheduler() scheduler used for executing application
     * specific code}.
     *
     * @param applicationScheduler the scheduler used for executing application specific code.
     * @return the builder.
     */
    @NotNull B applicationScheduler(@NotNull Scheduler applicationScheduler);
}
