/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt;

import com.hivemq.client.internal.mqtt.MqttClientSslConfigImpl;
import com.hivemq.client.internal.mqtt.MqttClientSslConfigImplBuilder;
import com.hivemq.client.internal.mqtt.MqttClientTransportConfigImpl;
import com.hivemq.client.internal.mqtt.MqttWebSocketConfigImpl;
import com.hivemq.client.internal.mqtt.MqttWebSocketConfigImplBuilder;
import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.mqtt.MqttClientSslConfig;
import com.hivemq.client.mqtt.MqttClientTransportConfigBuilder;
import com.hivemq.client.mqtt.MqttWebSocketConfig;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MqttClientTransportConfigImplBuilder<B extends MqttClientTransportConfigImplBuilder<B>> {
    @Nullable
    private InetSocketAddress serverAddress;
    @NotNull
    private Object serverHost = "localhost";
    private int serverPort = -1;
    @Nullable
    private MqttClientSslConfigImpl sslConfig;
    @Nullable
    private MqttWebSocketConfigImpl webSocketConfig;

    MqttClientTransportConfigImplBuilder() {
    }

    MqttClientTransportConfigImplBuilder(@NotNull MqttClientTransportConfigImpl transportConfig) {
        this.set(transportConfig);
    }

    MqttClientTransportConfigImplBuilder(@NotNull MqttClientTransportConfigImplBuilder<?> builder) {
        this.serverAddress = builder.serverAddress;
        this.serverHost = builder.serverHost;
        this.serverPort = builder.serverPort;
        this.sslConfig = builder.sslConfig;
        this.webSocketConfig = builder.webSocketConfig;
    }

    void set(@NotNull MqttClientTransportConfigImpl transportConfig) {
        this.serverAddress = transportConfig.getServerAddress();
        this.sslConfig = transportConfig.getRawSslConfig();
        this.webSocketConfig = transportConfig.getRawWebSocketConfig();
    }

    @NotNull
    abstract B self();

    @NotNull
    public B serverAddress(@Nullable InetSocketAddress address) {
        this.serverAddress = Checks.notNull(address, "Server address");
        return this.self();
    }

    @NotNull
    public B serverHost(@Nullable String host) {
        this.setServerHost(Checks.notEmpty(host, "Server host"));
        return this.self();
    }

    @NotNull
    public B serverHost(@Nullable InetAddress host) {
        this.setServerHost(Checks.notNull(host, "Server host"));
        return this.self();
    }

    private void setServerHost(@NotNull Object serverHost) {
        this.serverHost = serverHost;
        if (this.serverAddress != null) {
            this.serverPort = this.serverAddress.getPort();
            this.serverAddress = null;
        }
    }

    @NotNull
    public B serverPort(int port) {
        this.serverPort = Checks.unsignedShort(port, "Server port");
        if (this.serverAddress != null) {
            InetAddress inetAddress = this.serverAddress.getAddress();
            this.serverHost = inetAddress != null ? inetAddress : this.serverAddress.getHostString();
            this.serverAddress = null;
        }
        return this.self();
    }

    @NotNull
    public B sslWithDefaultConfig() {
        this.sslConfig = MqttClientSslConfigImpl.DEFAULT;
        return this.self();
    }

    @NotNull
    public B sslConfig(@Nullable MqttClientSslConfig sslConfig) {
        this.sslConfig = Checks.notImplementedOrNull(sslConfig, MqttClientSslConfigImpl.class, "SSL config");
        return this.self();
    }

    @NotNull
    public MqttClientSslConfigImplBuilder.Nested<B> sslConfig() {
        return new MqttClientSslConfigImplBuilder.Nested<MqttClientTransportConfigImplBuilder>(this.sslConfig, this::sslConfig);
    }

    @NotNull
    public B webSocketWithDefaultConfig() {
        this.webSocketConfig = MqttWebSocketConfigImpl.DEFAULT;
        return this.self();
    }

    @NotNull
    public B webSocketConfig(@Nullable MqttWebSocketConfig webSocketConfig) {
        this.webSocketConfig = Checks.notImplementedOrNull(webSocketConfig, MqttWebSocketConfigImpl.class, "WebSocket config");
        return this.self();
    }

    @NotNull
    public MqttWebSocketConfigImplBuilder.Nested<B> webSocketConfig() {
        return new MqttWebSocketConfigImplBuilder.Nested<MqttClientTransportConfigImplBuilder>(this.webSocketConfig, this::webSocketConfig);
    }

    @NotNull
    private InetSocketAddress getServerAddress() {
        if (this.serverAddress != null) {
            return this.serverAddress;
        }
        if (this.serverHost instanceof InetAddress) {
            return new InetSocketAddress((InetAddress)this.serverHost, this.getServerPort());
        }
        return InetSocketAddress.createUnresolved((String)this.serverHost, this.getServerPort());
    }

    private int getServerPort() {
        if (this.serverPort != -1) {
            return this.serverPort;
        }
        if (this.sslConfig == null) {
            if (this.webSocketConfig == null) {
                return 1883;
            }
            return 80;
        }
        if (this.webSocketConfig == null) {
            return 8883;
        }
        return 443;
    }

    @NotNull
    MqttClientTransportConfigImpl buildTransportConfig() {
        return new MqttClientTransportConfigImpl(this.getServerAddress(), this.sslConfig, this.webSocketConfig);
    }

    public static class Nested<P>
    extends MqttClientTransportConfigImplBuilder<Nested<P>>
    implements MqttClientTransportConfigBuilder.Nested<P> {
        @NotNull
        private final Function<? super MqttClientTransportConfigImpl, P> parentConsumer;

        public Nested(@NotNull Function<? super MqttClientTransportConfigImpl, P> parentConsumer) {
            this.parentConsumer = parentConsumer;
        }

        public Nested(@NotNull MqttClientTransportConfigImpl transportConfig, @NotNull Function<? super MqttClientTransportConfigImpl, P> parentConsumer) {
            super(transportConfig);
            this.parentConsumer = parentConsumer;
        }

        Nested(@NotNull MqttClientTransportConfigImplBuilder<?> builder, @NotNull Function<? super MqttClientTransportConfigImpl, P> parentConsumer) {
            super(builder);
            this.parentConsumer = parentConsumer;
        }

        @Override
        @NotNull
        Nested<P> self() {
            return this;
        }

        @Override
        @NotNull
        public P applyTransportConfig() {
            return this.parentConsumer.apply(this.buildTransportConfig());
        }
    }

    public static class Default
    extends MqttClientTransportConfigImplBuilder<Default>
    implements MqttClientTransportConfigBuilder {
        public Default() {
        }

        Default(@NotNull MqttClientTransportConfigImpl transportConfig) {
            super(transportConfig);
        }

        @Override
        @NotNull
        Default self() {
            return this;
        }

        @Override
        @NotNull
        public MqttClientTransportConfigImpl build() {
            return this.buildTransportConfig();
        }
    }
}

