/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.datatypes;

import com.hivemq.client.internal.mqtt.datatypes.MqttTopicFilterImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttTopicImpl;
import com.hivemq.client.internal.util.ByteArray;
import com.hivemq.client.internal.util.ByteArrayUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MqttTopicLevel
extends ByteArray.Range {
    @NotNull
    public static final ByteArray SINGLE_LEVEL_WILDCARD = new ByteArray(new byte[]{43});

    @NotNull
    public static MqttTopicLevel root(@NotNull MqttTopicImpl topic) {
        byte[] binary = topic.toBinary();
        int end = MqttTopicLevel.nextEnd(binary, 0);
        return new MqttTopicLevel(binary, 0, end);
    }

    @NotNull
    public static MqttTopicLevel root(@NotNull MqttTopicFilterImpl topicFilter) {
        byte[] binary = topicFilter.toBinary();
        int start = topicFilter.getFilterByteStart();
        int end = MqttTopicLevel.nextEnd(binary, start);
        return new MqttTopicLevel(binary, start, end);
    }

    private static int nextEnd(@NotNull byte[] array, int start) {
        int nextSeparator = ByteArrayUtil.indexOf(array, start, (byte)47);
        return nextSeparator == -1 ? array.length : nextSeparator;
    }

    private MqttTopicLevel(@NotNull byte[] array, int start, int end) {
        super(array, start, end);
    }

    @Nullable
    public MqttTopicLevel next() {
        if (this.end == this.array.length) {
            return null;
        }
        this.start = this.end + 1;
        this.end = MqttTopicLevel.nextEnd(this.array, this.start);
        return this;
    }

    @NotNull
    public ByteArray copy() {
        if (this.isSingleLevelWildcard()) {
            return SINGLE_LEVEL_WILDCARD;
        }
        return new ByteArray(Arrays.copyOfRange(this.array, this.start, this.end));
    }

    @NotNull
    public MqttTopicLevel fork() {
        return new MqttTopicLevel(this.array, this.start, this.end);
    }

    public boolean isSingleLevelWildcard() {
        return this.length() == 1 && this.array[this.start] == 43;
    }

    public boolean isMultiLevelWildcard() {
        return this.length() == 1 && this.array[this.start] == 35;
    }
}

