/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.connect;

import com.hivemq.client.internal.logging.InternalLogger;
import com.hivemq.client.internal.logging.InternalLoggerFactory;
import com.hivemq.client.internal.mqtt.MqttClientConfig;
import com.hivemq.client.internal.mqtt.MqttClientTransportConfigImpl;
import com.hivemq.client.internal.mqtt.exceptions.MqttClientStateExceptions;
import com.hivemq.client.internal.mqtt.handler.connect.MqttConnAckFlow;
import com.hivemq.client.internal.mqtt.lifecycle.MqttClientDisconnectedContextImpl;
import com.hivemq.client.internal.mqtt.lifecycle.MqttClientReconnector;
import com.hivemq.client.internal.mqtt.message.connect.MqttConnect;
import com.hivemq.client.mqtt.MqttClientState;
import com.hivemq.client.mqtt.exceptions.ConnectionFailedException;
import com.hivemq.client.mqtt.lifecycle.MqttClientDisconnectedContext;
import com.hivemq.client.mqtt.lifecycle.MqttClientDisconnectedListener;
import com.hivemq.client.mqtt.lifecycle.MqttDisconnectSource;
import com.hivemq.client.mqtt.mqtt5.message.connect.connack.Mqtt5ConnAck;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.internal.disposables.EmptyDisposable;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MqttConnAckSingle
extends Single<Mqtt5ConnAck> {
    @NotNull
    private static final InternalLogger LOGGER = InternalLoggerFactory.getLogger(MqttConnAckSingle.class);
    @NotNull
    private final MqttClientConfig clientConfig;
    @NotNull
    private final MqttConnect connect;

    public MqttConnAckSingle(@NotNull MqttClientConfig clientConfig, @NotNull MqttConnect connect) {
        this.clientConfig = clientConfig;
        this.connect = connect.setDefaults(clientConfig);
    }

    protected void subscribeActual(@NotNull SingleObserver<? super Mqtt5ConnAck> observer) {
        if (!this.clientConfig.getRawState().compareAndSet(MqttClientState.DISCONNECTED, MqttClientState.CONNECTING)) {
            EmptyDisposable.error((Throwable)MqttClientStateExceptions.alreadyConnected(), observer);
            return;
        }
        MqttConnAckFlow flow = new MqttConnAckFlow(observer, this.clientConfig.getTransportConfig());
        observer.onSubscribe(flow.getDisposable());
        MqttConnAckSingle.connect(this.clientConfig, this.connect, flow, this.clientConfig.acquireEventLoop());
    }

    private static void connect(@NotNull MqttClientConfig clientConfig, @NotNull MqttConnect connect, @NotNull MqttConnAckFlow flow, @NotNull EventLoop eventLoop) {
        if (flow.getDisposable().isDisposed()) {
            clientConfig.releaseEventLoop();
            clientConfig.getRawState().set(MqttClientState.DISCONNECTED);
        } else {
            Bootstrap bootstrap = clientConfig.getClientComponent().connectionComponentBuilder().connect(connect).connAckFlow(flow).build().bootstrap();
            ((Bootstrap)bootstrap.group((EventLoopGroup)eventLoop)).connect((SocketAddress)flow.getTransportConfig().getServerAddress()).addListener(future -> {
                Throwable cause = future.cause();
                if (cause != null) {
                    MqttConnAckSingle.reconnect(clientConfig, MqttDisconnectSource.CLIENT, (Throwable)new ConnectionFailedException(cause), connect, flow, eventLoop);
                }
            });
        }
    }

    public static void reconnect(@NotNull MqttClientConfig clientConfig, @NotNull MqttDisconnectSource source, @NotNull Throwable cause, @NotNull MqttConnect connect, @NotNull MqttConnAckFlow flow, @NotNull EventLoop eventLoop) {
        if (flow.setDone()) {
            MqttConnAckSingle.reconnect(clientConfig, source, cause, connect, flow.getTransportConfig(), flow.getAttempts() + 1, flow, eventLoop);
        }
    }

    public static void reconnect(@NotNull MqttClientConfig clientConfig, @NotNull MqttDisconnectSource source, @NotNull Throwable cause, @NotNull MqttConnect connect, @NotNull MqttClientTransportConfigImpl transportConfig, @NotNull EventLoop eventLoop) {
        MqttConnAckSingle.reconnect(clientConfig, source, cause, connect, transportConfig, 0, null, eventLoop);
    }

    private static void reconnect(@NotNull MqttClientConfig clientConfig, @NotNull MqttDisconnectSource source, @NotNull Throwable cause, @NotNull MqttConnect connect, @NotNull MqttClientTransportConfigImpl transportConfig, int attempts, @Nullable MqttConnAckFlow flow, @NotNull EventLoop eventLoop) {
        MqttClientReconnector reconnector = new MqttClientReconnector(eventLoop, attempts, connect, transportConfig);
        MqttClientDisconnectedContext context = MqttClientDisconnectedContextImpl.of(clientConfig, source, cause, reconnector);
        for (MqttClientDisconnectedListener disconnectedListener : clientConfig.getDisconnectedListeners()) {
            try {
                disconnectedListener.onDisconnected(context);
            }
            catch (Throwable t) {
                LOGGER.error("Unexpected exception thrown by disconnected listener.", t);
            }
        }
        if (reconnector.isReconnect()) {
            clientConfig.getRawState().set(MqttClientState.DISCONNECTED_RECONNECT);
            clientConfig.acquireEventLoop();
            eventLoop.schedule(() -> reconnector.getFuture().whenComplete((ignored, throwable) -> {
                if (reconnector.isReconnect()) {
                    if (clientConfig.getRawState().compareAndSet(MqttClientState.DISCONNECTED_RECONNECT, MqttClientState.CONNECTING_RECONNECT)) {
                        MqttConnAckFlow newFlow = new MqttConnAckFlow(flow, reconnector.getTransportConfig());
                        MqttConnAckSingle.connect(clientConfig, reconnector.getConnect(), newFlow, eventLoop);
                    }
                } else if (clientConfig.getRawState().compareAndSet(MqttClientState.DISCONNECTED_RECONNECT, MqttClientState.DISCONNECTED)) {
                    clientConfig.releaseEventLoop();
                    if (flow != null) {
                        if (throwable == null) {
                            flow.onError(new ConnectionFailedException("Reconnect was cancelled."));
                        } else {
                            flow.onError(new ConnectionFailedException((Throwable)throwable));
                        }
                    }
                }
            }), reconnector.getDelay(TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS);
        } else {
            clientConfig.getRawState().set(MqttClientState.DISCONNECTED);
            if (flow != null) {
                flow.onError(cause);
            }
        }
    }
}

