/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.disconnect;

import com.hivemq.client.internal.logging.InternalLogger;
import com.hivemq.client.internal.logging.InternalLoggerFactory;
import com.hivemq.client.internal.mqtt.MqttClientConfig;
import com.hivemq.client.internal.mqtt.MqttClientConnectionConfig;
import com.hivemq.client.internal.mqtt.datatypes.MqttUserPropertiesImpl;
import com.hivemq.client.internal.mqtt.exceptions.MqttClientStateExceptions;
import com.hivemq.client.internal.mqtt.handler.MqttConnectionAwareHandler;
import com.hivemq.client.internal.mqtt.handler.MqttSession;
import com.hivemq.client.internal.mqtt.handler.connect.MqttConnAckSingle;
import com.hivemq.client.internal.mqtt.handler.disconnect.MqttDisconnectEvent;
import com.hivemq.client.internal.mqtt.handler.disconnect.MqttDisconnectUtil;
import com.hivemq.client.internal.mqtt.ioc.ConnectionScope;
import com.hivemq.client.internal.mqtt.message.connect.MqttConnect;
import com.hivemq.client.internal.mqtt.message.connect.MqttConnectRestrictions;
import com.hivemq.client.internal.mqtt.message.disconnect.MqttDisconnect;
import com.hivemq.client.internal.rx.CompletableFlow;
import com.hivemq.client.mqtt.MqttVersion;
import com.hivemq.client.mqtt.exceptions.ConnectionClosedException;
import com.hivemq.client.mqtt.lifecycle.MqttDisconnectSource;
import com.hivemq.client.mqtt.mqtt5.auth.Mqtt5EnhancedAuthMechanism;
import com.hivemq.client.mqtt.mqtt5.exceptions.Mqtt5DisconnectException;
import com.hivemq.client.mqtt.mqtt5.message.disconnect.Mqtt5Disconnect;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.EventLoop;
import io.netty.util.concurrent.GenericFutureListener;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;

@ConnectionScope
public class MqttDisconnectHandler
extends MqttConnectionAwareHandler {
    @NotNull
    private static final InternalLogger LOGGER = InternalLoggerFactory.getLogger(MqttDisconnectHandler.class);
    @NotNull
    public static final String NAME = "disconnect";
    @NotNull
    private final MqttClientConfig clientConfig;
    @NotNull
    private final MqttSession session;
    private boolean once = true;

    @Inject
    MqttDisconnectHandler(@NotNull MqttClientConfig clientConfig, @NotNull MqttSession session) {
        this.clientConfig = clientConfig;
        this.session = session;
    }

    public void channelRead(@NotNull ChannelHandlerContext ctx, @NotNull Object msg) {
        if (msg instanceof MqttDisconnect) {
            this.readDisconnect(ctx, (MqttDisconnect)msg);
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    private void readDisconnect(@NotNull ChannelHandlerContext ctx, @NotNull MqttDisconnect disconnect) {
        if (this.once) {
            this.once = false;
            MqttDisconnectUtil.fireDisconnectEvent(ctx.channel(), new Mqtt5DisconnectException((Mqtt5Disconnect)disconnect, "Server sent DISCONNECT."), MqttDisconnectSource.SERVER);
        }
    }

    public void channelInactive(@NotNull ChannelHandlerContext ctx) {
        ctx.fireChannelInactive();
        if (this.once) {
            this.once = false;
            MqttDisconnectUtil.fireDisconnectEvent(ctx.channel(), new ConnectionClosedException("Server closed connection without DISCONNECT."), MqttDisconnectSource.SERVER);
        }
    }

    public void exceptionCaught(@NotNull ChannelHandlerContext ctx, @NotNull Throwable cause) {
        if (this.once) {
            this.once = false;
            MqttDisconnectUtil.fireDisconnectEvent(ctx.channel(), new ConnectionClosedException(cause), MqttDisconnectSource.CLIENT);
        } else {
            LOGGER.error("Exception while disconnecting.", cause);
        }
    }

    public void disconnect(@NotNull MqttDisconnect disconnect, @NotNull CompletableFlow flow) {
        if (!this.clientConfig.executeInEventLoop(() -> this.writeDisconnect(disconnect, flow))) {
            flow.onError(MqttClientStateExceptions.notConnected());
        }
    }

    private void writeDisconnect(@NotNull MqttDisconnect disconnect, @NotNull CompletableFlow flow) {
        ChannelHandlerContext ctx = this.ctx;
        if (ctx != null && this.once) {
            this.once = false;
            MqttDisconnectUtil.fireDisconnectEvent(ctx.channel(), new MqttDisconnectEvent.ByUser(disconnect, flow));
        } else {
            flow.onError(MqttClientStateExceptions.notConnected());
        }
    }

    @Override
    protected void onDisconnectEvent(@NotNull MqttDisconnectEvent disconnectEvent) {
        ChannelHandlerContext ctx = this.ctx;
        if (ctx == null) {
            return;
        }
        super.onDisconnectEvent(disconnectEvent);
        this.once = false;
        MqttClientConnectionConfig connectionConfig = this.clientConfig.getRawConnectionConfig();
        if (connectionConfig != null) {
            this.session.expire(disconnectEvent.getCause(), connectionConfig, ctx.channel().eventLoop());
            this.reconnect(disconnectEvent, connectionConfig, ctx.channel().eventLoop());
            this.clientConfig.setConnectionConfig(null);
        }
        if (disconnectEvent.getSource() == MqttDisconnectSource.SERVER) {
            ctx.channel().close();
        } else {
            MqttDisconnect disconnect = disconnectEvent.getDisconnect();
            if (disconnect != null) {
                if (disconnectEvent instanceof MqttDisconnectEvent.ByUser) {
                    CompletableFlow flow = ((MqttDisconnectEvent.ByUser)disconnectEvent).getFlow();
                    ctx.writeAndFlush((Object)disconnect).addListener(future -> {
                        future.channel().close();
                        if (future.isSuccess()) {
                            flow.onComplete();
                        } else {
                            flow.onError(new ConnectionClosedException(future.cause()));
                        }
                    });
                } else if (this.clientConfig.getMqttVersion() == MqttVersion.MQTT_5_0) {
                    ctx.writeAndFlush((Object)disconnect).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                } else {
                    ctx.channel().close();
                }
            } else {
                ctx.channel().close();
            }
        }
    }

    private void reconnect(@NotNull MqttDisconnectEvent disconnectEvent, @NotNull MqttClientConnectionConfig connectionConfig, @NotNull EventLoop eventLoop) {
        MqttClientConfig.ConnectDefaults connectDefaults = this.clientConfig.getConnectDefaults();
        Mqtt5EnhancedAuthMechanism enhancedAuthMechanism = connectionConfig.getRawEnhancedAuthMechanism();
        MqttConnect connect = new MqttConnect(connectionConfig.getKeepAlive(), connectionConfig.getSessionExpiryInterval() == 0L, connectionConfig.getSessionExpiryInterval(), new MqttConnectRestrictions(connectionConfig.getReceiveMaximum(), connectionConfig.getSendMaximum(), connectionConfig.getMaximumPacketSize(), connectionConfig.getSendMaximumPacketSize(), connectionConfig.getTopicAliasMaximum(), connectionConfig.getSendTopicAliasMaximum(), connectionConfig.isProblemInformationRequested(), connectionConfig.isResponseInformationRequested()), connectDefaults.getSimpleAuth(), enhancedAuthMechanism == null ? connectDefaults.getEnhancedAuthMechanism() : enhancedAuthMechanism, connectDefaults.getWillPublish(), MqttUserPropertiesImpl.NO_USER_PROPERTIES);
        MqttConnAckSingle.reconnect(this.clientConfig, disconnectEvent.getSource(), disconnectEvent.getCause(), connect, connectionConfig.getTransportConfig(), eventLoop);
    }

    public void channelUnregistered(@NotNull ChannelHandlerContext ctx) {
        ctx.fireChannelUnregistered();
        this.clientConfig.releaseEventLoop();
    }

    public boolean isSharable() {
        return false;
    }
}

