/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.publish.incoming;

import com.hivemq.client.internal.annotations.NotThreadSafe;
import com.hivemq.client.internal.mqtt.datatypes.MqttTopicFilterImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttTopicImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttTopicLevel;
import com.hivemq.client.internal.mqtt.handler.publish.incoming.MqttIncomingPublishFlow;
import com.hivemq.client.internal.mqtt.handler.publish.incoming.MqttSubscribedPublishFlow;
import com.hivemq.client.internal.mqtt.handler.publish.incoming.MqttSubscriptionFlows;
import com.hivemq.client.internal.util.ByteArray;
import com.hivemq.client.internal.util.collections.HandleList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NotThreadSafe
public class MqttSubscriptionFlowTree
implements MqttSubscriptionFlows {
    @NotNull
    private static final ByteArray ROOT_LEVEL = new ByteArray(new byte[0]);
    @Nullable
    private TopicTreeNode rootNode;

    @Inject
    MqttSubscriptionFlowTree() {
    }

    @Override
    public void subscribe(@NotNull MqttTopicFilterImpl topicFilter, @Nullable MqttSubscribedPublishFlow flow) {
        TopicTreeEntry entry;
        MqttTopicLevel level = MqttTopicLevel.root(topicFilter);
        TopicTreeEntry topicTreeEntry = entry = flow == null ? null : new TopicTreeEntry(flow, topicFilter);
        if (this.rootNode == null) {
            this.rootNode = new TopicTreeNode(ROOT_LEVEL, level, entry);
        } else {
            this.rootNode.subscribe(level, entry);
        }
    }

    @Override
    public void remove(@NotNull MqttTopicFilterImpl topicFilter, @Nullable MqttSubscribedPublishFlow flow) {
        if (this.rootNode != null && this.rootNode.remove(MqttTopicLevel.root(topicFilter), flow)) {
            this.rootNode = null;
        }
    }

    @Override
    public void unsubscribe(@NotNull MqttTopicFilterImpl topicFilter, @Nullable Consumer<MqttSubscribedPublishFlow> unsubscribedCallback) {
        if (this.rootNode != null && this.rootNode.unsubscribe(MqttTopicLevel.root(topicFilter), unsubscribedCallback)) {
            this.rootNode = null;
        }
    }

    @Override
    public void cancel(@NotNull MqttSubscribedPublishFlow flow) {
        if (this.rootNode != null) {
            for (MqttTopicFilterImpl topicFilter : flow.getTopicFilters()) {
                this.rootNode.cancel(MqttTopicLevel.root(topicFilter), flow);
            }
        }
    }

    @Override
    public boolean findMatching(@NotNull MqttTopicImpl topic, @NotNull HandleList<MqttIncomingPublishFlow> matchingFlows) {
        return this.rootNode != null && this.rootNode.findMatching(MqttTopicLevel.root(topic), matchingFlows);
    }

    @Override
    public void clear(@NotNull Throwable cause) {
        if (this.rootNode != null) {
            this.rootNode.clear(cause);
            this.rootNode = null;
        }
    }

    private static class TopicTreeNode {
        @NotNull
        private final ByteArray parentLevel;
        @Nullable
        private HashMap<ByteArray, TopicTreeNode> next;
        @Nullable
        private HandleList<TopicTreeEntry> entries;
        @Nullable
        private HandleList<TopicTreeEntry> multiLevelEntries;
        private int subscriptions;
        private int multiLevelSubscriptions;
        private boolean hasSingleLevelSubscription;

        private TopicTreeNode(@NotNull ByteArray parentLevel, @Nullable MqttTopicLevel level, @Nullable TopicTreeEntry entry) {
            this.parentLevel = parentLevel;
            this.subscribe(level, entry);
        }

        void subscribe(@Nullable MqttTopicLevel level, @Nullable TopicTreeEntry entry) {
            if (level == null) {
                if (entry != null) {
                    if (this.entries == null) {
                        this.entries = new HandleList();
                    }
                    this.entries.add(entry);
                }
                ++this.subscriptions;
            } else if (level.isMultiLevelWildcard()) {
                if (entry != null) {
                    if (this.multiLevelEntries == null) {
                        this.multiLevelEntries = new HandleList();
                    }
                    this.multiLevelEntries.add(entry);
                }
                ++this.multiLevelSubscriptions;
            } else {
                TopicTreeNode node;
                if (this.next == null) {
                    this.next = new HashMap();
                    node = null;
                } else {
                    node = this.next.get(level);
                }
                if (node == null) {
                    if (level.isSingleLevelWildcard()) {
                        this.hasSingleLevelSubscription = true;
                    }
                    ByteArray levelCopy = level.copy();
                    this.next.put(levelCopy, new TopicTreeNode(levelCopy, level.next(), entry));
                } else {
                    node.subscribe(level.next(), entry);
                }
            }
        }

        boolean remove(@Nullable MqttTopicLevel level, @Nullable MqttSubscribedPublishFlow flow) {
            TopicTreeNode node;
            if (level == null) {
                if (TopicTreeNode.remove(this.entries, flow)) {
                    this.entries = null;
                }
                --this.subscriptions;
                return this.subscriptions == 0 && this.multiLevelSubscriptions == 0 && this.next == null;
            }
            if (level.isMultiLevelWildcard()) {
                if (TopicTreeNode.remove(this.multiLevelEntries, flow)) {
                    this.multiLevelEntries = null;
                }
                --this.multiLevelSubscriptions;
                return this.subscriptions == 0 && this.multiLevelSubscriptions == 0 && this.next == null;
            }
            if (this.next != null && (node = this.next.get(level)) != null && node.remove(level.next(), flow)) {
                return this.removeNext(node);
            }
            return false;
        }

        private static boolean remove(@Nullable HandleList<TopicTreeEntry> entries, @Nullable MqttSubscribedPublishFlow flow) {
            if (entries != null && flow != null) {
                Iterator<TopicTreeEntry> iterator = entries.iterator();
                while (iterator.hasNext()) {
                    TopicTreeEntry entry = iterator.next();
                    if (entry.flow != flow) continue;
                    entry.handle.remove();
                    iterator.remove();
                    break;
                }
                return entries.isEmpty();
            }
            return false;
        }

        boolean unsubscribe(@Nullable MqttTopicLevel level, @Nullable Consumer<MqttSubscribedPublishFlow> unsubscribedCallback) {
            TopicTreeNode node;
            if (level == null) {
                TopicTreeNode.unsubscribe(this.entries, unsubscribedCallback);
                this.entries = null;
                this.subscriptions = 0;
                return this.multiLevelSubscriptions == 0 && this.next == null;
            }
            if (level.isMultiLevelWildcard()) {
                TopicTreeNode.unsubscribe(this.multiLevelEntries, unsubscribedCallback);
                this.multiLevelEntries = null;
                this.multiLevelSubscriptions = 0;
                return this.subscriptions == 0 && this.next == null;
            }
            if (this.next != null && (node = this.next.get(level)) != null && node.unsubscribe(level.next(), unsubscribedCallback)) {
                return this.removeNext(node);
            }
            return false;
        }

        private static void unsubscribe(@Nullable HandleList<TopicTreeEntry> entries, @Nullable Consumer<MqttSubscribedPublishFlow> unsubscribedCallback) {
            if (entries != null) {
                for (TopicTreeEntry entry : entries) {
                    entry.handle.remove();
                    MqttSubscribedPublishFlow flow = entry.flow;
                    if (!flow.getTopicFilters().isEmpty()) continue;
                    flow.onComplete();
                    if (unsubscribedCallback == null) continue;
                    unsubscribedCallback.accept(flow);
                }
            }
        }

        private boolean removeNext(@NotNull TopicTreeNode node) {
            assert (this.next != null);
            if (node.parentLevel == MqttTopicLevel.SINGLE_LEVEL_WILDCARD) {
                this.hasSingleLevelSubscription = false;
            }
            this.next.remove(node.parentLevel);
            if (this.next.isEmpty()) {
                this.next = null;
                return this.subscriptions == 0 && this.multiLevelSubscriptions == 0;
            }
            return false;
        }

        void cancel(@Nullable MqttTopicLevel level, @NotNull MqttSubscribedPublishFlow flow) {
            TopicTreeNode node;
            if (level == null) {
                if (TopicTreeNode.cancel(this.entries, flow)) {
                    this.entries = null;
                }
            } else if (level.isMultiLevelWildcard()) {
                if (TopicTreeNode.cancel(this.multiLevelEntries, flow)) {
                    this.multiLevelEntries = null;
                }
            } else if (this.next != null && (node = this.next.get(level)) != null) {
                node.cancel(level.next(), flow);
            }
        }

        private static boolean cancel(@Nullable HandleList<TopicTreeEntry> entries, @NotNull MqttSubscribedPublishFlow flow) {
            if (entries != null) {
                Iterator<TopicTreeEntry> iterator = entries.iterator();
                while (iterator.hasNext()) {
                    TopicTreeEntry entry = iterator.next();
                    if (entry.flow != flow) continue;
                    iterator.remove();
                    break;
                }
                return entries.isEmpty();
            }
            return false;
        }

        boolean findMatching(@Nullable MqttTopicLevel level, @NotNull HandleList<MqttIncomingPublishFlow> matchingFlows) {
            boolean subscriptionFound;
            if (level == null) {
                TopicTreeNode.add(matchingFlows, this.entries);
                TopicTreeNode.add(matchingFlows, this.multiLevelEntries);
                return this.subscriptions != 0 || this.multiLevelSubscriptions != 0;
            }
            TopicTreeNode.add(matchingFlows, this.multiLevelEntries);
            boolean bl = subscriptionFound = this.multiLevelSubscriptions != 0;
            if (this.next != null) {
                TopicTreeNode node;
                if (this.hasSingleLevelSubscription) {
                    TopicTreeNode singleLevelNode = this.next.get(MqttTopicLevel.SINGLE_LEVEL_WILDCARD);
                    subscriptionFound |= singleLevelNode.findMatching(level.fork().next(), matchingFlows);
                }
                if ((node = this.next.get(level)) != null) {
                    subscriptionFound |= node.findMatching(level.next(), matchingFlows);
                }
            }
            return subscriptionFound;
        }

        private static void add(@NotNull HandleList<MqttIncomingPublishFlow> target, @Nullable HandleList<TopicTreeEntry> source) {
            if (source != null) {
                for (TopicTreeEntry entry : source) {
                    target.add(entry.flow);
                }
            }
        }

        void clear(@NotNull Throwable cause) {
            if (this.entries != null) {
                for (TopicTreeEntry entry : this.entries) {
                    entry.flow.onError(cause);
                }
                this.entries = null;
            }
            if (this.multiLevelEntries != null) {
                for (TopicTreeEntry multiLevelEntry : this.multiLevelEntries) {
                    multiLevelEntry.flow.onError(cause);
                }
                this.multiLevelEntries = null;
            }
            if (this.next != null) {
                this.next.values().forEach(node -> node.clear(cause));
                this.next = null;
            }
            this.subscriptions = 0;
            this.multiLevelSubscriptions = 0;
            this.hasSingleLevelSubscription = false;
        }
    }

    private static class TopicTreeEntry {
        @NotNull
        final MqttSubscribedPublishFlow flow;
        @NotNull
        final HandleList.Handle<MqttTopicFilterImpl> handle;

        TopicTreeEntry(@NotNull MqttSubscribedPublishFlow flow, @NotNull MqttTopicFilterImpl topicFilter) {
            this.flow = flow;
            this.handle = flow.getTopicFilters().add(topicFilter);
        }
    }
}

