/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.publish.outgoing;

import com.hivemq.client.internal.annotations.CallByThread;
import com.hivemq.client.internal.logging.InternalLogger;
import com.hivemq.client.internal.logging.InternalLoggerFactory;
import com.hivemq.client.internal.mqtt.MqttClientConfig;
import com.hivemq.client.internal.mqtt.MqttClientConnectionConfig;
import com.hivemq.client.internal.mqtt.advanced.interceptor.MqttClientInterceptors;
import com.hivemq.client.internal.mqtt.exceptions.MqttClientStateExceptions;
import com.hivemq.client.internal.mqtt.handler.MqttSessionAwareHandler;
import com.hivemq.client.internal.mqtt.handler.disconnect.MqttDisconnectUtil;
import com.hivemq.client.internal.mqtt.handler.publish.outgoing.MqttAckFlow;
import com.hivemq.client.internal.mqtt.handler.publish.outgoing.MqttPubOrRelWithFlow;
import com.hivemq.client.internal.mqtt.handler.publish.outgoing.MqttPubRelWithFlow;
import com.hivemq.client.internal.mqtt.handler.publish.outgoing.MqttPublishFlowables;
import com.hivemq.client.internal.mqtt.handler.publish.outgoing.MqttPublishWithFlow;
import com.hivemq.client.internal.mqtt.handler.publish.outgoing.MqttTopicAliasMapping;
import com.hivemq.client.internal.mqtt.ioc.ClientScope;
import com.hivemq.client.internal.mqtt.message.publish.MqttPublish;
import com.hivemq.client.internal.mqtt.message.publish.MqttPublishResult;
import com.hivemq.client.internal.mqtt.message.publish.MqttStatefulPublish;
import com.hivemq.client.internal.mqtt.message.publish.puback.MqttPubAck;
import com.hivemq.client.internal.mqtt.message.publish.pubcomp.MqttPubComp;
import com.hivemq.client.internal.mqtt.message.publish.pubrec.MqttPubRec;
import com.hivemq.client.internal.mqtt.message.publish.pubrel.MqttPubRel;
import com.hivemq.client.internal.mqtt.message.publish.pubrel.MqttPubRelBuilder;
import com.hivemq.client.internal.util.Ranges;
import com.hivemq.client.internal.util.collections.IntMap;
import com.hivemq.client.internal.util.netty.ContextFuture;
import com.hivemq.client.internal.util.netty.DefaultContextPromise;
import com.hivemq.client.mqtt.datatypes.MqttQos;
import com.hivemq.client.mqtt.exceptions.ConnectionClosedException;
import com.hivemq.client.mqtt.mqtt5.advanced.interceptor.qos1.Mqtt5OutgoingQos1Interceptor;
import com.hivemq.client.mqtt.mqtt5.advanced.interceptor.qos2.Mqtt5OutgoingQos2Interceptor;
import com.hivemq.client.mqtt.mqtt5.exceptions.Mqtt5PubAckException;
import com.hivemq.client.mqtt.mqtt5.exceptions.Mqtt5PubRecException;
import com.hivemq.client.mqtt.mqtt5.message.disconnect.Mqtt5DisconnectReasonCode;
import com.hivemq.client.mqtt.mqtt5.message.publish.puback.Mqtt5PubAckReasonCode;
import com.hivemq.client.mqtt.mqtt5.message.publish.pubrec.Mqtt5PubRecReasonCode;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.EventLoop;
import io.netty.util.concurrent.GenericFutureListener;
import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import org.jctools.queues.SpscUnboundedArrayQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Subscription;

@ClientScope
public class MqttOutgoingQosHandler
extends MqttSessionAwareHandler
implements FlowableSubscriber<MqttPublishWithFlow>,
Runnable,
ContextFuture.Listener<MqttPublishWithFlow> {
    @NotNull
    public static final String NAME = "qos.outgoing";
    @NotNull
    private static final InternalLogger LOGGER = InternalLoggerFactory.getLogger(MqttOutgoingQosHandler.class);
    private static final int MAX_CONCURRENT_PUBLISH_FLOWABLES = 64;
    private static final boolean QOS_2_COMPLETE_RESULT = false;
    @NotNull
    private final MqttClientConfig clientConfig;
    @NotNull
    private final MqttPublishFlowables publishFlowables;
    @NotNull
    private final SpscUnboundedArrayQueue<MqttPublishWithFlow> queue = new SpscUnboundedArrayQueue(32);
    @NotNull
    private final AtomicInteger queuedCounter = new AtomicInteger();
    private int sendMaximum;
    @Nullable
    private Ranges packetIdentifiers;
    @Nullable
    private IntMap<MqttPubOrRelWithFlow> pending;
    @Nullable
    private MqttPubOrRelWithFlow firstPending;
    @Nullable
    private MqttPubOrRelWithFlow lastPending;
    @Nullable
    private MqttPubOrRelWithFlow resendPending;
    @Nullable
    private MqttPublishWithFlow currentPending;
    @Nullable
    private MqttTopicAliasMapping topicAliasMapping;
    private int shrinkIds;
    private int shrinkRequests;
    @Nullable
    private Subscription subscription;

    @Inject
    MqttOutgoingQosHandler(@NotNull MqttClientConfig clientConfig, @NotNull MqttPublishFlowables publishFlowables) {
        this.clientConfig = clientConfig;
        this.publishFlowables = publishFlowables;
    }

    @Override
    public void onSessionStartOrResume(@NotNull MqttClientConnectionConfig connectionConfig, @NotNull EventLoop eventLoop) {
        int newSendMaximum;
        super.onSessionStartOrResume(connectionConfig, eventLoop);
        int oldSendMaximum = this.sendMaximum;
        this.sendMaximum = newSendMaximum = Math.min(connectionConfig.getSendMaximum(), 65525);
        if (oldSendMaximum == 0) {
            this.publishFlowables.flatMap(f -> f, true, 64, Math.min(newSendMaximum, Flowable.bufferSize())).subscribe((FlowableSubscriber)this);
            assert (this.subscription != null);
            this.packetIdentifiers = new Ranges(1, newSendMaximum);
            this.pending = IntMap.range(1, newSendMaximum);
            this.subscription.request((long)newSendMaximum);
        } else {
            assert (this.packetIdentifiers != null);
            assert (this.pending != null);
            assert (this.subscription != null);
            this.resize();
            int newRequests = newSendMaximum - oldSendMaximum - this.shrinkRequests;
            if (newRequests > 0) {
                this.shrinkRequests = 0;
                this.subscription.request((long)newRequests);
            } else {
                this.shrinkRequests = -newRequests;
            }
        }
        this.topicAliasMapping = connectionConfig.getSendTopicAliasMapping();
        if (this.firstPending != null || this.queuedCounter.get() > 0) {
            this.resendPending = this.firstPending;
            eventLoop.execute((Runnable)this);
        }
    }

    private void resize() {
        assert (this.packetIdentifiers != null);
        assert (this.pending != null);
        this.shrinkIds = this.packetIdentifiers.resize(this.sendMaximum);
        if (this.shrinkIds == 0) {
            this.pending = IntMap.resize(this.pending, this.sendMaximum);
        }
    }

    public void onSubscribe(@NotNull Subscription subscription) {
        this.subscription = subscription;
    }

    public void onNext(@NotNull MqttPublishWithFlow publishWithFlow) {
        this.queue.offer((Object)publishWithFlow);
        if (this.queuedCounter.getAndIncrement() == 0) {
            publishWithFlow.getAckFlow().getEventLoop().execute((Runnable)this);
        }
    }

    public void onComplete() {
        LOGGER.error("MqttPublishFlowables is global and must never complete. This must not happen and is a bug.");
    }

    public void onError(@NotNull Throwable t) {
        LOGGER.error("MqttPublishFlowables is global and must never error. This must not happen and is a bug.", t);
    }

    @CallByThread(value="Netty EventLoop")
    void request(long n) {
        assert (this.subscription != null);
        int shrinkRequests = this.shrinkRequests;
        if (this.shrinkRequests == 0) {
            this.subscription.request(n);
        } else if (n > (long)shrinkRequests) {
            this.shrinkRequests = 0;
            this.subscription.request(n - (long)shrinkRequests);
        } else {
            this.shrinkRequests = (int)((long)this.shrinkRequests - n);
        }
    }

    @Override
    @CallByThread(value="Netty EventLoop")
    public void run() {
        if (!this.hasSession) {
            this.clearQueued(MqttClientStateExceptions.notConnected());
            return;
        }
        ChannelHandlerContext ctx = this.ctx;
        if (ctx == null) {
            return;
        }
        assert (this.pending != null);
        int resent = 0;
        while (this.resendPending != null) {
            if (resent == this.sendMaximum) {
                ctx.flush();
                return;
            }
            if (this.resendPending instanceof MqttPublishWithFlow) {
                MqttPublishWithFlow publishWithFlow = (MqttPublishWithFlow)this.resendPending;
                MqttStatefulPublish publish = publishWithFlow.getPublish().createStateful(publishWithFlow.packetIdentifier, true, this.topicAliasMapping);
                this.writeQos1Or2Publish(ctx, publish, publishWithFlow);
            } else {
                MqttPubRelWithFlow pubRelWithFlow = (MqttPubRelWithFlow)this.resendPending;
                this.writePubRel(ctx, pubRelWithFlow.getPubRel());
            }
            ++resent;
            this.resendPending = this.resendPending.next;
        }
        int working = Math.min(Math.min(this.queuedCounter.get(), 64), this.sendMaximum - this.pending.size());
        for (int i = 0; i < working; ++i) {
            MqttPublishWithFlow publishWithFlow = (MqttPublishWithFlow)this.queue.poll();
            assert (publishWithFlow != null);
            this.writePublish(ctx, publishWithFlow);
        }
        ctx.flush();
        if (this.queuedCounter.addAndGet(-working) > 0) {
            ctx.channel().eventLoop().execute((Runnable)this);
        }
    }

    private void writePublish(@NotNull ChannelHandlerContext ctx, @NotNull MqttPublishWithFlow publishWithFlow) {
        if (publishWithFlow.getPublish().getQos() == MqttQos.AT_MOST_ONCE) {
            this.writeQos0Publish(ctx, publishWithFlow);
        } else {
            this.writeQos1Or2Publish(ctx, publishWithFlow);
        }
    }

    private void writeQos0Publish(@NotNull ChannelHandlerContext ctx, @NotNull MqttPublishWithFlow publishWithFlow) {
        ctx.write((Object)publishWithFlow.getPublish().createStateful(-1, false, this.topicAliasMapping), new DefaultContextPromise<MqttPublishWithFlow>(ctx.channel(), publishWithFlow)).addListener((GenericFutureListener)this);
    }

    public void operationComplete(@NotNull ContextFuture<? extends MqttPublishWithFlow> future) {
        MqttPublishWithFlow publishWithFlow = future.getContext();
        MqttPublish publish = publishWithFlow.getPublish();
        MqttAckFlow ackFlow = publishWithFlow.getAckFlow();
        Throwable cause = future.cause();
        if (!(cause instanceof IOException)) {
            ackFlow.onNext(new MqttPublishResult(publish, cause));
        } else {
            ackFlow.onNext(new MqttPublishResult(publish, new ConnectionClosedException(cause)));
            future.channel().pipeline().fireExceptionCaught(cause);
        }
    }

    private void writeQos1Or2Publish(@NotNull ChannelHandlerContext ctx, @NotNull MqttPublishWithFlow publishWithFlow) {
        assert (this.packetIdentifiers != null);
        assert (this.pending != null);
        int packetIdentifier = this.packetIdentifiers.getId();
        if (packetIdentifier < 0) {
            LOGGER.error("No Packet Identifier available for QoS 1 or 2 PUBLISH. This must not happen and is a bug.");
            return;
        }
        publishWithFlow.packetIdentifier = packetIdentifier;
        this.pending.put(packetIdentifier, publishWithFlow);
        MqttPubOrRelWithFlow lastPending = this.lastPending;
        if (lastPending == null) {
            this.firstPending = this.lastPending = publishWithFlow;
        } else {
            lastPending.next = publishWithFlow;
            publishWithFlow.prev = lastPending;
            this.lastPending = publishWithFlow;
        }
        this.writeQos1Or2Publish(ctx, publishWithFlow.getPublish().createStateful(packetIdentifier, false, this.topicAliasMapping), publishWithFlow);
    }

    private void writeQos1Or2Publish(@NotNull ChannelHandlerContext ctx, @NotNull MqttStatefulPublish publish, @NotNull MqttPublishWithFlow publishWithFlow) {
        this.currentPending = publishWithFlow;
        ctx.write((Object)publish, ctx.voidPromise());
        this.currentPending = null;
    }

    public void channelRead(@NotNull ChannelHandlerContext ctx, @NotNull Object msg) {
        if (msg instanceof MqttPubAck) {
            this.readPubAck(ctx, (MqttPubAck)msg);
        } else if (msg instanceof MqttPubRec) {
            this.readPubRec(ctx, (MqttPubRec)msg);
        } else if (msg instanceof MqttPubComp) {
            this.readPubComp(ctx, (MqttPubComp)msg);
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    private void readPubAck(@NotNull ChannelHandlerContext ctx, @NotNull MqttPubAck pubAck) {
        assert (this.pending != null);
        int packetIdentifier = pubAck.getPacketIdentifier();
        MqttPubOrRelWithFlow removed = this.pending.remove(packetIdentifier);
        if (removed == null) {
            MqttOutgoingQosHandler.error(ctx, "PUBACK contained unknown packet identifier");
            return;
        }
        if (!(removed instanceof MqttPublishWithFlow)) {
            this.pending.put(packetIdentifier, removed);
            MqttOutgoingQosHandler.error(ctx, "PUBACK must not be received for a PUBREL");
            return;
        }
        MqttPublishWithFlow publishWithFlow = (MqttPublishWithFlow)removed;
        MqttPublish publish = publishWithFlow.getPublish();
        if (publish.getQos() != MqttQos.AT_LEAST_ONCE) {
            this.pending.put(packetIdentifier, removed);
            MqttOutgoingQosHandler.error(ctx, "PUBACK must not be received for a QoS 2 PUBLISH");
            return;
        }
        this.completePending(ctx, publishWithFlow);
        this.onPubAck(publish, pubAck);
        Mqtt5PubAckException t = ((Mqtt5PubAckReasonCode)pubAck.getReasonCode()).isError() ? new Mqtt5PubAckException(pubAck, "PUBACK contained an Error Code") : null;
        publishWithFlow.getAckFlow().onNext(new MqttPublishResult.MqttQos1Result(publish, t, pubAck));
    }

    private void readPubRec(@NotNull ChannelHandlerContext ctx, @NotNull MqttPubRec pubRec) {
        assert (this.pending != null);
        int packetIdentifier = pubRec.getPacketIdentifier();
        MqttPubOrRelWithFlow got = this.pending.get(packetIdentifier);
        if (got == null) {
            MqttOutgoingQosHandler.error(ctx, "PUBREC contained unknown packet identifier");
            return;
        }
        if (!(got instanceof MqttPublishWithFlow)) {
            MqttOutgoingQosHandler.error(ctx, "PUBREC must not be received when the PUBREL has already been sent");
            return;
        }
        MqttPublishWithFlow publishWithFlow = (MqttPublishWithFlow)got;
        MqttPublish publish = publishWithFlow.getPublish();
        if (publish.getQos() != MqttQos.EXACTLY_ONCE) {
            MqttOutgoingQosHandler.error(ctx, "PUBREC must not be received for a QoS 1 PUBLISH");
            return;
        }
        MqttAckFlow ackFlow = publishWithFlow.getAckFlow();
        if (((Mqtt5PubRecReasonCode)pubRec.getReasonCode()).isError()) {
            this.pending.remove(packetIdentifier);
            this.completePending(ctx, publishWithFlow);
            this.onPubRecError(publish, pubRec);
            Mqtt5PubRecException t = new Mqtt5PubRecException(pubRec, "PUBREC contained an Error Code");
            ackFlow.onNext(new MqttPublishResult.MqttQos2Result(publish, t, pubRec));
        } else {
            MqttPubRel pubRel = this.buildPubRel(publish, pubRec);
            MqttPubRelWithFlow.MqttQos2IntermediateWithFlow pubRelWithFlow = new MqttPubRelWithFlow.MqttQos2IntermediateWithFlow(pubRel, ackFlow);
            this.replacePending(publishWithFlow, pubRelWithFlow);
            ackFlow.onNext(new MqttPublishResult.MqttQos2IntermediateResult(publish, pubRec, pubRelWithFlow));
            this.writePubRel(ctx, pubRel);
        }
    }

    private void writePubRel(@NotNull ChannelHandlerContext ctx, @NotNull MqttPubRel pubRel) {
        ctx.writeAndFlush((Object)pubRel, ctx.voidPromise());
    }

    private void replacePending(@NotNull MqttPublishWithFlow publishWithFlow, @NotNull MqttPubRelWithFlow pubRelWithFlow) {
        int packetIdentifier;
        assert (this.pending != null);
        pubRelWithFlow.packetIdentifier = packetIdentifier = publishWithFlow.packetIdentifier;
        this.pending.put(packetIdentifier, pubRelWithFlow);
        MqttPubOrRelWithFlow prev = publishWithFlow.prev;
        MqttPubOrRelWithFlow next = publishWithFlow.next;
        pubRelWithFlow.prev = prev;
        pubRelWithFlow.next = next;
        if (prev == null) {
            this.firstPending = pubRelWithFlow;
        } else {
            prev.next = pubRelWithFlow;
        }
        if (next == null) {
            this.lastPending = pubRelWithFlow;
        } else {
            next.prev = pubRelWithFlow;
        }
    }

    private void readPubComp(@NotNull ChannelHandlerContext ctx, @NotNull MqttPubComp pubComp) {
        assert (this.pending != null);
        int packetIdentifier = pubComp.getPacketIdentifier();
        MqttPubOrRelWithFlow removed = this.pending.remove(packetIdentifier);
        if (removed == null) {
            MqttOutgoingQosHandler.error(ctx, "PUBCOMP contained unknown packet identifier");
            return;
        }
        if (!(removed instanceof MqttPubRelWithFlow)) {
            this.pending.put(packetIdentifier, removed);
            MqttPublishWithFlow publishWithFlow = (MqttPublishWithFlow)removed;
            if (publishWithFlow.getPublish().getQos() == MqttQos.AT_LEAST_ONCE) {
                MqttOutgoingQosHandler.error(ctx, "PUBCOMP must not be received for a QoS 1 PUBLISH");
            } else {
                MqttOutgoingQosHandler.error(ctx, "PUBCOMP must not be received when the PUBREL has not been sent yet");
            }
            return;
        }
        MqttPubRelWithFlow pubRelWithFlow = (MqttPubRelWithFlow)removed;
        MqttPubRel pubRel = pubRelWithFlow.getPubRel();
        MqttAckFlow ackFlow = pubRelWithFlow.getAckFlow();
        this.completePending(ctx, pubRelWithFlow);
        this.onPubComp(pubRel, pubComp);
        MqttPubRelWithFlow.MqttQos2IntermediateWithFlow intermediate = (MqttPubRelWithFlow.MqttQos2IntermediateWithFlow)pubRelWithFlow;
        if (intermediate.getAsBoolean()) {
            ackFlow.acknowledged(1L);
        }
    }

    private void completePending(@NotNull ChannelHandlerContext ctx, @NotNull MqttPubOrRelWithFlow oldPending) {
        assert (this.packetIdentifiers != null);
        MqttPubOrRelWithFlow prev = oldPending.prev;
        MqttPubOrRelWithFlow next = oldPending.next;
        if (prev == null) {
            this.firstPending = next;
        } else {
            prev.next = next;
        }
        if (next == null) {
            this.lastPending = prev;
        } else {
            next.prev = prev;
        }
        int packetIdentifier = oldPending.packetIdentifier;
        this.packetIdentifiers.returnId(packetIdentifier);
        if (packetIdentifier > this.sendMaximum && --this.shrinkIds == 0) {
            this.resize();
        }
        if (this.resendPending != null) {
            ctx.channel().eventLoop().execute((Runnable)this);
        }
    }

    public void exceptionCaught(@NotNull ChannelHandlerContext ctx, @NotNull Throwable cause) {
        if (!(cause instanceof IOException) && this.currentPending != null) {
            assert (this.pending != null);
            this.pending.remove(this.currentPending.packetIdentifier);
            this.currentPending.getAckFlow().onNext(new MqttPublishResult(this.currentPending.getPublish(), cause));
            this.completePending(ctx, this.currentPending);
            this.currentPending = null;
        } else {
            ctx.fireExceptionCaught(cause);
        }
    }

    @Override
    public void onSessionEnd(@NotNull Throwable cause) {
        super.onSessionEnd(cause);
        assert (this.packetIdentifiers != null);
        assert (this.pending != null);
        MqttPubOrRelWithFlow current = this.firstPending;
        while (current != null) {
            this.packetIdentifiers.returnId(current.packetIdentifier);
            if (current instanceof MqttPublishWithFlow) {
                MqttPublishWithFlow publishWithFlow = (MqttPublishWithFlow)current;
                current.getAckFlow().onNext(new MqttPublishResult(publishWithFlow.getPublish(), cause));
            } else {
                MqttPubRelWithFlow.MqttQos2IntermediateWithFlow intermediate = (MqttPubRelWithFlow.MqttQos2IntermediateWithFlow)current;
                if (intermediate.getAsBoolean()) {
                    intermediate.getAckFlow().acknowledged(1L);
                }
            }
            current = current.next;
        }
        this.pending.clear();
        this.resendPending = null;
        this.lastPending = null;
        this.firstPending = null;
        this.clearQueued(cause);
    }

    private void clearQueued(@NotNull Throwable cause) {
        int polled = 0;
        while (true) {
            MqttPublishWithFlow publishWithFlow;
            if ((publishWithFlow = (MqttPublishWithFlow)this.queue.poll()) == null) {
                if (this.queuedCounter.addAndGet(-polled) == 0) break;
                polled = 0;
                continue;
            }
            publishWithFlow.getAckFlow().onNext(new MqttPublishResult(publishWithFlow.getPublish(), cause));
            ++polled;
        }
    }

    private static void error(@NotNull ChannelHandlerContext ctx, @NotNull String reasonString) {
        MqttDisconnectUtil.disconnect(ctx.channel(), Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, reasonString);
    }

    private void onPubAck(@NotNull MqttPublish publish, @NotNull MqttPubAck pubAck) {
        Mqtt5OutgoingQos1Interceptor interceptor;
        MqttClientInterceptors interceptors = this.clientConfig.getAdvancedConfig().getInterceptors();
        if (interceptors != null && (interceptor = interceptors.getOutgoingQos1Interceptor()) != null) {
            interceptor.onPubAck(this.clientConfig, publish, pubAck);
        }
    }

    private void onPubRecError(@NotNull MqttPublish publish, @NotNull MqttPubRec pubRec) {
        Mqtt5OutgoingQos2Interceptor interceptor;
        MqttClientInterceptors interceptors = this.clientConfig.getAdvancedConfig().getInterceptors();
        if (interceptors != null && (interceptor = interceptors.getOutgoingQos2Interceptor()) != null) {
            interceptor.onPubRecError(this.clientConfig, publish, pubRec);
        }
    }

    @NotNull
    private MqttPubRel buildPubRel(@NotNull MqttPublish publish, @NotNull MqttPubRec pubRec) {
        Mqtt5OutgoingQos2Interceptor interceptor;
        MqttPubRelBuilder pubRelBuilder = new MqttPubRelBuilder(pubRec);
        MqttClientInterceptors interceptors = this.clientConfig.getAdvancedConfig().getInterceptors();
        if (interceptors != null && (interceptor = interceptors.getOutgoingQos2Interceptor()) != null) {
            interceptor.onPubRec(this.clientConfig, publish, pubRec, pubRelBuilder);
        }
        return pubRelBuilder.build();
    }

    private void onPubComp(@NotNull MqttPubRel pubRel, @NotNull MqttPubComp pubComp) {
        Mqtt5OutgoingQos2Interceptor interceptor;
        MqttClientInterceptors interceptors = this.clientConfig.getAdvancedConfig().getInterceptors();
        if (interceptors != null && (interceptor = interceptors.getOutgoingQos2Interceptor()) != null) {
            interceptor.onPubComp(this.clientConfig, pubRel, pubComp);
        }
    }

    @NotNull
    MqttPublishFlowables getPublishFlowables() {
        return this.publishFlowables;
    }
}

