/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.ssl;

import com.hivemq.client.internal.mqtt.MqttClientSslConfigImpl;
import com.hivemq.client.internal.util.collections.ImmutableList;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import org.jetbrains.annotations.NotNull;

public final class SslUtil {
    @NotNull
    private static final String SSL_HANDLER_NAME = "ssl";

    public static void initChannel(@NotNull Channel channel, @NotNull MqttClientSslConfigImpl sslConfig) throws SSLException {
        channel.pipeline().addFirst(SSL_HANDLER_NAME, (ChannelHandler)SslUtil.createSslHandler(channel, sslConfig));
    }

    @NotNull
    private static SslHandler createSslHandler(@NotNull Channel channel, @NotNull MqttClientSslConfigImpl sslConfig) throws SSLException {
        SSLEngine sslEngine = SslUtil.createSslEngine(channel, sslConfig);
        SslHandler sslHandler = new SslHandler(sslEngine);
        sslHandler.setHandshakeTimeoutMillis(sslConfig.getHandshakeTimeoutMs());
        return sslHandler;
    }

    @NotNull
    static SSLEngine createSslEngine(@NotNull Channel channel, @NotNull MqttClientSslConfigImpl sslConfig) throws SSLException {
        SSLEngine sslEngine = SslUtil.createSslContext(sslConfig).newEngine(channel.alloc());
        sslEngine.setUseClientMode(true);
        return sslEngine;
    }

    @NotNull
    private static SslContext createSslContext(@NotNull MqttClientSslConfigImpl sslConfig) throws SSLException {
        SslContextBuilder sslContextBuilder = SslContextBuilder.forClient().sslProvider(SslProvider.JDK).trustManager(sslConfig.getRawTrustManagerFactory()).keyManager(sslConfig.getRawKeyManagerFactory());
        ImmutableList<String> protocols = sslConfig.getRawProtocols();
        String[] protocolArray = protocols == null ? null : protocols.toArray(new String[protocols.size()]);
        sslContextBuilder.protocols(protocolArray);
        sslContextBuilder.ciphers(sslConfig.getRawCipherSuites(), (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE);
        return sslContextBuilder.build();
    }

    private SslUtil() {
    }
}

