/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.subscribe;

import com.hivemq.client.internal.mqtt.MqttClientConfig;
import com.hivemq.client.internal.mqtt.exceptions.MqttClientStateExceptions;
import com.hivemq.client.internal.mqtt.handler.subscribe.MqttSubOrUnsubAckFlow;
import com.hivemq.client.internal.mqtt.handler.subscribe.MqttSubscriptionHandler;
import com.hivemq.client.internal.mqtt.ioc.ClientComponent;
import com.hivemq.client.internal.mqtt.message.unsubscribe.MqttUnsubscribe;
import com.hivemq.client.mqtt.mqtt5.message.unsubscribe.unsuback.Mqtt5UnsubAck;
import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.internal.disposables.EmptyDisposable;
import org.jetbrains.annotations.NotNull;

public class MqttUnsubAckSingle
extends Single<Mqtt5UnsubAck> {
    @NotNull
    private final MqttUnsubscribe unsubscribe;
    @NotNull
    private final MqttClientConfig clientConfig;

    public MqttUnsubAckSingle(@NotNull MqttUnsubscribe unsubscribe, @NotNull MqttClientConfig clientConfig) {
        this.unsubscribe = unsubscribe;
        this.clientConfig = clientConfig;
    }

    protected void subscribeActual(@NotNull SingleObserver<? super Mqtt5UnsubAck> observer) {
        if (this.clientConfig.getState().isConnectedOrReconnect()) {
            ClientComponent clientComponent = this.clientConfig.getClientComponent();
            MqttSubscriptionHandler subscriptionHandler = clientComponent.subscriptionHandler();
            MqttSubOrUnsubAckFlow<? super Mqtt5UnsubAck> flow = new MqttSubOrUnsubAckFlow<Mqtt5UnsubAck>(observer, this.clientConfig);
            observer.onSubscribe(flow);
            subscriptionHandler.unsubscribe(this.unsubscribe, flow);
        } else {
            EmptyDisposable.error((Throwable)MqttClientStateExceptions.notConnected(), observer);
        }
    }
}

