/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.message.connect;

import com.hivemq.client.internal.mqtt.message.connect.MqttConnectRestrictions;
import com.hivemq.client.internal.mqtt.util.MqttChecks;
import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.mqtt.mqtt5.message.connect.Mqtt5ConnectRestrictionsBuilder;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public abstract class MqttConnectRestrictionsBuilder<B extends MqttConnectRestrictionsBuilder<B>> {
    private int receiveMaximum = 65535;
    private int sendMaximum = 65535;
    private int maximumPacketSize = 0x10000004;
    private int sendMaximumPacketSize = 0x10000004;
    private int topicAliasMaximum = 0;
    private int sendTopicAliasMaximum = 16;
    private boolean requestProblemInformation = true;
    private boolean requestResponseInformation = false;

    MqttConnectRestrictionsBuilder() {
    }

    MqttConnectRestrictionsBuilder(@NotNull MqttConnectRestrictions restrictions) {
        this.receiveMaximum = restrictions.getReceiveMaximum();
        this.sendMaximum = restrictions.getSendMaximum();
        this.maximumPacketSize = restrictions.getMaximumPacketSize();
        this.sendMaximumPacketSize = restrictions.getSendMaximumPacketSize();
        this.topicAliasMaximum = restrictions.getTopicAliasMaximum();
        this.sendTopicAliasMaximum = restrictions.getSendTopicAliasMaximum();
        this.requestProblemInformation = restrictions.isRequestProblemInformation();
        this.requestResponseInformation = restrictions.isRequestResponseInformation();
    }

    @NotNull
    abstract B self();

    @NotNull
    public B receiveMaximum(int receiveMaximum) {
        this.receiveMaximum = Checks.unsignedShortNotZero(receiveMaximum, "Receive maximum");
        return this.self();
    }

    @NotNull
    public B sendMaximum(int sendMaximum) {
        this.sendMaximum = Checks.unsignedShortNotZero(sendMaximum, "Send maximum");
        return this.self();
    }

    @NotNull
    public B maximumPacketSize(int maximumPacketSize) {
        this.maximumPacketSize = MqttChecks.packetSize(maximumPacketSize, "Maximum packet size");
        return this.self();
    }

    @NotNull
    public B sendMaximumPacketSize(int sendMaximumPacketSize) {
        this.sendMaximumPacketSize = MqttChecks.packetSize(sendMaximumPacketSize, "Send maximum packet size");
        return this.self();
    }

    @NotNull
    public B topicAliasMaximum(int topicAliasMaximum) {
        this.topicAliasMaximum = Checks.unsignedShort(topicAliasMaximum, "Topic alias maximum");
        return this.self();
    }

    @NotNull
    public B sendTopicAliasMaximum(int sendTopicAliasMaximum) {
        this.sendTopicAliasMaximum = Checks.unsignedShort(sendTopicAliasMaximum, "Send topic alias maximum");
        return this.self();
    }

    @NotNull
    public B requestProblemInformation(boolean requestProblemInformation) {
        this.requestProblemInformation = requestProblemInformation;
        return this.self();
    }

    @NotNull
    public B requestResponseInformation(boolean requestResponseInformation) {
        this.requestResponseInformation = requestResponseInformation;
        return this.self();
    }

    @NotNull
    public MqttConnectRestrictions build() {
        return new MqttConnectRestrictions(this.receiveMaximum, this.sendMaximum, this.maximumPacketSize, this.sendMaximumPacketSize, this.topicAliasMaximum, this.sendTopicAliasMaximum, this.requestProblemInformation, this.requestResponseInformation);
    }

    public static class Nested<P>
    extends MqttConnectRestrictionsBuilder<Nested<P>>
    implements Mqtt5ConnectRestrictionsBuilder.Nested<P> {
        @NotNull
        private final Function<? super MqttConnectRestrictions, P> parentConsumer;

        Nested(@NotNull MqttConnectRestrictions restrictions, @NotNull Function<? super MqttConnectRestrictions, P> parentConsumer) {
            super(restrictions);
            this.parentConsumer = parentConsumer;
        }

        @Override
        @NotNull
        Nested<P> self() {
            return this;
        }

        @Override
        @NotNull
        public P applyRestrictions() {
            return this.parentConsumer.apply(this.build());
        }
    }

    public static class Default
    extends MqttConnectRestrictionsBuilder<Default>
    implements Mqtt5ConnectRestrictionsBuilder {
        public Default() {
        }

        Default(@NotNull MqttConnectRestrictions restrictions) {
            super(restrictions);
        }

        @Override
        @NotNull
        Default self() {
            return this;
        }
    }
}

