/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.mqtt3;

import com.hivemq.client.internal.mqtt.MqttAsyncClient;
import com.hivemq.client.internal.mqtt.message.connect.MqttConnect;
import com.hivemq.client.internal.mqtt.message.connect.connack.mqtt3.Mqtt3ConnAckView;
import com.hivemq.client.internal.mqtt.message.disconnect.mqtt3.Mqtt3DisconnectView;
import com.hivemq.client.internal.mqtt.message.publish.MqttPublish;
import com.hivemq.client.internal.mqtt.message.publish.mqtt3.Mqtt3PublishView;
import com.hivemq.client.internal.mqtt.message.subscribe.MqttSubscribe;
import com.hivemq.client.internal.mqtt.message.subscribe.mqtt3.Mqtt3SubscribeView;
import com.hivemq.client.internal.mqtt.message.subscribe.mqtt3.Mqtt3SubscribeViewBuilder;
import com.hivemq.client.internal.mqtt.message.subscribe.suback.mqtt3.Mqtt3SubAckView;
import com.hivemq.client.internal.mqtt.message.unsubscribe.MqttUnsubscribe;
import com.hivemq.client.internal.mqtt.mqtt3.Mqtt3BlockingClientView;
import com.hivemq.client.internal.mqtt.mqtt3.Mqtt3ClientConfigView;
import com.hivemq.client.internal.mqtt.mqtt3.Mqtt3RxClientView;
import com.hivemq.client.internal.mqtt.mqtt3.exceptions.Mqtt3ExceptionFactory;
import com.hivemq.client.internal.mqtt.util.MqttChecks;
import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.mqtt.MqttGlobalPublishFilter;
import com.hivemq.client.mqtt.mqtt3.Mqtt3AsyncClient;
import com.hivemq.client.mqtt.mqtt3.Mqtt3BlockingClient;
import com.hivemq.client.mqtt.mqtt3.Mqtt3ClientConfig;
import com.hivemq.client.mqtt.mqtt3.Mqtt3RxClient;
import com.hivemq.client.mqtt.mqtt3.message.connect.Mqtt3Connect;
import com.hivemq.client.mqtt.mqtt3.message.connect.connack.Mqtt3ConnAck;
import com.hivemq.client.mqtt.mqtt3.message.publish.Mqtt3Publish;
import com.hivemq.client.mqtt.mqtt3.message.subscribe.Mqtt3Subscribe;
import com.hivemq.client.mqtt.mqtt3.message.subscribe.suback.Mqtt3SubAck;
import com.hivemq.client.mqtt.mqtt3.message.unsubscribe.Mqtt3Unsubscribe;
import com.hivemq.client.mqtt.mqtt5.message.connect.connack.Mqtt5ConnAck;
import com.hivemq.client.mqtt.mqtt5.message.publish.Mqtt5Publish;
import com.hivemq.client.mqtt.mqtt5.message.publish.Mqtt5PublishResult;
import com.hivemq.client.mqtt.mqtt5.message.subscribe.suback.Mqtt5SubAck;
import com.hivemq.client.mqtt.mqtt5.message.unsubscribe.unsuback.Mqtt5UnsubAck;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Mqtt3AsyncClientView
implements Mqtt3AsyncClient {
    @NotNull
    private static final BiFunction<Mqtt5ConnAck, Throwable, Mqtt3ConnAck> CONNACK_MAPPER = (connAck, throwable) -> {
        if (throwable != null) {
            throw new CompletionException(Mqtt3ExceptionFactory.map(throwable));
        }
        return Mqtt3ConnAckView.of(connAck);
    };
    @NotNull
    private static final BiFunction<Mqtt5SubAck, Throwable, Mqtt3SubAck> SUBACK_MAPPER = (subAck, throwable) -> {
        if (throwable != null) {
            throw new CompletionException(Mqtt3ExceptionFactory.map(throwable));
        }
        return Mqtt3SubAckView.of(subAck);
    };
    @NotNull
    private static final BiFunction<Mqtt5UnsubAck, Throwable, Void> UNSUBACK_MAPPER = (unsubAck, throwable) -> {
        if (throwable != null) {
            throw new CompletionException(Mqtt3ExceptionFactory.map(throwable));
        }
        return null;
    };
    @NotNull
    private static final BiFunction<Mqtt5PublishResult, Throwable, Mqtt3Publish> PUBLISH_RESULT_MAPPER = (publishResult, throwable) -> {
        if (throwable != null) {
            throw new CompletionException(Mqtt3ExceptionFactory.map(throwable));
        }
        return Mqtt3PublishView.of(publishResult.getPublish());
    };
    @NotNull
    private static final Function<Throwable, Void> DISCONNECT_MAPPER = throwable -> {
        throw new CompletionException(Mqtt3ExceptionFactory.map(throwable));
    };
    @NotNull
    private final MqttAsyncClient delegate;
    @NotNull
    private final Mqtt3ClientConfigView clientConfig;

    @NotNull
    private static Consumer<Mqtt5Publish> callbackView(@NotNull Consumer<Mqtt3Publish> callback) {
        return publish -> callback.accept(Mqtt3PublishView.of(publish));
    }

    Mqtt3AsyncClientView(@NotNull MqttAsyncClient delegate) {
        this.delegate = delegate;
        this.clientConfig = new Mqtt3ClientConfigView(delegate.getConfig());
    }

    @Override
    @NotNull
    public @NotNull CompletableFuture<@NotNull Mqtt3ConnAck> connect(@Nullable Mqtt3Connect connect) {
        MqttConnect mqttConnect = MqttChecks.connect(connect);
        return this.delegate.connect(mqttConnect).handle(CONNACK_MAPPER);
    }

    @Override
    @NotNull
    public @NotNull CompletableFuture<@NotNull Mqtt3SubAck> subscribe(@Nullable Mqtt3Subscribe subscribe) {
        MqttSubscribe mqttSubscribe = MqttChecks.subscribe(subscribe);
        return this.delegate.subscribe(mqttSubscribe).handle(SUBACK_MAPPER);
    }

    @Override
    @NotNull
    public @NotNull CompletableFuture<@NotNull Mqtt3SubAck> subscribe(@Nullable Mqtt3Subscribe subscribe, @Nullable Consumer<@NotNull Mqtt3Publish> callback) {
        MqttSubscribe mqttSubscribe = MqttChecks.subscribe(subscribe);
        Checks.notNull(callback, "Callback");
        return this.delegate.subscribe(mqttSubscribe, Mqtt3AsyncClientView.callbackView(callback)).handle(SUBACK_MAPPER);
    }

    @Override
    @NotNull
    public @NotNull CompletableFuture<@NotNull Mqtt3SubAck> subscribe(@Nullable Mqtt3Subscribe subscribe, @Nullable Consumer<@NotNull Mqtt3Publish> callback, @Nullable Executor executor) {
        MqttSubscribe mqttSubscribe = MqttChecks.subscribe(subscribe);
        Checks.notNull(callback, "Callback");
        Checks.notNull(executor, "Executor");
        return this.delegate.subscribe(mqttSubscribe, Mqtt3AsyncClientView.callbackView(callback), executor).handle(SUBACK_MAPPER);
    }

    @Override
    public void publishes(@Nullable MqttGlobalPublishFilter filter, @Nullable Consumer<@NotNull Mqtt3Publish> callback) {
        Checks.notNull(filter, "Global publish filter");
        Checks.notNull(callback, "Callback");
        this.delegate.publishes(filter, Mqtt3AsyncClientView.callbackView(callback));
    }

    @Override
    public void publishes(@Nullable MqttGlobalPublishFilter filter, @Nullable Consumer<@NotNull Mqtt3Publish> callback, @Nullable Executor executor) {
        Checks.notNull(filter, "Global publish filter");
        Checks.notNull(callback, "Callback");
        Checks.notNull(executor, "Executor");
        this.delegate.publishes(filter, Mqtt3AsyncClientView.callbackView(callback), executor);
    }

    @Override
    @NotNull
    public CompletableFuture<Void> unsubscribe(@Nullable Mqtt3Unsubscribe unsubscribe) {
        MqttUnsubscribe mqttUnsubscribe = MqttChecks.unsubscribe(unsubscribe);
        return this.delegate.unsubscribe(mqttUnsubscribe).handle(UNSUBACK_MAPPER);
    }

    @Override
    @NotNull
    public @NotNull CompletableFuture<@NotNull Mqtt3Publish> publish(@Nullable Mqtt3Publish publish) {
        MqttPublish mqttPublish = MqttChecks.publish(publish);
        return this.delegate.publish(mqttPublish).handle(PUBLISH_RESULT_MAPPER);
    }

    @Override
    @NotNull
    public CompletableFuture<Void> disconnect() {
        return this.delegate.disconnect(Mqtt3DisconnectView.DELEGATE).exceptionally((Function)DISCONNECT_MAPPER);
    }

    @Override
    @NotNull
    public Mqtt3ClientConfig getConfig() {
        return this.clientConfig;
    }

    @Override
    @NotNull
    public Mqtt3RxClient toRx() {
        return new Mqtt3RxClientView(this.delegate.toRx());
    }

    @Override
    @NotNull
    public Mqtt3BlockingClient toBlocking() {
        return new Mqtt3BlockingClientView(this.delegate.toBlocking());
    }

    public static class Mqtt3SubscribeViewAndCallbackBuilder
    extends Mqtt3SubscribeViewBuilder<Mqtt3SubscribeViewAndCallbackBuilder>
    implements Mqtt3AsyncClient.Mqtt3SubscribeAndCallbackBuilder.Start.Complete,
    Mqtt3AsyncClient.Mqtt3SubscribeAndCallbackBuilder.Call.Ex {
        @NotNull
        private final Mqtt3AsyncClient client;
        @Nullable
        private Consumer<Mqtt3Publish> callback;
        @Nullable
        private Executor executor;

        public Mqtt3SubscribeViewAndCallbackBuilder(@NotNull Mqtt3AsyncClient client) {
            this.client = client;
        }

        @Override
        @NotNull
        protected Mqtt3SubscribeViewAndCallbackBuilder self() {
            return this;
        }

        @Override
        @NotNull
        public Mqtt3SubscribeViewAndCallbackBuilder callback(@Nullable Consumer<Mqtt3Publish> callback) {
            this.callback = Checks.notNull(callback, "Callback");
            return this;
        }

        @Override
        @NotNull
        public Mqtt3SubscribeViewAndCallbackBuilder executor(@Nullable Executor executor) {
            this.executor = Checks.notNull(executor, "Executor");
            return this;
        }

        @Override
        @NotNull
        public CompletableFuture<Mqtt3SubAck> send() {
            Mqtt3SubscribeView subscribe = this.build();
            if (this.callback == null) {
                if (this.executor != null) {
                    throw new IllegalStateException("Executor must not be given if callback is null.");
                }
                return this.client.subscribe(subscribe);
            }
            if (this.executor == null) {
                return this.client.subscribe(subscribe, this.callback);
            }
            return this.client.subscribe(subscribe, this.callback, this.executor);
        }
    }
}

