/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.rx;

import io.reactivex.FlowableSubscriber;
import io.reactivex.internal.fuseable.QueueSubscription;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public abstract class FuseableSubscriber<U, D, S extends Subscriber<? super D>>
implements FlowableSubscriber<U>,
QueueSubscription<D> {
    @NotNull
    protected final S subscriber;
    @Nullable
    protected Subscription subscription;
    @Nullable
    protected QueueSubscription<U> queueSubscription;
    protected int sourceMode = 0;

    public FuseableSubscriber(@NotNull S subscriber) {
        this.subscriber = subscriber;
    }

    public void onSubscribe(@NotNull Subscription subscription) {
        this.subscription = subscription;
        if (subscription instanceof QueueSubscription) {
            this.queueSubscription = (QueueSubscription)subscription;
        }
        this.subscriber.onSubscribe((Subscription)this);
    }

    public void request(long n) {
        assert (this.subscription != null);
        this.subscription.request(n);
    }

    public void cancel() {
        assert (this.subscription != null);
        this.subscription.cancel();
    }

    public int requestFusion(int mode) {
        if (this.queueSubscription != null && (mode & 4) == 0) {
            this.sourceMode = this.queueSubscription.requestFusion(mode);
        }
        return this.sourceMode;
    }

    public boolean isEmpty() {
        assert (this.queueSubscription != null);
        return this.queueSubscription.isEmpty();
    }

    public void clear() {
        assert (this.queueSubscription != null);
        this.queueSubscription.clear();
    }

    public final boolean offer(@NotNull D value) {
        throw new UnsupportedOperationException("Should not be called!");
    }

    public final boolean offer(@NotNull D v1, @NotNull D v2) {
        throw new UnsupportedOperationException("Should not be called!");
    }
}

