/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.util.collections;

import com.hivemq.client.annotations.Immutable;
import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.internal.util.collections.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
class ImmutableEmptyList
implements ImmutableList<Object> {
    @NotNull
    private static final ImmutableEmptyList INSTANCE = new ImmutableEmptyList();
    @NotNull
    private static final @NotNull Object @NotNull [] EMPTY = new Object[0];

    @NotNull
    static <E> ImmutableList<E> of() {
        return INSTANCE;
    }

    private ImmutableEmptyList() {
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    @NotNull
    public Object get(int index) {
        throw new IndexOutOfBoundsException("Empty list");
    }

    @Override
    @NotNull
    public @NotNull Object @NotNull [] toArray() {
        return EMPTY;
    }

    @Override
    public <T> T @NotNull [] toArray(T @NotNull [] other) {
        Checks.notNull(other, "Array");
        if (other.length > 0) {
            other[0] = null;
        }
        return other;
    }

    @Override
    public boolean contains(@Nullable Object o) {
        return false;
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        Checks.notNull(c, "Collection");
        return c.size() == 0;
    }

    @Override
    public int indexOf(@Nullable Object o) {
        return -1;
    }

    @Override
    public int lastIndexOf(@Nullable Object o) {
        return -1;
    }

    @Override
    @NotNull
    public ImmutableList.ImmutableListIterator<Object> listIterator(int index) {
        Checks.cursorIndex(index, 0);
        return EmptyIterator.of();
    }

    @Override
    @NotNull
    public Spliterator<Object> spliterator() {
        return EmptySpliterator.of();
    }

    @Override
    public void forEach(@NotNull Consumer<? super Object> consumer) {
        Checks.notNull(consumer, "Consumer");
    }

    @Override
    @NotNull
    public ImmutableList<Object> subList(int fromIndex, int toIndex) {
        Checks.indexRange(fromIndex, toIndex, 0);
        return this;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        return ((List)o).size() == 0;
    }

    @Override
    public int hashCode() {
        return 1;
    }

    @NotNull
    public String toString() {
        return "[]";
    }

    private static class EmptySpliterator
    implements Spliterator<Object> {
        @NotNull
        private static final EmptySpliterator INSTANCE = new EmptySpliterator();

        @NotNull
        static <E> Spliterator<E> of() {
            return INSTANCE;
        }

        private EmptySpliterator() {
        }

        @Override
        public boolean tryAdvance(@NotNull Consumer<? super Object> consumer) {
            Checks.notNull(consumer, "Consumer");
            return false;
        }

        @Override
        @Nullable
        public Spliterator<Object> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return 0L;
        }

        @Override
        public long getExactSizeIfKnown() {
            return 0L;
        }

        @Override
        public int characteristics() {
            return 17745;
        }

        @Override
        public void forEachRemaining(@NotNull Consumer<? super Object> consumer) {
            Checks.notNull(consumer, "Consumer");
        }
    }

    private static class EmptyIterator
    implements ImmutableList.ImmutableListIterator<Object> {
        @NotNull
        private static final EmptyIterator INSTANCE = new EmptyIterator();

        @NotNull
        static <E> ImmutableList.ImmutableListIterator<E> of() {
            return INSTANCE;
        }

        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        @NotNull
        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasPrevious() {
            return false;
        }

        @Override
        @NotNull
        public Object previous() {
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            return 0;
        }

        @Override
        public int previousIndex() {
            return -1;
        }

        @Override
        public void forEachRemaining(@NotNull Consumer<? super Object> consumer) {
            Checks.notNull(consumer, "Consumer");
        }
    }
}

