/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.datatypes;

import com.hivemq.client.internal.mqtt.datatypes.MqttTopicFilterImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttTopicImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttTopicLevel;
import com.hivemq.client.internal.mqtt.datatypes.MqttTopicLevels;
import com.hivemq.client.internal.util.ByteArrayUtil;
import java.util.Arrays;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

public class MqttTopicIterator
extends MqttTopicLevel {
    private int start;
    private int end;
    private final int allEnd;

    @NotNull
    public static MqttTopicIterator of(@NotNull MqttTopicImpl topic) {
        byte[] binary = topic.toBinary();
        return new MqttTopicIterator(binary, -1, -1, binary.length);
    }

    @NotNull
    public static MqttTopicIterator of(@NotNull MqttTopicFilterImpl topicFilter) {
        byte[] binary = topicFilter.toBinary();
        int start = topicFilter.getFilterByteStart() - 1;
        return new MqttTopicIterator(binary, start, start, topicFilter.containsMultiLevelWildcard() ? binary.length - 2 : binary.length);
    }

    private MqttTopicIterator(@NotNull byte[] array, int start, int end, int allEnd) {
        super(array);
        this.start = start;
        this.end = end;
        this.allEnd = allEnd;
    }

    @Override
    protected int getStart() {
        return this.start;
    }

    @Override
    protected int getEnd() {
        return this.end;
    }

    public boolean hasNext() {
        return this.end != this.allEnd;
    }

    public boolean hasMultiLevelWildcard() {
        return this.allEnd != this.array.length;
    }

    @NotNull
    public MqttTopicIterator fork() {
        return new MqttTopicIterator(this.array, this.start, this.end, this.allEnd);
    }

    @NotNull
    public MqttTopicLevel next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.start = this.end + 1;
        this.end = ByteArrayUtil.indexOf(this.array, this.start, (byte)47);
        return this;
    }

    @Override
    @NotNull
    public MqttTopicLevel trim() {
        if (!this.hasNext()) {
            return MqttTopicLevel.of(this.array, this.start, this.end);
        }
        int start = this.start;
        int end = this.end;
        this.start = this.end = this.allEnd;
        return new MqttTopicLevels(Arrays.copyOfRange(this.array, start, this.allEnd), end - start);
    }

    public boolean forwardIfEqual(@NotNull MqttTopicLevels levels) {
        int levelsEnd;
        byte[] levelsArray = levels.getArray();
        int to = this.end + levelsArray.length - (levelsEnd = levels.getEnd());
        if (to <= this.allEnd && (to == this.allEnd || this.array[to] == 47) && ByteArrayUtil.equals(this.array, this.end + 1, to, levelsArray, levelsEnd + 1, levelsArray.length)) {
            this.start = this.end = to;
            return true;
        }
        return false;
    }

    public int forwardWhileEqual(@NotNull MqttTopicLevels levels) {
        if (!this.hasNext()) {
            return levels.getEnd();
        }
        int branchIndex = this.end;
        int levelsBranchIndex = levels.getEnd();
        int index = branchIndex + 1;
        int levelsIndex = levelsBranchIndex + 1;
        byte[] levelsArray = levels.getArray();
        while (true) {
            boolean isLevelsEnd;
            boolean isEnd = index == this.allEnd;
            boolean bl = isLevelsEnd = levelsIndex == levelsArray.length;
            if (isLevelsEnd || isEnd) {
                if (!isLevelsEnd && levelsArray[levelsIndex] != 47 || !isEnd && this.array[index] != 47) break;
                branchIndex = index;
                levelsBranchIndex = levelsIndex;
                break;
            }
            byte lb = levelsArray[levelsIndex];
            if (this.array[index] != lb) break;
            if (lb == 47) {
                branchIndex = index;
                levelsBranchIndex = levelsIndex;
            }
            ++index;
            ++levelsIndex;
        }
        this.start = this.end = branchIndex;
        return levelsBranchIndex;
    }

    public boolean forwardIfMatch(@NotNull MqttTopicLevels levels) {
        if (!this.hasNext()) {
            return false;
        }
        int index = this.end + 1;
        int levelsIndex = levels.getEnd() + 1;
        byte[] levelsArray = levels.getArray();
        while (true) {
            boolean isLevelsEnd;
            boolean isEnd = index == this.allEnd;
            boolean bl = isLevelsEnd = levelsIndex == levelsArray.length;
            if (isLevelsEnd) {
                if (isEnd || this.array[index] == 47) {
                    this.start = this.end = index;
                    return true;
                }
                return false;
            }
            if (isEnd) {
                return false;
            }
            byte lb = levelsArray[levelsIndex];
            if (this.array[index] == lb) {
                ++index;
                ++levelsIndex;
                continue;
            }
            if (lb != 43) break;
            while (index < this.allEnd && this.array[index] != 47) {
                ++index;
            }
            ++levelsIndex;
        }
        return false;
    }
}

