/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.connect;

import com.hivemq.client.internal.mqtt.MqttClientTransportConfigImpl;
import com.hivemq.client.mqtt.mqtt5.message.connect.connack.Mqtt5ConnAck;
import io.reactivex.SingleObserver;
import io.reactivex.disposables.Disposable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MqttConnAckFlow {
    @Nullable
    private final SingleObserver<? super Mqtt5ConnAck> observer;
    @NotNull
    private final Disposable disposable;
    @NotNull
    private final MqttClientTransportConfigImpl transportConfig;
    private final int attempts;
    private boolean done;

    MqttConnAckFlow(@NotNull SingleObserver<? super Mqtt5ConnAck> observer, @NotNull MqttClientTransportConfigImpl transportConfig) {
        this.observer = observer;
        this.disposable = new MqttConnAckDisposable();
        this.transportConfig = transportConfig;
        this.attempts = 0;
    }

    MqttConnAckFlow(@Nullable MqttConnAckFlow oldFlow, @NotNull MqttClientTransportConfigImpl transportConfig) {
        if (oldFlow == null) {
            this.observer = null;
            this.disposable = new MqttConnAckDisposable();
            this.attempts = 0;
        } else {
            this.observer = oldFlow.observer;
            this.disposable = oldFlow.disposable;
            this.attempts = oldFlow.attempts + 1;
        }
        this.transportConfig = transportConfig;
    }

    boolean setDone() {
        if (this.done) {
            return false;
        }
        this.done = true;
        return true;
    }

    void onSuccess(@NotNull Mqtt5ConnAck t) {
        if (this.observer != null) {
            this.observer.onSuccess((Object)t);
        }
    }

    void onError(@NotNull Throwable t) {
        if (this.observer != null) {
            this.observer.onError(t);
        }
    }

    @NotNull
    Disposable getDisposable() {
        return this.disposable;
    }

    @NotNull
    public MqttClientTransportConfigImpl getTransportConfig() {
        return this.transportConfig;
    }

    int getAttempts() {
        return this.attempts;
    }

    private static class MqttConnAckDisposable
    implements Disposable {
        private volatile boolean disposed;

        private MqttConnAckDisposable() {
        }

        public void dispose() {
            this.disposed = true;
        }

        public boolean isDisposed() {
            return this.disposed;
        }
    }
}

