/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.publish.incoming;

import com.hivemq.client.internal.annotations.NotThreadSafe;
import com.hivemq.client.internal.mqtt.datatypes.MqttTopicFilterImpl;
import com.hivemq.client.internal.mqtt.handler.publish.incoming.MqttIncomingPublishFlows;
import com.hivemq.client.internal.mqtt.handler.publish.incoming.MqttMatchingPublishFlows;
import com.hivemq.client.internal.mqtt.handler.publish.incoming.MqttSubscribedPublishFlow;
import com.hivemq.client.internal.mqtt.handler.publish.incoming.MqttSubscriptionFlows;
import com.hivemq.client.internal.mqtt.ioc.ClientScope;
import com.hivemq.client.internal.mqtt.message.publish.MqttPublish;
import com.hivemq.client.internal.mqtt.message.publish.MqttStatefulPublish;
import com.hivemq.client.internal.mqtt.message.subscribe.MqttStatefulSubscribe;
import com.hivemq.client.internal.mqtt.message.subscribe.suback.MqttSubAck;
import com.hivemq.client.internal.util.collections.ImmutableIntList;
import java.util.HashMap;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ClientScope
@NotThreadSafe
public class MqttIncomingPublishFlowsWithId
extends MqttIncomingPublishFlows {
    @NotNull
    private final HashMap<Integer, MqttSubscribedPublishFlow> flowsWithIdsMap = new HashMap();
    @NotNull
    private final MqttSubscriptionFlows flowsWithIds;

    @Inject
    MqttIncomingPublishFlowsWithId(@NotNull MqttSubscriptionFlows flowsWithoutIds, @NotNull MqttSubscriptionFlows flowsWithIds) {
        super(flowsWithoutIds);
        this.flowsWithIds = flowsWithIds;
    }

    @Override
    public void subscribe(@NotNull MqttStatefulSubscribe subscribe, @Nullable MqttSubscribedPublishFlow flow) {
        int subscriptionIdentifier;
        if (flow != null && (subscriptionIdentifier = subscribe.getSubscriptionIdentifier()) != -1) {
            flow.setSubscriptionIdentifier(subscriptionIdentifier);
            this.flowsWithIdsMap.put(subscriptionIdentifier, flow);
        }
        super.subscribe(subscribe, flow);
    }

    @Override
    void subscribe(@NotNull MqttTopicFilterImpl topicFilter, @Nullable MqttSubscribedPublishFlow flow) {
        if (flow != null && flow.getSubscriptionIdentifier() != -1) {
            this.flowsWithIds.subscribe(topicFilter, flow);
        } else {
            super.subscribe(topicFilter, flow);
        }
    }

    @Override
    public void subAck(@NotNull MqttStatefulSubscribe subscribe, @NotNull MqttSubAck subAck, @Nullable MqttSubscribedPublishFlow flow) {
        int subscriptionIdentifier;
        super.subAck(subscribe, subAck, flow);
        if (flow != null && (subscriptionIdentifier = subscribe.getSubscriptionIdentifier()) != -1 && flow.getTopicFilters().isEmpty()) {
            this.flowsWithIdsMap.remove(subscriptionIdentifier);
        }
    }

    @Override
    void remove(@NotNull MqttTopicFilterImpl topicFilter, @Nullable MqttSubscribedPublishFlow flow) {
        if (flow != null && flow.getSubscriptionIdentifier() != -1) {
            this.flowsWithIds.remove(topicFilter, flow);
        } else {
            super.remove(topicFilter, flow);
        }
    }

    @Override
    void unsubscribe(@NotNull MqttTopicFilterImpl topicFilter) {
        this.flowsWithIds.unsubscribe(topicFilter, this::unsubscribed);
        super.unsubscribe(topicFilter);
    }

    private void unsubscribed(@NotNull MqttSubscribedPublishFlow flow) {
        this.flowsWithIdsMap.remove(flow.getSubscriptionIdentifier());
    }

    @Override
    void cancel(@NotNull MqttSubscribedPublishFlow flow) {
        int subscriptionIdentifier = flow.getSubscriptionIdentifier();
        if (subscriptionIdentifier != -1) {
            this.flowsWithIdsMap.remove(subscriptionIdentifier);
            this.flowsWithIds.cancel(flow);
        } else {
            super.cancel(flow);
        }
    }

    @Override
    void findMatching(@NotNull MqttStatefulPublish publish, @NotNull MqttMatchingPublishFlows matchingFlows) {
        ImmutableIntList subscriptionIdentifiers = publish.getSubscriptionIdentifiers();
        if (!subscriptionIdentifiers.isEmpty()) {
            for (int i = 0; i < subscriptionIdentifiers.size(); ++i) {
                MqttSubscribedPublishFlow flow = this.flowsWithIdsMap.get(subscriptionIdentifiers.get(i));
                if (flow == null) continue;
                matchingFlows.add(flow);
            }
            if (matchingFlows.isEmpty()) {
                this.flowsWithIds.findMatching(((MqttPublish)publish.stateless()).getTopic(), matchingFlows);
            } else {
                matchingFlows.subscriptionFound = true;
            }
        }
        super.findMatching(publish, matchingFlows);
    }

    @Override
    public void clear(@NotNull Throwable cause) {
        this.flowsWithIdsMap.clear();
        this.flowsWithIds.clear(cause);
        super.clear(cause);
    }
}

