/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.publish.incoming;

import com.hivemq.client.internal.annotations.NotThreadSafe;
import com.hivemq.client.internal.mqtt.datatypes.MqttTopicFilterImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttTopicImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttTopicIterator;
import com.hivemq.client.internal.mqtt.datatypes.MqttTopicLevel;
import com.hivemq.client.internal.mqtt.datatypes.MqttTopicLevels;
import com.hivemq.client.internal.mqtt.handler.publish.incoming.MqttIncomingPublishFlow;
import com.hivemq.client.internal.mqtt.handler.publish.incoming.MqttMatchingPublishFlows;
import com.hivemq.client.internal.mqtt.handler.publish.incoming.MqttSubscribedPublishFlow;
import com.hivemq.client.internal.mqtt.handler.publish.incoming.MqttSubscriptionFlows;
import com.hivemq.client.internal.util.collections.HandleList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NotThreadSafe
public class MqttSubscriptionFlowTree
implements MqttSubscriptionFlows {
    @Nullable
    private TopicTreeNode rootNode;

    @Inject
    MqttSubscriptionFlowTree() {
    }

    @Override
    public void subscribe(@NotNull MqttTopicFilterImpl topicFilter, @Nullable MqttSubscribedPublishFlow flow) {
        TopicTreeEntry entry = flow == null ? null : new TopicTreeEntry(flow, topicFilter);
        MqttTopicIterator topicIterator = MqttTopicIterator.of(topicFilter);
        TopicTreeNode node = this.rootNode;
        if (node == null) {
            this.rootNode = node = new TopicTreeNode(null, null);
        }
        while (node != null) {
            node = node.subscribe(topicIterator, entry);
        }
    }

    @Override
    public void remove(@NotNull MqttTopicFilterImpl topicFilter, @Nullable MqttSubscribedPublishFlow flow) {
        MqttTopicIterator topicIterator = MqttTopicIterator.of(topicFilter);
        for (TopicTreeNode node = this.rootNode; node != null; node = node.remove(topicIterator, flow)) {
        }
        this.compact();
    }

    @Override
    public void unsubscribe(@NotNull MqttTopicFilterImpl topicFilter, @Nullable Consumer<MqttSubscribedPublishFlow> unsubscribedCallback) {
        MqttTopicIterator topicIterator = MqttTopicIterator.of(topicFilter);
        for (TopicTreeNode node = this.rootNode; node != null; node = node.unsubscribe(topicIterator, unsubscribedCallback)) {
        }
        this.compact();
    }

    @Override
    public void cancel(@NotNull MqttSubscribedPublishFlow flow) {
        for (MqttTopicFilterImpl topicFilter : flow.getTopicFilters()) {
            MqttTopicIterator topicIterator = MqttTopicIterator.of(topicFilter);
            for (TopicTreeNode node = this.rootNode; node != null; node = node.cancel(topicIterator, flow)) {
            }
        }
    }

    @Override
    public void findMatching(@NotNull MqttTopicImpl topic, @NotNull MqttMatchingPublishFlows matchingFlows) {
        MqttTopicIterator topicIterator = MqttTopicIterator.of(topic);
        for (TopicTreeNode node = this.rootNode; node != null; node = node.findMatching(topicIterator, matchingFlows)) {
        }
    }

    @Override
    public void clear(@NotNull Throwable cause) {
        for (TopicTreeNode node = this.rootNode; node != null; node = node.clear(cause)) {
        }
        this.rootNode = null;
    }

    private void compact() {
        if (this.rootNode != null && this.rootNode.isEmpty()) {
            this.rootNode = null;
        }
    }

    private static class TopicTreeNode {
        @Nullable
        private TopicTreeNode parent;
        @Nullable
        private MqttTopicLevel topicLevel;
        @Nullable
        private HashMap<MqttTopicLevel, TopicTreeNode> next;
        @Nullable
        private TopicTreeNode singleLevel;
        @Nullable
        private HandleList<TopicTreeEntry> entries;
        @Nullable
        private HandleList<TopicTreeEntry> multiLevelEntries;
        private int subscriptions;
        private int multiLevelSubscriptions;

        TopicTreeNode(@Nullable TopicTreeNode parent, @Nullable MqttTopicLevel topicLevel) {
            this.parent = parent;
            this.topicLevel = topicLevel;
        }

        @Nullable
        TopicTreeNode subscribe(@NotNull MqttTopicIterator topicIterator, @Nullable TopicTreeEntry entry) {
            if (topicIterator.hasNext()) {
                TopicTreeNode node;
                MqttTopicLevel nextLevel = topicIterator.next();
                if (nextLevel.isSingleLevelWildcard()) {
                    if (this.singleLevel == null) {
                        this.singleLevel = new TopicTreeNode(this, nextLevel.trim());
                        return this.singleLevel;
                    }
                    return this.getNext(this.singleLevel, topicIterator);
                }
                if (this.next == null) {
                    this.next = new HashMap();
                    node = null;
                } else {
                    node = this.next.get(nextLevel);
                }
                if (node == null) {
                    node = new TopicTreeNode(this, nextLevel.trim());
                    this.next.put(node.topicLevel, node);
                    return node;
                }
                return this.getNext(node, topicIterator);
            }
            if (topicIterator.hasMultiLevelWildcard()) {
                if (entry != null) {
                    if (this.multiLevelEntries == null) {
                        this.multiLevelEntries = new HandleList();
                    }
                    this.multiLevelEntries.add(entry);
                }
                ++this.multiLevelSubscriptions;
            } else {
                if (entry != null) {
                    if (this.entries == null) {
                        this.entries = new HandleList();
                    }
                    this.entries.add(entry);
                }
                ++this.subscriptions;
            }
            return null;
        }

        @Nullable
        TopicTreeNode remove(@NotNull MqttTopicIterator topicIterator, @Nullable MqttSubscribedPublishFlow flow) {
            if (topicIterator.hasNext()) {
                return this.traverseNext(topicIterator);
            }
            if (topicIterator.hasMultiLevelWildcard()) {
                if (TopicTreeNode.remove(this.multiLevelEntries, flow)) {
                    this.multiLevelEntries = null;
                }
                --this.multiLevelSubscriptions;
            } else {
                if (TopicTreeNode.remove(this.entries, flow)) {
                    this.entries = null;
                }
                --this.subscriptions;
            }
            this.compact();
            return null;
        }

        private static boolean remove(@Nullable HandleList<TopicTreeEntry> entries, @Nullable MqttSubscribedPublishFlow flow) {
            if (entries != null && flow != null) {
                Iterator<TopicTreeEntry> iterator = entries.iterator();
                while (iterator.hasNext()) {
                    TopicTreeEntry entry = iterator.next();
                    if (entry.flow != flow) continue;
                    entry.handle.remove();
                    iterator.remove();
                    break;
                }
                return entries.isEmpty();
            }
            return false;
        }

        @Nullable
        TopicTreeNode unsubscribe(@NotNull MqttTopicIterator topicIterator, @Nullable Consumer<MqttSubscribedPublishFlow> unsubscribedCallback) {
            if (topicIterator.hasNext()) {
                return this.traverseNext(topicIterator);
            }
            if (topicIterator.hasMultiLevelWildcard()) {
                TopicTreeNode.unsubscribe(this.multiLevelEntries, unsubscribedCallback);
                this.multiLevelEntries = null;
                this.multiLevelSubscriptions = 0;
            } else {
                TopicTreeNode.unsubscribe(this.entries, unsubscribedCallback);
                this.entries = null;
                this.subscriptions = 0;
            }
            this.compact();
            return null;
        }

        private static void unsubscribe(@Nullable HandleList<TopicTreeEntry> entries, @Nullable Consumer<MqttSubscribedPublishFlow> unsubscribedCallback) {
            if (entries != null) {
                for (TopicTreeEntry entry : entries) {
                    entry.handle.remove();
                    MqttSubscribedPublishFlow flow = entry.flow;
                    if (!flow.getTopicFilters().isEmpty()) continue;
                    flow.onComplete();
                    if (unsubscribedCallback == null) continue;
                    unsubscribedCallback.accept(flow);
                }
            }
        }

        @Nullable
        TopicTreeNode cancel(@NotNull MqttTopicIterator topicIterator, @NotNull MqttSubscribedPublishFlow flow) {
            if (topicIterator.hasNext()) {
                return this.traverseNext(topicIterator);
            }
            if (topicIterator.hasMultiLevelWildcard()) {
                if (TopicTreeNode.cancel(this.multiLevelEntries, flow)) {
                    this.multiLevelEntries = null;
                }
            } else if (TopicTreeNode.cancel(this.entries, flow)) {
                this.entries = null;
            }
            return null;
        }

        private static boolean cancel(@Nullable HandleList<TopicTreeEntry> entries, @NotNull MqttSubscribedPublishFlow flow) {
            if (entries != null) {
                Iterator<TopicTreeEntry> iterator = entries.iterator();
                while (iterator.hasNext()) {
                    TopicTreeEntry entry = iterator.next();
                    if (entry.flow != flow) continue;
                    iterator.remove();
                    break;
                }
                return entries.isEmpty();
            }
            return false;
        }

        @Nullable
        TopicTreeNode findMatching(@NotNull MqttTopicIterator topicIterator, @NotNull MqttMatchingPublishFlows matchingFlows) {
            if (topicIterator.hasNext()) {
                TopicTreeNode.add(matchingFlows, this.multiLevelEntries);
                if (this.multiLevelSubscriptions != 0) {
                    matchingFlows.subscriptionFound = true;
                }
                MqttTopicLevel nextLevel = topicIterator.next();
                TopicTreeNode nextNode = this.next == null ? null : this.next.get(nextLevel);
                TopicTreeNode singleLevel = this.singleLevel;
                if (nextNode == null) {
                    return TopicTreeNode.findNext(singleLevel, topicIterator);
                }
                if (singleLevel == null) {
                    return TopicTreeNode.findNext(nextNode, topicIterator);
                }
                MqttTopicIterator fork = topicIterator.fork();
                TopicTreeNode nextNodeNext = TopicTreeNode.findNext(nextNode, topicIterator);
                if (nextNodeNext == null) {
                    return TopicTreeNode.findNext(singleLevel, topicIterator);
                }
                TopicTreeNode singleLevelNext = TopicTreeNode.findNext(singleLevel, fork);
                if (singleLevelNext == null) {
                    return nextNodeNext;
                }
                for (TopicTreeNode node = singleLevelNext; node != null; node = node.findMatching(fork, matchingFlows)) {
                }
                return nextNodeNext;
            }
            TopicTreeNode.add(matchingFlows, this.entries);
            TopicTreeNode.add(matchingFlows, this.multiLevelEntries);
            if (this.subscriptions != 0 || this.multiLevelSubscriptions != 0) {
                matchingFlows.subscriptionFound = true;
            }
            return null;
        }

        private static void add(@NotNull HandleList<MqttIncomingPublishFlow> target, @Nullable HandleList<TopicTreeEntry> source) {
            if (source != null) {
                for (TopicTreeEntry entry : source) {
                    target.add(entry.flow);
                }
            }
        }

        @Nullable
        TopicTreeNode clear(@NotNull Throwable cause) {
            if (this.next != null) {
                return this.next.values().iterator().next();
            }
            if (this.singleLevel != null) {
                return this.singleLevel;
            }
            if (this.entries != null) {
                for (TopicTreeEntry entry : this.entries) {
                    entry.flow.onError(cause);
                }
                this.entries = null;
            }
            if (this.multiLevelEntries != null) {
                for (TopicTreeEntry multiLevelEntry : this.multiLevelEntries) {
                    multiLevelEntry.flow.onError(cause);
                }
                this.multiLevelEntries = null;
            }
            if (this.parent != null) {
                this.parent.removeNext(this);
            }
            return this.parent;
        }

        @NotNull
        private TopicTreeNode getNext(@NotNull TopicTreeNode node, @NotNull MqttTopicIterator topicIterator) {
            int branchIndex;
            MqttTopicLevels topicLevels;
            MqttTopicLevel topicLevelBefore;
            MqttTopicLevel topicLevel = node.topicLevel;
            if (topicLevel instanceof MqttTopicLevels && (topicLevelBefore = (topicLevels = (MqttTopicLevels)topicLevel).before(branchIndex = topicIterator.forwardWhileEqual(topicLevels))) != topicLevels) {
                TopicTreeNode nodeBefore;
                MqttTopicLevel topicLevelAfter = topicLevels.after(branchIndex);
                node.parent = nodeBefore = new TopicTreeNode(this, topicLevelBefore);
                node.topicLevel = topicLevelAfter;
                if (topicLevelBefore.isSingleLevelWildcard()) {
                    this.singleLevel = nodeBefore;
                } else {
                    assert (this.next != null);
                    this.next.remove(topicLevels);
                    this.next.put(topicLevelBefore, nodeBefore);
                }
                if (topicLevelAfter.isSingleLevelWildcard()) {
                    nodeBefore.singleLevel = node;
                } else {
                    nodeBefore.next = new HashMap();
                    nodeBefore.next.put(topicLevelAfter, node);
                }
                return nodeBefore;
            }
            return node;
        }

        @Nullable
        private TopicTreeNode traverseNext(@NotNull MqttTopicIterator topicIterator) {
            MqttTopicLevel nextLevel = topicIterator.next();
            if (nextLevel.isSingleLevelWildcard()) {
                return TopicTreeNode.traverseNext(this.singleLevel, topicIterator);
            }
            if (this.next != null) {
                return TopicTreeNode.traverseNext(this.next.get(nextLevel), topicIterator);
            }
            return null;
        }

        @Nullable
        private static TopicTreeNode traverseNext(@Nullable TopicTreeNode node, @NotNull MqttTopicIterator topicIterator) {
            if (node == null) {
                return null;
            }
            MqttTopicLevel topicLevel = node.topicLevel;
            if (topicLevel instanceof MqttTopicLevels) {
                if (topicIterator.forwardIfEqual((MqttTopicLevels)topicLevel)) {
                    return node;
                }
                return null;
            }
            return node;
        }

        @Nullable
        private static TopicTreeNode findNext(@Nullable TopicTreeNode node, @NotNull MqttTopicIterator topicIterator) {
            if (node == null) {
                return null;
            }
            MqttTopicLevel topicLevel = node.topicLevel;
            if (topicLevel instanceof MqttTopicLevels) {
                if (topicIterator.forwardIfMatch((MqttTopicLevels)topicLevel)) {
                    return node;
                }
                return null;
            }
            return node;
        }

        private void compact() {
            if (this.parent != null && this.subscriptions + this.multiLevelSubscriptions == 0) {
                boolean hasNext;
                boolean hasSingleLevel = this.singleLevel != null;
                boolean bl = hasNext = this.next != null;
                if (!hasSingleLevel && !hasNext) {
                    this.parent.removeNext(this);
                    this.parent.compact();
                } else if (hasSingleLevel && !hasNext) {
                    this.fuse(this.singleLevel);
                } else if (!hasSingleLevel && this.next.size() == 1) {
                    this.fuse(this.next.values().iterator().next());
                }
            }
        }

        private void fuse(@NotNull TopicTreeNode child) {
            assert (this.parent != null);
            assert (this.topicLevel != null);
            assert (child.parent == this);
            assert (child.topicLevel != null);
            TopicTreeNode parent = this.parent;
            MqttTopicLevels fusedTopicLevel = MqttTopicLevels.concat(this.topicLevel, child.topicLevel);
            child.parent = parent;
            child.topicLevel = fusedTopicLevel;
            if (fusedTopicLevel.isSingleLevelWildcard()) {
                parent.singleLevel = child;
            } else {
                assert (parent.next != null);
                parent.next.remove(this.topicLevel);
                parent.next.put(fusedTopicLevel, child);
            }
        }

        private void removeNext(@NotNull TopicTreeNode node) {
            assert (node.topicLevel != null);
            if (node.topicLevel.isSingleLevelWildcard()) {
                this.singleLevel = null;
            } else {
                assert (this.next != null);
                this.next.remove(node.topicLevel);
                if (this.next.isEmpty()) {
                    this.next = null;
                }
            }
        }

        boolean isEmpty() {
            return this.subscriptions + this.multiLevelSubscriptions == 0 && this.singleLevel == null && this.next == null;
        }
    }

    private static class TopicTreeEntry {
        @NotNull
        final MqttSubscribedPublishFlow flow;
        @NotNull
        final HandleList.Handle<MqttTopicFilterImpl> handle;

        TopicTreeEntry(@NotNull MqttSubscribedPublishFlow flow, @NotNull MqttTopicFilterImpl topicFilter) {
            this.flow = flow;
            this.handle = flow.getTopicFilters().add(topicFilter);
        }
    }
}

