/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.rx;

import com.hivemq.client.rx.FlowableWithSingleSubscriber;
import com.hivemq.client.rx.reactivestreams.WithSingleSubscriber;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Subscription;

public class WithSingleStrictSubscriber<F, S>
implements FlowableWithSingleSubscriber<F, S>,
Subscription {
    @NotNull
    private final WithSingleSubscriber<F, S> subscriber;
    private final @NotNull AtomicReference<@Nullable Subscription> subscription = new AtomicReference();
    @NotNull
    private final AtomicLong requested = new AtomicLong();

    public WithSingleStrictSubscriber(@NotNull WithSingleSubscriber<F, S> subscriber) {
        this.subscriber = subscriber;
    }

    public void onSubscribe(@NotNull Subscription subscription) {
        this.subscriber.onSubscribe(subscription);
        if (this.subscription.compareAndSet(null, subscription)) {
            long requested = this.requested.getAndSet(0L);
            if (requested != 0L) {
                subscription.request(requested);
            }
        } else {
            subscription.cancel();
        }
    }

    @Override
    public void onSingle(@NotNull S s) {
        this.subscriber.onSingle(s);
    }

    public void onNext(@NotNull F f) {
        this.subscriber.onNext(f);
    }

    public void onError(@NotNull Throwable throwable) {
        this.subscriber.onError(throwable);
    }

    public void onComplete() {
        this.subscriber.onComplete();
    }

    public void request(long n) {
        Subscription subscription = this.subscription.get();
        if (subscription != null) {
            subscription.request(n);
        } else {
            long requested;
            BackpressureHelper.add((AtomicLong)this.requested, (long)n);
            subscription = this.subscription.get();
            if (subscription != null && (requested = this.requested.getAndSet(0L)) != 0L) {
                subscription.request(requested);
            }
        }
    }

    public void cancel() {
        Subscription subscription = this.subscription.getAndSet((Subscription)SubscriptionHelper.CANCELLED);
        if (subscription != null && subscription != SubscriptionHelper.CANCELLED) {
            subscription.cancel();
        }
    }
}

