/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.concurrency;

import com.google.common.util.concurrent.ForwardingExecutorService;
import com.hubspot.slack.client.concurrency.FollowThreadsMixin;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class FollowThreadLocalsExecutorService
extends ForwardingExecutorService
implements FollowThreadsMixin {
    private final ExecutorService delegate;
    private final String namePrefix;

    public FollowThreadLocalsExecutorService(ExecutorService delegate, String namePrefix) {
        this.delegate = delegate;
        this.namePrefix = namePrefix;
    }

    @Override
    public String getNamePrefix() {
        return this.namePrefix;
    }

    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.delegate().invokeAll(this.transformRequests(tasks));
    }

    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate().invokeAll(this.transformRequests(tasks), timeout, unit);
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.delegate().invokeAny(this.transformRequests(tasks));
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate().invokeAny(this.transformRequests(tasks), timeout, unit);
    }

    public void execute(Runnable command) {
        this.delegate().execute(this.transformRequest(command));
    }

    public <T> Future<T> submit(Callable<T> task) {
        return this.delegate().submit(this.transformRequest(task));
    }

    public Future<?> submit(Runnable task) {
        return this.delegate().submit(this.transformRequest(task));
    }

    public <T> Future<T> submit(Runnable task, T result) {
        return this.delegate().submit(this.transformRequest(task), result);
    }

    protected ExecutorService delegate() {
        return this.delegate;
    }
}

