/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.concurrency;

import com.google.common.base.Throwables;
import com.google.common.collect.Collections2;
import com.hubspot.slack.client.concurrency.ThreadContextHook;
import java.util.Collection;
import java.util.concurrent.Callable;

public interface FollowThreadsMixin {
    public String getNamePrefix();

    default public <T> Collection<? extends Callable<T>> transformRequests(Collection<? extends Callable<T>> tasks) {
        return Collections2.transform(tasks, this::transformRequest);
    }

    default public <T> Callable<T> transformRequest(Callable<T> callable) {
        String namePrefix = this.getNamePrefix();
        ThreadContextHook.Context currentContext = ThreadContextHook.INSTANCE.buildThreadContext(namePrefix);
        return () -> {
            ThreadContextHook.Context initializedContext = null;
            try {
                initializedContext = ThreadContextHook.INSTANCE.initializeThreadContext(namePrefix, currentContext);
                Object v = callable.call();
                return v;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                ThreadContextHook.INSTANCE.clearThreadContext(namePrefix, initializedContext);
            }
        };
    }

    default public Runnable transformRequest(Runnable runnable) {
        Callable<Void> callableVersion = () -> {
            runnable.run();
            return null;
        };
        Callable<Void> voidCallable = this.transformRequest(callableVersion);
        return () -> {
            try {
                voidCallable.call();
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        };
    }
}

