/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.concurrency;

import com.google.common.collect.ImmutableList;
import com.hubspot.slack.client.concurrency.ThreadContextFollower;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.ServiceLoader;

public enum ThreadContextHook {
    INSTANCE;

    private final Collection<ThreadContextFollower> followers;

    private ThreadContextHook() {
        ServiceLoader<ThreadContextFollower> loader = ServiceLoader.load(ThreadContextFollower.class);
        this.followers = ImmutableList.copyOf(loader);
    }

    public Context buildThreadContext(String namePrefix) {
        IdentityHashMap retainedObjects = new IdentityHashMap();
        for (ThreadContextFollower follower : this.followers) {
            retainedObjects.put(follower, follower.getContext(namePrefix));
        }
        return new Context(Collections.unmodifiableMap(retainedObjects));
    }

    public Context initializeThreadContext(String namePrefix, Context context) {
        IdentityHashMap initializingObjects = new IdentityHashMap();
        for (ThreadContextFollower follower : this.followers) {
            Object followerContext = context.followersContext.get(follower);
            if (followerContext == null) continue;
            initializingObjects.put(follower, follower.setContext(namePrefix, followerContext));
        }
        return new Context(Collections.unmodifiableMap(initializingObjects));
    }

    public void clearThreadContext(String namePrefix, Context context) {
        for (ThreadContextFollower follower : this.followers) {
            follower.clearContext(namePrefix, context.followersContext.get(follower));
        }
    }

    public Context buildThreadContext() {
        return this.buildThreadContext(null);
    }

    public void clearThreadContext(Context context) {
        this.clearThreadContext(null, context);
    }

    public Context initializeThreadContext(Context context) {
        return this.initializeThreadContext(null, context);
    }

    public static class Context {
        private final Map<ThreadContextFollower, Object> followersContext;

        private Context(Map<ThreadContextFollower, Object> followersContext) {
            this.followersContext = followersContext;
        }
    }
}

