/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.http.ning;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import com.hubspot.horizon.Compression;
import com.hubspot.horizon.HttpRequest;
import com.hubspot.slack.client.http.ning.TerminatingMultipartRequestEntity;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.multipart.ByteArrayPart;
import com.ning.http.client.multipart.FilePart;
import com.ning.http.client.multipart.Part;
import com.ning.http.client.multipart.StringPart;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MultipartHttpRequest {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private final List<Part> parts = new ArrayList<Part>();
        private final HttpRequest.Builder builder = HttpRequest.newBuilder();

        private Builder() {
        }

        public Builder addStringPart(@Nonnull String name, @Nonnull String value) {
            return this.addStringPart(name, value, DEFAULT_CHARSET);
        }

        public Builder addStringPart(@Nonnull String name, @Nonnull String value, @Nonnull Charset charset) {
            return this.addStringPart(name, value, charset, null);
        }

        public Builder addStringPart(@Nonnull String name, @Nonnull String value, @Nonnull Charset charset, @Nullable String contentType) {
            this.parts.add((Part)new StringPart((String)Preconditions.checkNotNull((Object)name), (String)Preconditions.checkNotNull((Object)value), contentType, (Charset)Preconditions.checkNotNull((Object)charset)));
            return this;
        }

        public Builder addByteArrayPart(@Nonnull String name, @Nonnull byte[] value) {
            return this.addByteArrayPart(name, name, value);
        }

        public Builder addByteArrayPart(@Nonnull String name, @Nonnull String fileName, @Nonnull byte[] value) {
            return this.addByteArrayPart(name, fileName, value, DEFAULT_CHARSET);
        }

        public Builder addByteArrayPart(@Nonnull String name, @Nonnull String fileName, @Nonnull byte[] value, Charset charset) {
            ByteArrayPart part = new ByteArrayPart((String)Preconditions.checkNotNull((Object)name), (byte[])Preconditions.checkNotNull((Object)value), null, charset);
            part.setFileName(fileName);
            this.parts.add((Part)part);
            return this;
        }

        public Builder addFilePart(@Nonnull String name, @Nonnull File value) {
            return this.addFilePart(name, value.getName(), value);
        }

        public Builder addFilePart(@Nonnull String name, @Nonnull String fileName, @Nonnull File value) {
            FilePart part = new FilePart((String)Preconditions.checkNotNull((Object)name), (File)Preconditions.checkNotNull((Object)value));
            part.setFileName(fileName);
            this.parts.add((Part)part);
            return this;
        }

        public Builder addHeader(String name, String value) {
            this.builder.addHeader(name, value);
            return this;
        }

        public Builder addQueryParam(@Nonnull String name, @Nullable String value) {
            this.builder.setQueryParam(name).to(new String[]{value});
            return this;
        }

        public Builder addQueryParam(@Nonnull String name, int value) {
            this.builder.setQueryParam(name).to(new int[]{value});
            return this;
        }

        public Builder addQueryParam(@Nonnull String name, long value) {
            this.builder.setQueryParam(name).to(new long[]{value});
            return this;
        }

        public Builder addQueryParam(@Nonnull String name, @Nonnull Iterable<String> values) {
            this.builder.setQueryParam(name).to(values);
            return this;
        }

        public Builder addQueryParams(@Nonnull Multimap<String, String> mm) {
            mm.keySet().forEach(k -> this.builder.setQueryParam(k).to((Iterable)mm.get(k)));
            return this;
        }

        public Builder setCompression(@Nonnull Compression compression) {
            this.builder.setCompression(compression);
            return this;
        }

        public Builder setUrl(@Nonnull String url) {
            this.builder.setUrl(url);
            return this;
        }

        public Builder setMethod(@Nonnull HttpRequest.Method method) {
            this.builder.setMethod(method);
            return this;
        }

        public Builder setAccept(@Nonnull HttpRequest.ContentType accept) {
            this.builder.setAccept(accept);
            return this;
        }

        public Builder addBasicAuthentication(@Nonnull String userName, @Nullable String password) {
            this.builder.addBasicAuth(userName, password);
            return this;
        }

        public HttpRequest build() {
            byte[] body;
            TerminatingMultipartRequestEntity requestEntity = new TerminatingMultipartRequestEntity(this.parts, new FluentCaseInsensitiveStringsMap());
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                requestEntity.writeRequest(baos);
                baos.flush();
                body = baos.toByteArray();
            }
            catch (IOException e) {
                throw new RuntimeException("Error generating body bytes", e);
            }
            this.builder.addHeader("Content-Type", requestEntity.getContentType());
            this.builder.setBody(body);
            return this.builder.build();
        }
    }
}

