/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.paging;

import com.google.common.base.Throwables;
import com.google.common.collect.AbstractIterator;
import com.hubspot.slack.client.paging.LazyLoadingPage;
import java.util.concurrent.CompletableFuture;

public abstract class AbstractPagedIterator<T, K>
extends AbstractIterator<CompletableFuture<T>> {
    private LazyLoadingPage<T, K> page = null;

    protected final CompletableFuture<T> computeNext() {
        try {
            if (this.page == null) {
                this.page = this.getPage(this.getInitialOffset());
                if (this.page == null) {
                    return (CompletableFuture)this.endOfData();
                }
                return this.page.getResults();
            }
            if (this.page.hasMore().join().booleanValue()) {
                this.page = this.getPage(this.page.getOffset().join());
                return this.page.getResults();
            }
            return (CompletableFuture)this.endOfData();
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected abstract K getInitialOffset();

    protected abstract LazyLoadingPage<T, K> getPage(K var1) throws Exception;
}

