/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.ratelimiting;

import com.google.common.util.concurrent.RateLimiter;
import com.hubspot.slack.client.methods.SlackMethod;
import com.hubspot.slack.client.ratelimiting.SlackRateLimiter;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ByMethodRateLimiter
implements SlackRateLimiter {
    private static final ConcurrentMap<SlackMethod, RateLimiter> RATE_LIMITERS = new ConcurrentHashMap<SlackMethod, RateLimiter>();

    @Override
    public double acquire(String slackToken, SlackMethod slackMethod) {
        double permissibleQueriesPerSecond = (double)slackMethod.getRateLimitingTier().getMinutelyAllowance() / 60.0;
        return RATE_LIMITERS.computeIfAbsent(slackMethod, ignored -> RateLimiter.create((double)permissibleQueriesPerSecond)).acquire();
    }
}

