/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.mapper;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.beetl.sql.core.SQLIdNameConversion;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.kit.BeanKit;
import org.beetl.sql.core.mapper.MapperBuilder;
import org.beetl.sql.core.mapper.MapperJava8Proxy;
import org.beetl.sql.core.mapper.MapperJavaProxy;

public class DefaultMapperBuilder
implements MapperBuilder {
    protected Map<Class<?>, Object> cache = new ConcurrentHashMap();
    protected SQLManager sqlManager;
    protected ClassLoader entityClassLoader;

    public DefaultMapperBuilder(SQLManager sqlManager) {
        this.sqlManager = sqlManager;
        this.entityClassLoader = sqlManager.getEntityLoader();
    }

    @Deprecated
    public DefaultMapperBuilder(SQLManager sqlManager, ClassLoader classLoader) {
        this(sqlManager);
        this.entityClassLoader = classLoader;
    }

    @Override
    public <T> T getMapper(Class<T> mapperInterface) {
        if (this.cache.containsKey(mapperInterface)) {
            return (T)this.cache.get(mapperInterface);
        }
        T instance = this.buildInstance(mapperInterface);
        this.cache.put(mapperInterface, instance);
        return instance;
    }

    public <T> T buildInstance(Class<T> mapperInterface) {
        ClassLoader loader;
        ClassLoader classLoader = loader = null == this.entityClassLoader ? Thread.currentThread().getContextClassLoader() : this.entityClassLoader;
        if (BeanKit.queryLambdasSupport) {
            return (T)Proxy.newProxyInstance(loader == null ? this.getClass().getClassLoader() : loader, new Class[]{mapperInterface}, (InvocationHandler)new MapperJava8Proxy(this, this.sqlManager, mapperInterface));
        }
        return (T)Proxy.newProxyInstance(loader == null ? this.getClass().getClassLoader() : loader, new Class[]{mapperInterface}, (InvocationHandler)new MapperJavaProxy(this, this.sqlManager, mapperInterface));
    }

    public SQLIdNameConversion getIdGen() {
        return this.sqlManager.getSQLIdNameConversion();
    }
}

