/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.ext.gen;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.beetl.core.Configuration;
import org.beetl.core.GroupTemplate;
import org.beetl.core.ResourceLoader;
import org.beetl.core.Template;
import org.beetl.core.resource.StringTemplateResourceLoader;
import org.beetl.sql.core.JavaType;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.db.ColDesc;
import org.beetl.sql.core.db.MetadataManager;
import org.beetl.sql.core.db.TableDesc;
import org.beetl.sql.core.kit.StringKit;
import org.beetl.sql.ext.gen.CodeGen;
import org.beetl.sql.ext.gen.GenConfig;

public class SourceGen {
    public static String defaultPkg = "com.test";
    private MetadataManager mm;
    private SQLManager sm;
    private String table;
    private String pkg;
    private String srcPath;
    private GenConfig config;
    private static String srcHead;
    public static final String CR;
    private static GroupTemplate gt;

    public static String getSrcHead() {
        return srcHead;
    }

    public static GroupTemplate getGt() {
        return gt;
    }

    public SourceGen(SQLManager sm, String table, String pkg, String srcPath, GenConfig config) {
        this.mm = sm.getMetaDataManager();
        this.sm = sm;
        this.table = table;
        this.pkg = pkg;
        this.srcPath = srcPath;
        this.config = config;
    }

    public void gen() throws Exception {
        final TableDesc tableDesc = this.mm.getTable(this.table);
        String className = this.sm.getNc().getClassName(tableDesc.getName());
        if (this.config.getIgnorePrefix() != null && !this.config.getIgnorePrefix().trim().equals("")) {
            className = className.replaceFirst(StringKit.toUpperCaseFirstOne(this.config.getIgnorePrefix()), "");
        }
        String ext = null;
        if (this.config.getBaseClass() != null) {
            ext = this.config.getBaseClass();
        }
        Set<String> cols = tableDesc.getCols();
        ArrayList attrs = new ArrayList();
        for (String col : cols) {
            ColDesc desc = tableDesc.getColDesc(col);
            HashMap<String, Object> attr = new HashMap<String, Object>();
            attr.put("colName", desc.colName);
            attr.put("comment", desc.remark);
            String attrName = this.sm.getNc().getPropertyName(null, desc.colName);
            attr.put("name", attrName);
            attr.put("methodName", this.getMethodName(attrName));
            boolean isKey = tableDesc.getIdNames().contains(desc.colName);
            attr.put("isKey", isKey);
            String type = JavaType.getType(desc.sqlType, desc.size, desc.digit);
            if (this.config.isPreferBigDecimal() && type.equals("Double")) {
                type = "BigDecimal";
            }
            if (this.config.isPreferDate() && type.equals("Timestamp")) {
                type = "Date";
            }
            attr.put("type", type);
            attr.put("desc", desc);
            attrs.add(attr);
        }
        if (this.config.getPropertyOrder() == 1) {
            Collections.sort(attrs, new Comparator<Map>(){

                @Override
                public int compare(Map o1, Map o2) {
                    int score2;
                    ColDesc desc1 = (ColDesc)o1.get("desc");
                    ColDesc desc2 = (ColDesc)o2.get("desc");
                    int score1 = this.score(desc1);
                    if (score1 == (score2 = this.score(desc2))) {
                        return desc1.colName.compareTo(desc2.colName);
                    }
                    return score2 - score1;
                }

                private int score(ColDesc desc) {
                    if (tableDesc.getIdNames().contains(desc.colName)) {
                        return 99;
                    }
                    if (JavaType.isInteger(desc.sqlType)) {
                        return 9;
                    }
                    if (JavaType.isDateType(desc.sqlType)) {
                        return -9;
                    }
                    return 0;
                }
            });
        }
        Template template = gt.getTemplate(this.config.getTemplate());
        template.binding("attrs", attrs);
        template.binding("className", (Object)className);
        template.binding("table", (Object)this.trimCategory(this.table));
        template.binding("ext", (Object)ext);
        template.binding("package", (Object)this.pkg);
        template.binding("imports", (Object)srcHead);
        template.binding("comment", (Object)tableDesc.getRemark());
        template.binding("catalog", (Object)tableDesc.getCatalog());
        template.binding("implSerializable", (Object)this.config.isImplSerializable());
        String code = template.render();
        if (this.config.isDisplay()) {
            System.out.println(code);
        } else {
            SourceGen.saveSourceFile(this.srcPath, this.pkg, className, code);
        }
        for (CodeGen codeGen : this.config.codeGens) {
            codeGen.genCode(this.pkg, className, tableDesc, this.config, this.config.isDisplay());
        }
    }

    private String trimCategory(String table) {
        int index = -1;
        index = table.indexOf(".");
        if (index == -1) {
            return table;
        }
        return table.substring(index + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveSourceFile(String srcPath, String pkg, String className, String content) throws IOException {
        boolean succ;
        String file = srcPath + File.separator + pkg.replace('.', File.separatorChar);
        File f = new File(file);
        if (!f.exists() && !(succ = f.mkdirs())) {
            throw new IOException("\u521b\u5efa\u6587\u4ef6\u5939\u5931\u8d25 " + f);
        }
        File target = new File(file, className + ".java");
        try (FileWriter writer = new FileWriter(target);){
            writer.write(content);
        }
    }

    private String getMethodName(String name) {
        if (name.length() == 1) {
            return name.toUpperCase();
        }
        char ch1 = name.charAt(0);
        char ch2 = name.charAt(1);
        if (Character.isLowerCase(ch1) && Character.isUpperCase(ch2)) {
            return name;
        }
        if (Character.isUpperCase(ch1) && Character.isUpperCase(ch2)) {
            return name;
        }
        char upper = Character.toUpperCase(ch1);
        return upper + name.substring(1);
    }

    static {
        CR = System.getProperty("line.separator");
        gt = null;
        Configuration conf = null;
        try {
            conf = Configuration.defaultConfiguration();
            conf.setStatementStart("<%");
            conf.setStatementEnd("%>");
        }
        catch (IOException e) {
            throw new RuntimeException("build defaultConfiguration error", e);
        }
        gt = new GroupTemplate((ResourceLoader)new StringTemplateResourceLoader(), conf);
        StringBuffer t = new StringBuffer();
        t.append("import java.math.*;");
        t.append(CR);
        t.append("import java.util.Date;");
        t.append(CR);
        t.append("import java.sql.Timestamp;");
        t.append(CR);
        t.append("import org.beetl.sql.core.annotatoin.Table;");
        t.append(CR);
        srcHead = t.toString();
    }
}

