/*
 * Decompiled with CFR 0.152.
 */
package org.bson.json;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bson.BsonBinarySubType;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.Document;
import org.bson.Transformer;
import org.bson.assertions.Assertions;
import org.bson.codecs.BsonTypeClassMap;
import org.bson.codecs.BsonTypeCodecMap;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.DocumentCodec;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.json.IfxJsonReader;

public class IfxDocumentCodec
extends DocumentCodec {
    private final Transformer valueTransformer;
    private final CodecRegistry registry;
    private final BsonTypeCodecMap bsonTypeCodecMap;

    public IfxDocumentCodec(CodecRegistry registry) {
        this(registry, new BsonTypeClassMap());
    }

    public IfxDocumentCodec(CodecRegistry registry, BsonTypeClassMap bsonTypeClassMap) {
        this(registry, bsonTypeClassMap, null);
    }

    public IfxDocumentCodec(CodecRegistry registry, BsonTypeClassMap bsonTypeClassMap, Transformer valueTransformer) {
        super(registry, bsonTypeClassMap, valueTransformer);
        this.registry = registry;
        this.bsonTypeCodecMap = new BsonTypeCodecMap(Assertions.notNull("bsonTypeClassMap", bsonTypeClassMap), registry);
        this.valueTransformer = valueTransformer != null ? valueTransformer : new Transformer(){

            @Override
            public Object transform(Object value) {
                return value;
            }
        };
    }

    @Override
    public Document decode(BsonReader reader, DecoderContext decoderContext) {
        Document document = new Document();
        reader.readStartDocument();
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            String fieldName = reader.readName();
            document.put(fieldName, this.readIfxValue(reader, decoderContext));
        }
        reader.readEndDocument();
        return document;
    }

    private Object readIfxValue(BsonReader reader, DecoderContext decoderContext) {
        BsonType bsonType = reader.getCurrentBsonType();
        if (bsonType == BsonType.UNDEFINED && reader instanceof IfxJsonReader) {
            reader.readUndefined();
            return ((IfxJsonReader)reader).doGetValue();
        }
        if (bsonType == BsonType.NULL) {
            reader.readNull();
            return null;
        }
        if (bsonType == BsonType.ARRAY) {
            return this.ifxReadList(reader, decoderContext);
        }
        if (bsonType == BsonType.BINARY && BsonBinarySubType.isUuid(reader.peekBinarySubType()) && reader.peekBinarySize() == 16) {
            return this.registry.get(UUID.class).decode(reader, decoderContext);
        }
        return this.valueTransformer.transform(this.bsonTypeCodecMap.get(bsonType).decode(reader, decoderContext));
    }

    private List<Object> ifxReadList(BsonReader reader, DecoderContext decoderContext) {
        reader.readStartArray();
        ArrayList<Object> list = new ArrayList<Object>();
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            list.add(this.readIfxValue(reader, decoderContext));
        }
        reader.readEndArray();
        return list;
    }
}

