/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jns;

import com.informix.jns.FileSqlhosts;
import com.informix.jns.IfxJNSException;
import com.informix.jns.LdapSqlhosts;
import com.informix.jns.ServerGroup;
import com.informix.jns.ServerInfo;
import java.util.Properties;

public class Sqlhosts {
    static final int LDAP_SQLH = 0;
    static final int FILE_SQLH = 1;
    static final String SQH_DEFAULT = "LDAP";
    private LdapSqlhosts ldapSqlh;
    private FileSqlhosts fileSqlh;
    private int sqlhType;

    public Sqlhosts(Properties sqhenv) throws IfxJNSException {
        String stype = SQH_DEFAULT;
        stype = sqhenv.getProperty("SQLH_TYPE");
        if (stype == null) {
            stype = SQH_DEFAULT;
        }
        if (stype.equalsIgnoreCase(SQH_DEFAULT)) {
            this.sqlhType = 0;
            this.ldapSqlh = new LdapSqlhosts(sqhenv);
        }
        if (stype.equalsIgnoreCase("FILE")) {
            this.sqlhType = 1;
            this.fileSqlh = new FileSqlhosts(sqhenv);
        }
    }

    public ServerInfo getServer(String sname) throws IfxJNSException {
        if (this.sqlhType == 1) {
            return this.fileSqlh.getServer(sname);
        }
        return this.ldapSqlh.getServer(sname);
    }

    public ServerGroup getServerGroup(String sname) throws IfxJNSException {
        if (this.sqlhType == 1) {
            return this.fileSqlh.getServerGroup(sname);
        }
        return this.ldapSqlh.getServerGroup(sname);
    }

    public ServerGroup listServers() throws IfxJNSException {
        if (this.sqlhType == 1) {
            return this.fileSqlh.listServers();
        }
        return this.ldapSqlh.listServers();
    }
}

