/*
 * Decompiled with CFR 0.152.
 */
package com.informix.bson;

import com.informix.bson.DBRefBase;
import java.util.List;
import org.bson.BSON;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;
import org.bson.Transformer;

public class DBRef
extends DBRefBase {
    static final boolean D = Boolean.getBoolean("DEBUG.DBREF");

    public DBRef(BSONObject o) {
        super(o.get("$ref").toString(), o.get("$id"));
    }

    public DBRef(String ns, Object id) {
        super(ns, id);
    }

    static {
        List transformers = BSON.getEncodingHooks(DBRef.class);
        if (transformers == null || transformers.isEmpty()) {
            BSON.addEncodingHook(DBRef.class, (Transformer)new DBRefTransformer());
        }
    }

    static class DBRefTransformer
    implements Transformer {
        DBRefTransformer() {
        }

        public Object transform(Object val) {
            BasicBSONObject temp = new BasicBSONObject();
            temp.put("$ref", (Object)((DBRefBase)val).getRef());
            temp.put("$id", ((DBRefBase)val).getId());
            return temp;
        }
    }
}

