/*
 * Decompiled with CFR 0.152.
 */
package com.informix.csm.crypto;

import com.informix.csm.IfxCsmException;
import com.informix.csm.crypto.IfxCipher;
import com.informix.csm.crypto.IfxCryptoCtx;
import com.informix.csm.crypto.IfxCryptoSession;
import com.informix.csm.crypto.IfxCryptoUtils;
import com.informix.csm.crypto.IfxEDPkt;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.Vector;
import javax.crypto.KeyAgreement;

class IfxEncPkt {
    int SessionID;
    KeyAgreement DH;
    Vector NegoaitedCipherList;
    byte[] NegotiatedMacKey;
    long CipherSwitchTime;
    long SecretSwitchTime;
    char MacLevel;
    short NegotiatedMacLevel;
    int Flags;
    IfxEDPkt Encrypt;
    IfxEDPkt Decrypt;
    IfxCryptoCtx cryptoCtx;

    private void initIfxEncPkt() {
        this.NegoaitedCipherList = new Vector();
        this.Encrypt = new IfxEDPkt();
        this.Decrypt = new IfxEDPkt();
    }

    public IfxEncPkt(IfxCryptoCtx ctx) {
        this.cryptoCtx = ctx;
        this.initIfxEncPkt();
    }

    public IfxEncPkt(int Originator, IfxCryptoCtx ctx) throws IfxCsmException {
        this(ctx);
        int DecryptDir;
        int EncryptDir;
        int status = 0;
        byte[] InitSecret = null;
        BigInteger OrigSecret = null;
        OrigSecret = new BigInteger("A98395B2CA23C77DDA371E56145E3E4788EEC651BDA0A6D684CF6B5868B9", 16);
        InitSecret = IfxCryptoUtils.bigIntegerToBinary(OrigSecret);
        this.Encrypt.SecretKey = InitSecret;
        this.Decrypt.SecretKey = IfxCryptoUtils.createCopy(InitSecret);
        InitSecret = null;
        this.NegotiatedMacKey = this.cryptoCtx.DefaultMAC.Key;
        this.NegotiatedMacLevel = (short)4;
        switch (Originator) {
            case 1: {
                EncryptDir = 1;
                DecryptDir = -1;
                break;
            }
            case 2: {
                EncryptDir = -1;
                DecryptDir = 1;
                break;
            }
            default: {
                EncryptDir = 1;
                DecryptDir = 1;
            }
        }
        this.Encrypt.IV.SubDir = EncryptDir;
        this.Encrypt.MAC.SubDir = EncryptDir;
        this.Decrypt.IV.SubDir = DecryptDir;
        this.Decrypt.MAC.SubDir = DecryptDir;
        status = IfxCipher.initCipher(this, this.Encrypt, 2, 2);
        if (status == 0 && (status = IfxCipher.initCipher(this, this.Decrypt, 2, 2)) == 0) {
            this.Encrypt.CurrentCipher = -1;
            this.Decrypt.CurrentCipher = -1;
            this.SessionID = ++ctx.SessionID;
            if (ctx.DebugEV != null) {
                try {
                    if (IfxCryptoUtils.isClassInClasspath(new String(ctx.DebugEV, "ASCII"))) {
                        this.setFlag(128);
                    }
                }
                catch (UnsupportedEncodingException ex) {
                    throw IfxCryptoSession.getCsmErrException(-15, ex);
                }
            }
        }
        InitSecret = null;
        OrigSecret = null;
        if (status != 0) {
            throw IfxCryptoSession.getCsmErrException(status);
        }
    }

    void setFlag(int flags) {
        this.Flags |= flags;
    }

    boolean isFlagSet(int flags) {
        return IfxCryptoUtils.isFlagSet(this.Flags, flags);
    }

    void clearFlag(int flags) {
        this.Flags &= ~flags;
    }
}

