/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.asf.JnsObject;
import com.informix.jdbc.IfxPreparedStatement;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.jdbc.IfxStatement;
import com.informix.jdbc.PreparedStatementCache;
import com.informix.util.DelayedWeakReference;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import com.informix.util.TraceFlag;
import com.informix.util.dateUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;

public class IfxDriver
implements Driver {
    private static final Object logger = Trace.getLoggerForClass(IfxDriver.class);
    private static Trace trace = null;
    private final String INFORMIXSQLI = "informix-sqli";
    private final String INFORMIXDIRECT = "informix-direct";
    private final String CONNECTIONCLASS = "CONNECTIONCLASS";
    private final String PROTOCOLCLASS = "PROTOCOLCLASS";
    private final String PROXY = "PROXY";
    private final String DEFAULTDIRECTCONN = "com.informix.jdbc.IfxDirectConnection";
    private final String DEFAULTDIRECTPROT = "com.informix.jdbc.IfxDirectProtocol";
    private final String DEFAULTSQLICONN = "com.informix.jdbc.IfxSqliConnect";
    private final String DEFAULTSQLIPROT = "com.informix.jdbc.IfxSqli";
    private String m_dbname = null;
    private String SubProtocol = null;
    private String Proxy = null;
    private String ClientLocale = null;
    private static String staticClientLocale = null;
    private static final String JDBCRelVer = "4.10.J";
    protected static String jdkVersion;
    private static int JDBC_SPEC_MAJOR_VERSION;
    private static int JDBC_SPEC_MINOR_VERSION;

    private static void setJDKVersion() {
        try {
            jdkVersion = System.getProperty("java.version");
        }
        catch (Exception e) {
            System.out.println(IfxErrMsg.getMessage(-79880, (String)null));
        }
    }

    protected static int compareJDKVersion(String str) {
        boolean found = false;
        String partialStr = null;
        if (jdkVersion != null && str != null) {
            int len = jdkVersion.length();
            int i = 0;
            while (!found && i < len) {
                char c = jdkVersion.charAt(i);
                if (c >= '0' && c <= '9') {
                    found = true;
                    continue;
                }
                ++i;
            }
            partialStr = jdkVersion.substring(i);
            return partialStr.compareTo(str);
        }
        throw new Error("Error In Comparing JDK Versions");
    }

    @Override
    public Connection connect(String url, Properties prop) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.checkTracing(url, prop);
        }
        if (!this.acceptsURL(url)) {
            return null;
        }
        this.checkClientLocale(url, prop);
        String newURL = this.checkURL(url);
        Properties newProp = new Properties();
        Connection conn = null;
        if (prop == null) {
            newProp.clear();
        } else {
            String key = null;
            Enumeration<?> e = prop.propertyNames();
            while (e.hasMoreElements()) {
                key = e.nextElement().toString();
                newProp.put(key.toUpperCase(), prop.getProperty(key));
            }
            key = null;
        }
        newProp.put("USERURL", url);
        if (newURL == null && this.SubProtocol.equals("informix-direct")) {
            newURL = url;
        }
        this.getPropertiesFromUrl(url, newProp);
        String newConnectionClass = newProp.getProperty("CONNECTIONCLASS");
        try {
            Class<?> clsRef = Class.forName(newProp.getProperty("CONNECTIONCLASS"));
            if (newConnectionClass.equals("com.informix.jdbc.IfxSqliConnect")) {
                Class[] classArgs = new Class[]{Class.forName("java.lang.String"), Class.forName("java.lang.String"), url.getClass(), newProp.getClass()};
                Object[] objs = new Object[]{newProp.getProperty("USER"), newProp.getProperty("PASSWORD"), newURL, newProp};
                Constructor<?> cons = clsRef.getConstructor(classArgs);
                conn = (Connection)cons.newInstance(objs);
            } else {
                Class[] classArgs = new Class[]{url.getClass(), newProp.getClass()};
                Object[] objs = new Object[]{newURL, newProp};
                Constructor<?> cons = clsRef.getConstructor(classArgs);
                conn = (Connection)cons.newInstance(objs);
            }
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException) {
                Throwable te = ((InvocationTargetException)e).getTargetException();
                throw (SQLException)te;
            }
            SQLException se = IfxErrMsg.getLocSQLException(-79704, e.toString(), this.ClientLocale);
            throw IfxErrMsg.setSQLExceptionCause(se, e);
        }
        return conn;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        if (url == null || url.length() < 13 || !url.substring(0, 13).equalsIgnoreCase("jdbc:informix")) {
            return false;
        }
        return this.validateURL(url);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties prop) throws SQLException {
        DriverPropertyInfo[] displayPropertyInfoList = new DriverPropertyInfo[3];
        if (prop == null) {
            prop = new Properties();
        }
        StringTokenizer tokens = new StringTokenizer(url, "/:=; \t\n\r\f", true);
        int i = 1;
        String protocol = "";
        String dbName = "";
        String user = "";
        String password = "";
        if (tokens != null) {
            while (tokens.hasMoreTokens()) {
                String t = tokens.nextToken();
                if (i == 3) {
                    protocol = t;
                }
                if (i > 3 && protocol.equalsIgnoreCase("informix-sqli")) {
                    if (i == 11) {
                        dbName = t;
                    } else if (i > 11) {
                        if (t.equalsIgnoreCase("user")) {
                            t = tokens.nextToken();
                            user = tokens.nextToken();
                        }
                        if (t.equalsIgnoreCase("password")) {
                            t = tokens.nextToken();
                            password = tokens.nextToken();
                        }
                    }
                }
                ++i;
                if (protocol.length() <= 0 || dbName.length() <= 0 || user.length() <= 0 || password.length() <= 0) continue;
                break;
            }
        }
        for (i = 0; i < 3; ++i) {
            DriverPropertyInfo info = null;
            if (i == 0) {
                info = new DriverPropertyInfo("DATABASE", dbName);
                info.description = "Database for connection";
                info.required = true;
            }
            if (i == 1) {
                if (user.length() == 0 && (prop.contains("user") || prop.contains("USER")) && ((user = prop.getProperty("user")) == null || user.length() == 0)) {
                    user = prop.getProperty("USER");
                }
                info = new DriverPropertyInfo("USER", user);
                info.description = "User name for connection ";
                info.required = true;
            }
            if (i == 2) {
                if (password.length() == 0 && (prop.contains("password") || prop.contains("PASSWORD")) && ((user = prop.getProperty("password")) == null || user.length() == 0)) {
                    user = prop.getProperty("PASSWORD");
                }
                info = new DriverPropertyInfo("PASSWORD", password);
                info.description = "Password for connection ";
                info.required = true;
            }
            displayPropertyInfoList[i] = info;
        }
        return displayPropertyInfoList;
    }

    @Override
    public int getMajorVersion() {
        try {
            return IfxDriver.getJDBCMajorVersion();
        }
        catch (SQLException e) {
            return 0;
        }
    }

    @Override
    public int getMinorVersion() {
        try {
            return IfxDriver.getJDBCMinorVersion();
        }
        catch (SQLException e) {
            return 0;
        }
    }

    public static int getMajorMinorVersion() {
        try {
            int maj = IfxDriver.getJDBCMajorVersion() * 100;
            int min = IfxDriver.getJDBCMinorVersion();
            return maj + min;
        }
        catch (SQLException e) {
            return 0;
        }
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    private synchronized String checkURL(String url) throws SQLException {
        boolean checkSubprotocol = true;
        this.m_dbname = null;
        this.SubProtocol = null;
        boolean gotIpV6Literal = false;
        int poNo = -1;
        String newURL = null;
        if (TraceFlag.isTraceEnabled()) {
            if (trace == null) {
                trace = new Trace();
            }
            trace.writeTrace(logger, 1, "In IfxDriver:checkURL(" + url + ")");
        }
        if (url.indexOf(58) == -1) {
            throw IfxErrMsg.getLocSQLException(-80004, ": '" + IfxErrMsg.getMinorMsg(-80035, this.ClientLocale) + " '" + url + "'" + IfxErrMsg.getMinorMsg(-80004, this.ClientLocale) + " ':'" + "'", this.ClientLocale);
        }
        StringTokenizer urlStartTok = new StringTokenizer(url, ";=", true);
        String urlStart = urlStartTok.nextToken();
        boolean endsColon = false;
        boolean notLDAP = true;
        if (urlStart.charAt(urlStart.length() - 1) == ':') {
            endsColon = true;
        }
        StringTokenizer tok = new StringTokenizer(urlStart, ":", true);
        String jdbc = tok.nextToken();
        if (urlStartTok.hasMoreTokens() && urlStartTok.nextToken().equals("=")) {
            notLDAP = false;
        }
        if (TraceFlag.isTraceEnabled()) {
            trace.writeTrace(logger, 1, "  jdbc is " + jdbc);
        }
        if (!jdbc.equalsIgnoreCase("jdbc")) {
            String errMsg = IfxErrMsg.getMinorMsg(-80035, this.ClientLocale) + " '" + url + "' " + IfxErrMsg.getMessage(-79756, this.ClientLocale);
            if (TraceFlag.isTraceEnabled()) {
                trace.writeTrace(logger, 2, "IfxDriver:checkURL(): " + errMsg);
            }
            throw IfxErrMsg.getLocSQLException(-79756, errMsg, this.ClientLocale);
        }
        tok.nextToken();
        String addr = tok.nextToken();
        if (TraceFlag.isTraceEnabled()) {
            trace.writeTrace(logger, 1, "  protocol: " + addr);
        }
        if (tok.hasMoreTokens()) {
            tok.nextToken();
        }
        if (addr != null && addr.charAt(0) == '/' && addr.charAt(1) == '/') {
            addr = addr.substring(2, addr.length());
        }
        if (addr.equals("informix-sqli")) {
            this.SubProtocol = new String("informix-sqli");
            if (tok.hasMoreTokens()) {
                addr = tok.nextToken();
            }
            if (tok.hasMoreTokens()) {
                tok.nextToken();
            }
        } else if (addr.equals("informix-direct")) {
            this.SubProtocol = new String("informix-direct");
            checkSubprotocol = false;
            if (TraceFlag.isTraceEnabled()) {
                trace.writeTrace(logger, 1, "  check tok for more tokens" + tok);
            }
            if (tok.hasMoreTokens()) {
                addr = tok.nextToken();
                if (TraceFlag.isTraceEnabled()) {
                    trace.writeTrace(logger, 1, "  has more " + addr);
                }
                if (!addr.equals(":") && tok.hasMoreTokens()) {
                    tok.nextToken();
                }
            } else {
                addr = null;
            }
        } else {
            String errMsg = IfxErrMsg.getMessage(-79757, this.ClientLocale) + ": '" + addr + "'";
            if (TraceFlag.isTraceEnabled()) {
                trace.writeTrace(logger, 2, "IfxDriver:checkURL(): " + errMsg);
            }
            throw IfxErrMsg.getLocSQLException(-79757, errMsg, this.ClientLocale);
        }
        if (addr != null && addr.charAt(0) == '/' && addr.charAt(1) == '/') {
            addr = addr.substring(2, addr.length());
            if (checkSubprotocol) {
                gotIpV6Literal = true;
            }
        }
        if (!checkSubprotocol) {
            if (addr != null && addr.length() > 0 && addr.charAt(0) == '/') {
                String dbAndOptionals = addr;
                if (TraceFlag.isTraceEnabled()) {
                    trace.writeTrace(logger, 1, "  !checkSub " + addr);
                }
                StringTokenizer portT = new StringTokenizer(dbAndOptionals, "/");
                String dbName = portT.nextToken();
                if (TraceFlag.isTraceEnabled()) {
                    trace.writeTrace(logger, 1, "  valid dbname? " + dbName);
                }
                if (!this.validDatabaseIdentifier(dbName)) {
                    String errMsg = IfxErrMsg.getMessage(-79760, this.ClientLocale) + ": '" + dbName + "'";
                    if (TraceFlag.isTraceEnabled()) {
                        trace.writeTrace(logger, 2, "IfxDriver:checkURL(): " + errMsg);
                    }
                    throw IfxErrMsg.getLocSQLException(-79760, errMsg, this.ClientLocale);
                }
                this.m_dbname = new String(dbName);
                newURL = null;
            }
        } else {
            int requiredTokens;
            int tokensLeft = tok.countTokens();
            int n = requiredTokens = endsColon ? 3 : 4;
            if (gotIpV6Literal && tokensLeft <= requiredTokens) {
                gotIpV6Literal = false;
            }
            if (gotIpV6Literal) {
                addr = addr + ":";
                while (tokensLeft > requiredTokens) {
                    addr = addr + tok.nextToken();
                    --tokensLeft;
                }
                tok.nextToken();
            }
            StringTokenizer addrT = new StringTokenizer(addr, ".");
            String token1 = addrT.nextToken();
            if (notLDAP || tok.hasMoreTokens()) {
                if (token1.indexOf(47) == -1) {
                    if (!gotIpV6Literal && this.isANum(token1)) {
                        if (addrT.countTokens() != 3 || !this.isAIPNum(token1)) {
                            throw IfxErrMsg.getLocSQLException(-79758, ": '" + addr + "'", this.ClientLocale);
                        }
                        while (addrT.hasMoreTokens()) {
                            token1 = addrT.nextToken();
                            if (this.isAIPNum(token1)) continue;
                            throw IfxErrMsg.getLocSQLException(-79758, ": '" + addr + "'", this.ClientLocale);
                        }
                    } else {
                        while (!gotIpV6Literal && addrT.hasMoreTokens()) {
                            token1 = addrT.nextToken();
                            if (!this.isANum(token1)) continue;
                            throw IfxErrMsg.getLocSQLException(-79758, ": '" + addr + "'", this.ClientLocale);
                        }
                    }
                    if (!tok.hasMoreTokens()) {
                        throw IfxErrMsg.getLocSQLException(-79705, this.ClientLocale);
                    }
                    String port = tok.nextToken();
                    if (tok.hasMoreTokens()) {
                        tok.nextToken();
                    }
                    if (port != null && port.indexOf(47) == -1) {
                        if (!this.isANum(port)) {
                            poNo = JnsObject.getServiceByName(port);
                            if (poNo == -1) {
                                throw IfxErrMsg.getLocSQLException(-79759, ": '" + port + "'", this.ClientLocale);
                            }
                            newURL = new String(addr + ":" + poNo);
                        } else {
                            newURL = new String(addr + ":" + port);
                        }
                    } else if (port != null) {
                        StringTokenizer portT = new StringTokenizer(port, "/");
                        if (!this.isANum(port = portT.nextToken())) {
                            poNo = JnsObject.getServiceByName(port);
                            if (poNo == -1) {
                                throw IfxErrMsg.getLocSQLException(-79759, ": '" + port + "'", this.ClientLocale);
                            }
                            newURL = new String(addr + ":" + poNo);
                        } else {
                            newURL = new String(addr + ":" + port);
                        }
                        String dbName = portT.nextToken(":").substring(1);
                        if (dbName == null || dbName.length() == 0) {
                            String errMsg = IfxErrMsg.getMessage(-79760, this.ClientLocale) + ": '" + dbName + "'";
                            if (TraceFlag.isTraceEnabled()) {
                                trace.writeTrace(logger, 2, "IfxDriver:checkURL(): " + errMsg);
                            }
                            throw IfxErrMsg.getLocSQLException(-79760, errMsg, this.ClientLocale);
                        }
                        if (!this.validDatabaseIdentifier(dbName)) {
                            throw IfxErrMsg.getLocSQLException(-79760, ": '" + dbName + "'", this.ClientLocale);
                        }
                        this.m_dbname = new String(dbName);
                    }
                } else {
                    this.m_dbname = token1.substring(1, token1.length());
                    newURL = null;
                }
            } else {
                newURL = null;
            }
        }
        return newURL;
    }

    private boolean isAIPNum(String s) {
        try {
            int ip = Integer.parseInt(s);
            return ip >= 0 && ip <= 255;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean isANum(String s) {
        try {
            return Integer.valueOf(s) >= 0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private synchronized void getPropertiesFromUrl(String url, Properties prop) throws SQLException {
        int a;
        int lastColon = -1;
        String propertiesStr = null;
        String propStr = null;
        StringTokenizer tok = null;
        StringTokenizer propT = null;
        if (prop.get("DATABASE") == null && this.m_dbname != null) {
            prop.put("DATABASE", this.m_dbname);
        }
        if ((a = url.indexOf(61)) != -1) {
            int b = -1;
            while ((b = url.indexOf(58, (lastColon = b) + 1)) != -1 && b < a) {
            }
            if (lastColon == -1) {
                return;
            }
        }
        if ((propertiesStr = url.substring(lastColon + 1)) != null) {
            if (propertiesStr.startsWith("//") && propertiesStr.contains("SQLH_FILE")) {
                propertiesStr = propertiesStr.substring(2);
            }
            tok = new StringTokenizer(propertiesStr, ";");
        }
        if (propertiesStr != null && propertiesStr.indexOf(61) != -1 && tok.hasMoreTokens()) {
            while (tok.hasMoreTokens()) {
                propStr = tok.nextToken(";");
                propT = new StringTokenizer(propStr, "=");
                String key = propT.nextToken();
                String value = propT.nextToken(";").substring(1);
                if (TraceFlag.isTraceEnabled() && !key.equalsIgnoreCase("password")) {
                    trace.writeTrace(logger, 3, "IfxDriver:GetPropertiesfromUrl(): key = '" + key + "'  value = '" + value + "'");
                }
                if (key.equalsIgnoreCase("CSM")) {
                    if (value == null || !value.startsWith("(") || !value.endsWith(")")) {
                        throw IfxErrMsg.getLocSQLException(-79705, this.ClientLocale);
                    }
                    String csm_value = value.substring(1, value.length() - 1);
                    prop.put("CSM", csm_value);
                    continue;
                }
                prop.put(key.toUpperCase(), value);
            }
        }
        if (this.SubProtocol.equals("informix-direct")) {
            if (prop.get("PROTOCOLCLASS") == null) {
                prop.put("PROTOCOLCLASS", "com.informix.jdbc.IfxDirectProtocol");
                if (TraceFlag.isTraceEnabled()) {
                    trace.writeTrace(logger, 3, "IfxDriver:getPropertiesFromUrl(): PROTOCOLCLASS set to 'com.informix.jdbc.IfxDirectProtocol'");
                }
            }
            if (prop.get("CONNECTIONCLASS") == null) {
                prop.put("CONNECTIONCLASS", "com.informix.jdbc.IfxDirectConnection");
                if (TraceFlag.isTraceEnabled()) {
                    trace.writeTrace(logger, 3, "IfxDriver:getPropertiesFromUrl(): CONNECTIONCLASS set to 'com.informix.jdbc.IfxDirectConnection'");
                }
            }
            if (TraceFlag.isTraceEnabled()) {
                trace.writeTrace(logger, 3, "IfxDriver:database is " + prop.get("DATABASE"));
            }
        } else {
            if (prop.get("PROTOCOLCLASS") == null) {
                prop.put("PROTOCOLCLASS", "com.informix.jdbc.IfxSqli");
            }
            if (prop.get("CONNECTIONCLASS") == null) {
                prop.put("CONNECTIONCLASS", "com.informix.jdbc.IfxSqliConnect");
            }
            if (TraceFlag.isTraceEnabled()) {
                trace.writeTrace(logger, 3, "IfxDriver:getPropertiesFromUrl(): PROTOCOLCLASS set to 'com.informix.jdbc.IfxSqli'");
                trace.writeTrace(logger, 3, "IfxDriver:getPropertiesFromUrl(): CONNECTIONCLASS set to 'com.informix.jdbc.IfxSqliConnect'");
            }
        }
        if ((this.Proxy = prop.getProperty("PROXY")) != null) {
            this.formatProxy(this.Proxy);
            prop.put("PROXY", this.Proxy);
            if (TraceFlag.isTraceEnabled()) {
                trace.writeTrace(logger, 3, "IfxDriver:getPropertiesFromUrl(): PROXY set to '" + this.Proxy + "'");
            }
        }
    }

    private void checkTracing(String url, Properties prop) {
        if (TraceFlag.compiletrace) {
            short traceLevel;
            int index;
            String traceFile = prop.getProperty("TRACEFILE");
            String traceLevelString = prop.getProperty("TRACE");
            if ((traceFile == null || traceLevelString == null) && (index = url.indexOf("trace")) != -1) {
                String propStr = null;
                propStr = url.substring(index, url.length());
                StringTokenizer tok = new StringTokenizer(propStr, ";");
                while (tok.hasMoreTokens()) {
                    String entry = tok.nextToken(";");
                    if (entry.indexOf(61) == -1) continue;
                    StringTokenizer propT = new StringTokenizer(entry, "=");
                    String key = propT.nextToken();
                    String value = propT.hasMoreTokens() ? propT.nextToken() : null;
                    if (key.equals("tracefile")) {
                        traceFile = value;
                        continue;
                    }
                    if (!key.equals("trace")) continue;
                    traceLevelString = value;
                }
            }
            try {
                Integer i = Integer.valueOf(traceLevelString);
                traceLevel = i.shortValue();
            }
            catch (NumberFormatException e) {
                traceLevel = 0;
            }
            if (traceFile != null && traceLevel > 0) {
                trace.setNewTraceFile(traceLevel, traceFile);
            }
        }
    }

    private void checkClientLocale(String url, Properties prop) {
        int index;
        String clocale = prop.getProperty("CLIENT_LOCALE");
        if (clocale == null && (index = url.indexOf("CLIENT_LOCALE")) != -1) {
            String propStr = null;
            propStr = url.substring(index, url.length());
            StringTokenizer tok = new StringTokenizer(propStr, ";");
            while (tok.hasMoreTokens()) {
                String entry = tok.nextToken(";");
                if (entry.indexOf(61) == -1) continue;
                StringTokenizer propT = new StringTokenizer(entry, "=");
                String key = propT.nextToken();
                String value = propT.hasMoreTokens() ? propT.nextToken() : null;
                if (!key.equals("CLIENT_LOCALE")) continue;
                clocale = value;
            }
        }
        if (clocale != null) {
            this.ClientLocale = new String(clocale);
            this.setStaticClientLocale(clocale);
        }
    }

    private void setStaticClientLocale(String clocale) {
        staticClientLocale = clocale;
    }

    private boolean validDatabaseIdentifier(String dbName) {
        int i = 1;
        int index = 0;
        String dbnam = null;
        index = dbName.lastIndexOf(47);
        dbnam = index != -1 ? dbName.substring(index + 1) : dbName;
        int len = dbnam.length();
        char c = dbnam.charAt(0);
        if (!Character.isLetter(c) && c != '_') {
            return false;
        }
        for (i = 1; i < len; ++i) {
            c = dbnam.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_' || c == '#') continue;
            return false;
        }
        return true;
    }

    private static String calcReleaseNum() {
        long origDateNum = 2455827L;
        String relNumStr = null;
        String strToday = "2014-03-10";
        long jdate = dateUtil.gregToJulian(strToday);
        int relNum = (int)(jdate - origDateNum);
        relNumStr = relNum < 0 ? "000" : (relNum < 10 ? "00" + relNum : (relNum < 100 ? "0" + relNum : (relNum > 999 ? "999" : "" + relNum)));
        return relNumStr;
    }

    public static String getJDBCVersion() throws SQLException {
        return "4.10.JC4N" + IfxDriver.calcReleaseNum();
    }

    static int getJDBCMajorVersion() throws SQLException {
        return JDBC_SPEC_MAJOR_VERSION;
    }

    static int extractMajorVersion(String version) throws SQLException {
        Integer major;
        StringTokenizer tok = new StringTokenizer(version, ".");
        String majorString = tok.nextToken();
        try {
            major = Integer.valueOf(majorString);
        }
        catch (NumberFormatException e) {
            if (TraceFlag.isTraceEnabled()) {
                trace.writeTrace(logger, 2, "IfxDriver:getMajorVersion(): caught exception: " + e.toString());
            }
            throw IfxErrMsg.getLocSQLException(-79716, staticClientLocale);
        }
        return major;
    }

    static int extractMinorVersion(String version) throws SQLException {
        Integer minor;
        StringTokenizer tok = new StringTokenizer(version, ".");
        if (!tok.hasMoreTokens()) {
            throw IfxErrMsg.getLocSQLException(-79716, staticClientLocale);
        }
        tok.nextToken();
        if (!tok.hasMoreTokens()) {
            throw IfxErrMsg.getLocSQLException(-79716, staticClientLocale);
        }
        String minorString = tok.nextToken();
        try {
            minor = Integer.valueOf(minorString);
        }
        catch (NumberFormatException e) {
            if (TraceFlag.isTraceEnabled()) {
                trace.writeTrace(logger, 2, "IfxDriver:getMinorVersion(): caught exception: " + e.toString());
            }
            throw IfxErrMsg.getLocSQLException(-79716, staticClientLocale);
        }
        return minor;
    }

    static int getJDBCMinorVersion() throws SQLException {
        return JDBC_SPEC_MINOR_VERSION;
    }

    private boolean formatProxy(String str) {
        String strT = null;
        String sub1 = null;
        String sub2 = null;
        String defHost = null;
        StringBuffer sb = new StringBuffer("http://");
        int i = str.indexOf(63);
        if (i != -1) {
            sub1 = str.substring(0, i);
            sub2 = str.substring(i, str.length());
        } else {
            sub1 = str;
        }
        try {
            defHost = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(sub1, "/");
        while (st.hasMoreTokens()) {
            strT = st.nextToken();
            if (strT.toUpperCase().indexOf("HTTP") != -1 || strT.toUpperCase().indexOf("SERVLET") != -1 || strT.toUpperCase().indexOf("JDBCPROXY") != -1) continue;
            defHost = strT;
        }
        sb.append(defHost);
        sb.append("/servlet/IfxJDBCProxy");
        if (sub2 != null) {
            sb.append(sub2);
        }
        this.Proxy = new String(sb.toString());
        return true;
    }

    private boolean validateURL(String url) throws SQLException {
        boolean checkSubprotocol = true;
        String ClientLocale = null;
        boolean gotIpV6Literal = false;
        int poNo = -1;
        if (TraceFlag.isTraceEnabled() && trace == null) {
            trace = new Trace();
        }
        if (url.indexOf(58) == -1) {
            throw IfxErrMsg.getLocSQLException(-80004, ": '" + IfxErrMsg.getMinorMsg(-80035, ClientLocale) + " '" + url + "'" + IfxErrMsg.getMinorMsg(-80004, ClientLocale) + " ':'" + "'", ClientLocale);
        }
        StringTokenizer urlStartTok = new StringTokenizer(url, ";=", true);
        String urlStart = urlStartTok.nextToken();
        boolean endsColon = false;
        boolean notLDAP = true;
        if (urlStart.charAt(urlStart.length() - 1) == ':') {
            endsColon = true;
        }
        StringTokenizer tok = new StringTokenizer(urlStart, ":", true);
        String jdbc = tok.nextToken();
        if (urlStartTok.hasMoreTokens() && urlStartTok.nextToken().equals("=")) {
            notLDAP = false;
        }
        if (!jdbc.equalsIgnoreCase("jdbc")) {
            String errMsg = IfxErrMsg.getMinorMsg(-80035, ClientLocale) + " '" + url + "' " + IfxErrMsg.getMessage(-79756, ClientLocale);
            if (TraceFlag.isTraceEnabled()) {
                trace.writeTrace(logger, 2, "IfxDriver:checkURL(): " + errMsg);
            }
            throw IfxErrMsg.getLocSQLException(-79756, errMsg, ClientLocale);
        }
        tok.nextToken();
        String addr = tok.nextToken();
        if (tok.hasMoreTokens()) {
            tok.nextToken();
        }
        if (addr != null && addr.charAt(0) == '/' && addr.charAt(1) == '/') {
            addr = addr.substring(2, addr.length());
        }
        if (addr.equals("informix-sqli")) {
            if (tok.hasMoreTokens()) {
                addr = tok.nextToken();
            }
            if (tok.hasMoreTokens()) {
                tok.nextToken();
            }
        } else if (addr.equals("informix-direct")) {
            checkSubprotocol = false;
            if (TraceFlag.isTraceEnabled()) {
                trace.writeTrace(logger, 1, "  check tok for more tokens" + tok);
            }
            if (tok.hasMoreTokens()) {
                addr = tok.nextToken();
                if (TraceFlag.isTraceEnabled()) {
                    trace.writeTrace(logger, 1, "  has more " + addr);
                }
                if (!addr.equals(":") && tok.hasMoreTokens()) {
                    tok.nextToken();
                }
            } else {
                addr = null;
            }
        } else {
            String errMsg = IfxErrMsg.getMessage(-79757, ClientLocale) + ": '" + addr + "'";
            if (TraceFlag.isTraceEnabled()) {
                trace.writeTrace(logger, 2, "IfxDriver:checkURL(): " + errMsg);
            }
            throw IfxErrMsg.getLocSQLException(-79757, errMsg, ClientLocale);
        }
        if (addr != null && addr.charAt(0) == '/' && addr.charAt(1) == '/') {
            addr = addr.substring(2, addr.length());
            if (checkSubprotocol) {
                gotIpV6Literal = true;
            }
        }
        if (!checkSubprotocol) {
            if (addr != null && addr.length() > 0 && addr.charAt(0) == '/') {
                String dbAndOptionals = addr;
                if (TraceFlag.isTraceEnabled()) {
                    trace.writeTrace(logger, 1, "  !checkSub " + addr);
                }
                StringTokenizer portT = new StringTokenizer(dbAndOptionals, "/");
                String dbName = portT.nextToken();
                if (TraceFlag.isTraceEnabled()) {
                    trace.writeTrace(logger, 1, "  valid dbname? " + dbName);
                }
                if (!this.validDatabaseIdentifier(dbName)) {
                    String errMsg = IfxErrMsg.getMessage(-79760, ClientLocale) + ": '" + dbName + "'";
                    if (TraceFlag.isTraceEnabled()) {
                        trace.writeTrace(logger, 2, "IfxDriver:checkURL(): " + errMsg);
                    }
                    throw IfxErrMsg.getLocSQLException(-79760, errMsg, ClientLocale);
                }
            }
        } else {
            int requiredTokens;
            int tokensLeft = tok.countTokens();
            int n = requiredTokens = endsColon ? 3 : 4;
            if (gotIpV6Literal && tokensLeft <= requiredTokens) {
                gotIpV6Literal = false;
            }
            if (gotIpV6Literal) {
                addr = addr + ":";
                while (tokensLeft > requiredTokens) {
                    addr = addr + tok.nextToken();
                    --tokensLeft;
                }
                tok.nextToken();
            }
            StringTokenizer addrT = new StringTokenizer(addr, ".");
            String token1 = addrT.nextToken();
            if ((notLDAP || tok.hasMoreTokens()) && token1.indexOf(47) == -1) {
                if (!gotIpV6Literal && this.isANum(token1)) {
                    if (addrT.countTokens() != 3 || !this.isAIPNum(token1)) {
                        throw IfxErrMsg.getLocSQLException(-79758, ": '" + addr + "'", ClientLocale);
                    }
                    while (addrT.hasMoreTokens()) {
                        token1 = addrT.nextToken();
                        if (this.isAIPNum(token1)) continue;
                        throw IfxErrMsg.getLocSQLException(-79758, ": '" + addr + "'", ClientLocale);
                    }
                } else {
                    while (!gotIpV6Literal && addrT.hasMoreTokens()) {
                        token1 = addrT.nextToken();
                        if (!this.isANum(token1)) continue;
                        throw IfxErrMsg.getLocSQLException(-79758, ": '" + addr + "'", ClientLocale);
                    }
                }
                if (!tok.hasMoreTokens()) {
                    throw IfxErrMsg.getLocSQLException(-79705, ClientLocale);
                }
                String port = tok.nextToken();
                if (tok.hasMoreTokens()) {
                    tok.nextToken();
                }
                if (port != null && port.indexOf(47) == -1) {
                    if (!this.isANum(port) && (poNo = JnsObject.getServiceByName(port)) == -1) {
                        throw IfxErrMsg.getLocSQLException(-79759, ": '" + port + "'", ClientLocale);
                    }
                } else if (port != null) {
                    StringTokenizer portT = new StringTokenizer(port, "/");
                    if (!this.isANum(port = portT.nextToken()) && (poNo = JnsObject.getServiceByName(port)) == -1) {
                        throw IfxErrMsg.getLocSQLException(-79759, ": '" + port + "'", ClientLocale);
                    }
                    String dbName = portT.nextToken(":").substring(1);
                    if (dbName == null || dbName.length() == 0) {
                        String errMsg = IfxErrMsg.getMessage(-79760, ClientLocale) + ": '" + dbName + "'";
                        if (TraceFlag.isTraceEnabled()) {
                            trace.writeTrace(logger, 2, "IfxDriver:checkURL(): " + errMsg);
                        }
                        throw IfxErrMsg.getLocSQLException(-79760, errMsg, ClientLocale);
                    }
                    if (!this.validDatabaseIdentifier(dbName)) {
                        throw IfxErrMsg.getLocSQLException(-79760, ": '" + dbName + "'", ClientLocale);
                    }
                }
            }
        }
        return true;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    public static List<BSONObject> getPreparedStatementInfo() {
        DelayedWeakReference<PreparedStatementCache>[] arrayOfCaches;
        ArrayList<BSONObject> pstmtInfos = new ArrayList<BSONObject>();
        block2: for (DelayedWeakReference<PreparedStatementCache> dwrPsCache : arrayOfCaches = PreparedStatementCache.getPreparedStatementCaches()) {
            IfxSqliConnect.StmtList[] stmtArray;
            IfxSqliConnect connection;
            PreparedStatementCache psCache;
            if (dwrPsCache == null || dwrPsCache.isEnqueued() || (psCache = (PreparedStatementCache)dwrPsCache.get()) == null || psCache.connectionWeakReference == null || psCache.connectionWeakReference.isEnqueued() || (connection = (IfxSqliConnect)psCache.connectionWeakReference.get()) == null) break;
            for (IfxSqliConnect.StmtList node : stmtArray = connection.stmtList.toArray(new IfxSqliConnect.StmtList[0])) {
                if (node.weakReferenceStmt == null || node.weakReferenceStmt.isEnqueued()) continue block2;
                IfxStatement stmt = (IfxStatement)node.weakReferenceStmt.get();
                if (stmt == null) continue;
                BasicBSONObject pstmtInfo = new BasicBSONObject();
                if (stmt instanceof IfxPreparedStatement) {
                    IfxPreparedStatement pstmt = (IfxPreparedStatement)stmt;
                    pstmtInfo.put("sql", (Object)pstmt.baseStatement);
                    pstmtInfo.put("closed", (Object)pstmt.Closed);
                    pstmtInfo.put("currentResultIsNull", (Object)(pstmt.currentResult == null ? 1 : 0));
                    if (pstmt.jconn != null) {
                        try {
                            pstmtInfo.put("url", (Object)pstmt.jconn.getURL());
                        }
                        catch (SQLException e) {
                            // empty catch block
                        }
                    }
                }
                pstmtInfos.add((BSONObject)pstmtInfo);
            }
        }
        return pstmtInfos;
    }

    static {
        JDBC_SPEC_MAJOR_VERSION = 3;
        JDBC_SPEC_MINOR_VERSION = 0;
        try {
            DriverManager.registerDriver(new IfxDriver());
        }
        catch (SQLException e) {
            System.out.println(IfxErrMsg.getMinorMsg(-80034, (String)null) + " " + -79704 + "\n" + IfxErrMsg.getMessage(-79704, (String)null));
        }
        if (TraceFlag.isTraceEnabled()) {
            trace = new Trace();
        }
        IfxDriver.setJDKVersion();
    }
}

