/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxConnectionProperty;
import com.informix.jdbc.IfxPreparedStatement;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.util.DelayedWeakReference;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;

public class PreparedStatementCache
extends LinkedHashMap<String, IfxPreparedStatement> {
    private static final long serialVersionUID = 1L;
    private static final BlockingQueue<DelayedWeakReference<PreparedStatementCache>> queueOfCaches = new DelayQueue<DelayedWeakReference<PreparedStatementCache>>();
    private static final MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();
    private static final AtomicLong referenceQueuePreparedStatementClosedCount = new AtomicLong();
    private static final ReferenceQueue<PreparedStatement> preparedStatementReferenceQueue = new ReferenceQueue();
    final WeakReference<IfxSqliConnect> connectionWeakReference;
    private int maximumEntries;
    protected final int initialMaximumEntries;
    protected final int zeroPointPercentage;
    protected final long minimumDelay;
    protected final long maximumDelay;

    public static List<BSONObject> getCacheInfo() {
        DelayedWeakReference<PreparedStatementCache>[] arrayOfCaches = PreparedStatementCache.getPreparedStatementCaches();
        ArrayList<BSONObject> cacheInfos = new ArrayList<BSONObject>();
        for (DelayedWeakReference<PreparedStatementCache> dwrPsc : arrayOfCaches) {
            PreparedStatementCache psc = (PreparedStatementCache)dwrPsc.get();
            BasicBSONObject cacheInfo = new BasicBSONObject();
            if (psc == null || dwrPsc.isEnqueued()) continue;
            cacheInfo.put("size", (Object)psc.size());
        }
        return cacheInfos;
    }

    public static DelayedWeakReference<PreparedStatementCache>[] getPreparedStatementCaches() {
        DelayedWeakReference[] arrayOfCaches = queueOfCaches.toArray(new DelayedWeakReference[0]);
        return arrayOfCaches;
    }

    public static double computeUsedHeapPercentage() {
        long heapUsed = memoryBean.getHeapMemoryUsage().getUsed();
        long heapMax = memoryBean.getHeapMemoryUsage().getMax();
        double percentUsed = (double)(heapUsed * 100L) / (double)heapMax;
        return percentUsed;
    }

    public PreparedStatementCache(IfxSqliConnect connection, int maximumEntries) {
        super(maximumEntries + 1, 1.0f, false);
        this.connectionWeakReference = new WeakReference<IfxSqliConnect>(connection);
        this.maximumEntries = maximumEntries;
        this.initialMaximumEntries = maximumEntries;
        this.zeroPointPercentage = IfxConnectionProperty.IFMXCONNECTION_CLEANER_ZEROPOINT.getIntValue(connection);
        this.minimumDelay = IfxConnectionProperty.IFMXCONNECTION_CLEANER_DELAY_MINIMUM.getLongValue(connection);
        this.maximumDelay = IfxConnectionProperty.IFMXCONNECTION_CLEANER_DELAY_MAXIMUM.getLongValue(connection);
        queueOfCaches.offer(new DelayedWeakReference<PreparedStatementCache>(this, 0L));
    }

    public synchronized int getMaximumEntries() {
        return this.maximumEntries;
    }

    public synchronized void setMaximumEntries(int maximumEntries) {
        this.maximumEntries = maximumEntries;
        if (this.size() > maximumEntries) {
            Set<String> keySet = this.keySet();
            Iterator<String> iterator = keySet.iterator();
            ArrayList<String> keysToRemove = new ArrayList<String>();
            int i = 0;
            while (iterator.hasNext()) {
                String key = iterator.next();
                if (i >= maximumEntries) {
                    keysToRemove.add(key);
                }
                ++i;
            }
            for (String key : keysToRemove) {
                this.remove(key);
            }
        }
    }

    @Override
    public synchronized IfxPreparedStatement get(Object key) {
        return (IfxPreparedStatement)super.get(key);
    }

    @Override
    protected synchronized boolean removeEldestEntry(Map.Entry<String, IfxPreparedStatement> eldest) {
        if (this.size() > this.maximumEntries) {
            IfxPreparedStatement preparedStatement = eldest.getValue();
            if (preparedStatement != null) {
                try {
                    preparedStatement.superClose();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized IfxPreparedStatement remove(Object id) {
        return (IfxPreparedStatement)super.remove(id);
    }

    @Override
    public synchronized void clear() {
        for (IfxPreparedStatement preparedStatement : this.values()) {
            try {
                if (preparedStatement == null) continue;
                preparedStatement.close();
            }
            catch (SQLException sQLException) {}
        }
        super.clear();
    }

    @Override
    public synchronized boolean containsValue(Object value) {
        return super.containsValue(value);
    }

    @Override
    public synchronized int size() {
        return super.size();
    }

    @Override
    public synchronized boolean isEmpty() {
        return super.isEmpty();
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        return super.containsKey(key);
    }

    @Override
    public synchronized IfxPreparedStatement put(String key, IfxPreparedStatement value) {
        return super.put(key, value);
    }

    @Override
    public synchronized void putAll(Map<? extends String, ? extends IfxPreparedStatement> m) {
        super.putAll(m);
    }

    @Override
    public synchronized Object clone() {
        return super.clone();
    }

    @Override
    public synchronized Set<String> keySet() {
        return super.keySet();
    }

    @Override
    public synchronized Collection<IfxPreparedStatement> values() {
        return super.values();
    }

    @Override
    public synchronized Set<Map.Entry<String, IfxPreparedStatement>> entrySet() {
        return super.entrySet();
    }

    @Override
    public synchronized boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public synchronized int hashCode() {
        return super.hashCode();
    }

    static {
        PreparedStatementCleanupThread psct = new PreparedStatementCleanupThread();
        psct.start();
    }

    static class PreparedStatementCleanupThread
    extends Thread {
        PreparedStatementCleanupThread() {
            this.setPriority(10);
            this.setName("Informix-PreparedStatementCacheCleanupThread");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        PreparedStatementCache psCache;
                        DelayedWeakReference wrPsCache;
                        if ((wrPsCache = (DelayedWeakReference)queueOfCaches.poll(15L, TimeUnit.SECONDS)) == null || (psCache = (PreparedStatementCache)wrPsCache.get()) == null) {
                            continue;
                        }
                        double usedHeapPercentage = PreparedStatementCache.computeUsedHeapPercentage();
                        long delay = PreparedStatementCleanupThread.computeIdealDelay(usedHeapPercentage, psCache);
                        queueOfCaches.offer(new DelayedWeakReference<PreparedStatementCache>(psCache, delay));
                        int cacheSize = PreparedStatementCleanupThread.computeIdealCacheSize(usedHeapPercentage, psCache);
                        psCache.setMaximumEntries(cacheSize);
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        public static int computeIdealCacheSize(double usedHeapPercentage, PreparedStatementCache psCache) {
            if (usedHeapPercentage > (double)psCache.zeroPointPercentage) {
                return 0;
            }
            int maximumEntries = psCache.initialMaximumEntries;
            double slope = (double)(-maximumEntries) / (double)psCache.zeroPointPercentage;
            double idealEntries = slope * usedHeapPercentage + (double)maximumEntries;
            return Double.valueOf(Math.ceil(idealEntries)).intValue();
        }

        public static long computeIdealDelay(double usedHeapPercentage, PreparedStatementCache psCache) {
            if (usedHeapPercentage < (double)psCache.zeroPointPercentage) {
                return psCache.maximumDelay;
            }
            double slope = (double)(psCache.minimumDelay - psCache.maximumDelay) / (double)psCache.zeroPointPercentage;
            double idealDelay = slope * usedHeapPercentage + (double)psCache.maximumDelay;
            return Double.valueOf(Math.ceil(idealDelay)).intValue();
        }
    }
}

