/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbcx;

import com.informix.jdbcx.IfxConnectionEventListener;
import com.informix.jdbcx.IfxConnectionPoolDataSourceFactory;
import com.informix.jdbcx.IfxCoreDataSource;
import com.informix.jdbcx.IfxPooledConnection;
import com.informix.util.IfxErrMsg;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.Constructor;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public class IfxConnectionPoolDataSource
extends IfxCoreDataSource
implements ConnectionPoolDataSource,
Referenceable {
    private static Properties defProp = null;
    private Set connectionsFromServer = Collections.synchronizedSet(new HashSet());
    private Constructor directReUsableCons = null;
    private boolean isDirect = false;
    private boolean isDirectChecked = false;
    static boolean isPrimaryUp = false;

    public void setReUsableCons(Constructor cons) {
        this.directReUsableCons = cons;
    }

    public Constructor getReUsableCons() {
        return this.directReUsableCons;
    }

    @Override
    public PooledConnection getPooledConnection() throws SQLException {
        String DSUser = this.getUser();
        String DSPassword = this.getPassword();
        if (DSUser == null || DSPassword == null) {
            throw IfxErrMsg.getLocSQLException(-79811, this.getIfxCLIENT_LOCALE());
        }
        return new IfxPooledConnection(DSUser, DSPassword, this);
    }

    @Override
    public PooledConnection getPooledConnection(String luser, String lpassword) throws SQLException {
        return new IfxPooledConnection(luser, lpassword, this);
    }

    public PooledConnection getPooledConnection(String luser, String lpassword, IfxConnectionEventListener listener) throws SQLException {
        IfxPooledConnection pc = new IfxPooledConnection(luser, lpassword, this);
        pc.addConnectionEventListener(listener);
        return pc;
    }

    protected void checkMaxConnections() throws SQLException {
        int limit = this.getIfxCPMMaxConnections();
        if (limit != -1 && this.connectionsFromServer.size() >= limit) {
            throw IfxErrMsg.getLocSQLException(-79831, this.getIfxCLIENT_LOCALE());
        }
    }

    protected void addToReferenceList(IfxPooledConnection conn) {
        this.connectionsFromServer.add(conn);
    }

    protected void removeFromReferenceList(IfxPooledConnection conn) {
        this.connectionsFromServer.remove(conn);
    }

    protected int getConnectionCount() {
        return this.connectionsFromServer.size();
    }

    @Override
    public Reference getReference() throws NamingException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.writeProperties(out);
            return new Reference(IfxConnectionPoolDataSource.class.getName(), new StringRefAddr("CPDSProperties", ((Object)out).toString()), IfxConnectionPoolDataSourceFactory.class.getName(), null);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setIfxCPMMaxConnections(int limit) {
        this.DSProperties.setProperty("IFMX_CPM_MAX_CONNECTIONS", Integer.valueOf(limit).toString());
    }

    public void setMaxStatements(int limit) throws SQLException {
    }

    public int getIfxCPMMaxConnections() {
        this.value = this.DSProperties.getProperty("IFMX_CPM_MAX_CONNECTIONS");
        if (this.value == null) {
            this.value = defProp.getProperty("IFMX_CPM_MAX_CONNECTIONS");
        }
        return Integer.parseInt(this.value);
    }

    public int getMaxStatements() throws SQLException {
        return 0;
    }

    public void setIfxCPMInitPoolSize(int init) {
        this.DSProperties.setProperty("IFMX_CPM_INIT_POOLSIZE", Integer.valueOf(init).toString());
    }

    public void setInitialPoolSize(int init) {
        this.setIfxCPMInitPoolSize(init);
    }

    public int getIfxCPMInitPoolSize() {
        this.value = this.DSProperties.getProperty("IFMX_CPM_INIT_POOLSIZE");
        if (this.value == null) {
            this.value = defProp.getProperty("IFMX_CPM_INIT_POOLSIZE");
        }
        return Integer.parseInt(this.value);
    }

    public int getInitialPoolSize() {
        return this.getIfxCPMInitPoolSize();
    }

    public void setIfxCPMMaxPoolSize(int max) {
        this.DSProperties.setProperty("IFMX_CPM_MAX_POOLSIZE", Integer.valueOf(max).toString());
    }

    public void setMaxPoolSize(int max) {
        if (max == 0) {
            this.setIfxCPMMaxPoolSize(-1);
        } else {
            this.setIfxCPMMaxPoolSize(max);
        }
    }

    public int getIfxCPMMaxPoolSize() {
        this.value = this.DSProperties.getProperty("IFMX_CPM_MAX_POOLSIZE");
        if (this.value == null) {
            this.value = defProp.getProperty("IFMX_CPM_MAX_POOLSIZE");
        }
        return Integer.parseInt(this.value);
    }

    public int getMaxPoolSize() {
        int maxPoolSize = this.getIfxCPMMaxPoolSize();
        if (maxPoolSize == -1) {
            return 0;
        }
        return maxPoolSize;
    }

    public void setIfxCPMMinPoolSize(int min) {
        this.DSProperties.setProperty("IFMX_CPM_MIN_POOLSIZE", String.valueOf(min));
    }

    public void setMinPoolSize(int min) {
        this.setIfxCPMMinPoolSize(min);
    }

    public int getIfxCPMMinPoolSize() {
        this.value = this.DSProperties.getProperty("IFMX_CPM_MIN_POOLSIZE");
        if (this.value == null) {
            this.value = defProp.getProperty("IFMX_CPM_MIN_POOLSIZE");
        }
        return Integer.parseInt(this.value);
    }

    public int getMinPoolSize() {
        return this.getIfxCPMMinPoolSize();
    }

    public void setIfxCPMMinAgeLimit(long ageLimit) {
        this.DSProperties.setProperty("IFMX_CPM_MIN_AGELIMIT", new Long(ageLimit).toString());
    }

    public long getIfxCPMMinAgeLimit() {
        this.value = this.DSProperties.getProperty("IFMX_CPM_MIN_AGELIMIT");
        if (this.value == null) {
            this.value = defProp.getProperty("IFMX_CPM_MIN_AGELIMIT");
        }
        return Long.parseLong(this.value);
    }

    public void setIfxCPMAgeLimit(long ageLimit) {
        this.DSProperties.setProperty("IFMX_CPM_AGELIMIT", new Long(ageLimit).toString());
    }

    public void setMaxIdleTime(int ageLimit) {
        if (ageLimit == 0) {
            this.setIfxCPMAgeLimit(-1L);
        } else {
            this.setIfxCPMAgeLimit(ageLimit);
        }
    }

    public long getIfxCPMAgeLimit() {
        this.value = this.DSProperties.getProperty("IFMX_CPM_AGELIMIT");
        if (this.value == null) {
            this.value = defProp.getProperty("IFMX_CPM_AGELIMIT");
        }
        return Long.parseLong(this.value);
    }

    public int getMaxIdleTime() {
        int ageLimit = (int)this.getIfxCPMAgeLimit();
        if (ageLimit == -1) {
            return 0;
        }
        return ageLimit;
    }

    public void setPropertyCycle(int cyc) throws SQLException {
    }

    public int getPropertyCycle() throws SQLException {
        this.value = this.DSProperties.getProperty("IFMX_CPM_SERVICE_INTERVAL");
        if (this.value == null) {
            this.value = defProp.getProperty("IFMX_CPM_SERVICE_INTERVAL");
        }
        return Integer.parseInt(this.value);
    }

    public void setIfxCPMServiceInterval(long interval) {
        this.DSProperties.setProperty("IFMX_CPM_SERVICE_INTERVAL", new Long(interval).toString());
    }

    public long getIfxCPMServiceInterval() {
        this.value = this.DSProperties.getProperty("IFMX_CPM_SERVICE_INTERVAL");
        if (this.value == null) {
            this.value = defProp.getProperty("IFMX_CPM_SERVICE_INTERVAL");
        }
        return Long.parseLong(this.value);
    }

    public void setIfxCPMSwitchHDRPool(boolean hdrFlag) {
        this.DSProperties.setProperty("IFMX_CPM_ENABLE_SWITCH_HDR_POOL", new Boolean(hdrFlag).toString());
    }

    public boolean getIfxCPMSwitchHDRPool() {
        this.value = this.DSProperties.getProperty("IFMX_CPM_ENABLE_SWITCH_HDR_POOL");
        if (this.value == null) {
            this.value = defProp.getProperty("IFMX_CPM_ENABLE_SWITCH_HDR_POOL");
        }
        return Boolean.valueOf(this.value);
    }

    public boolean checkIsDirect() {
        if (this.isDirectChecked) {
            return this.isDirect;
        }
        String proto = this.DSProperties.getProperty("PROTOCOLCLASS");
        if (proto != null && proto.equalsIgnoreCase("com.informix.jdbc.IfxDirectProtocol")) {
            this.isDirect = true;
        }
        this.isDirectChecked = true;
        return this.isDirect;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    static {
        defProp = new Properties();
        defProp.setProperty("IFMX_CPM_MAX_CONNECTIONS", "-1");
        defProp.setProperty("IFMX_CPM_INIT_POOLSIZE", "0");
        defProp.setProperty("IFMX_CPM_MAX_POOLSIZE", "50");
        defProp.setProperty("IFMX_CPM_MIN_POOLSIZE", "0");
        defProp.setProperty("IFMX_CPM_MIN_AGELIMIT", "-1");
        defProp.setProperty("IFMX_CPM_AGELIMIT", "-1");
        defProp.setProperty("IFMX_CPM_SERVICE_INTERVAL", "50");
        defProp.setProperty("IFMX_CPM_ENABLE_SWITCH_HDRPOOL", new Boolean(false).toString());
    }
}

